/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.helper.parameter;

import java.util.List;
import org.mule.extension.webcrawler.internal.constant.Constants;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class CrawlerTargetPagesParameters {
    @Parameter
    @Alias(value="maxDepth")
    @DisplayName(value="Maximum depth")
    @Summary(value="The maximum level of depth that can be reached while crawling a website.")
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Example(value="2")
    private int maxDepth;
    @Parameter
    @Alias(value="restrictToPath")
    @DisplayName(value="Restrict crawl under URL")
    @Summary(value="If true only internal pages are crawled.")
    @Placement(order=2)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Example(value="True")
    private boolean restrictToPath;
    @Parameter
    @Alias(value="regexUrlsFilterLogic")
    @Summary(value="Type of filter logic to apply to regex URLs while crawling.")
    @DisplayName(value="Regex URLs filter logic")
    @Placement(order=3)
    @Optional
    private Constants.RegexUrlsFilterLogic regexUrlsFilterLogic;
    @Parameter
    @Alias(value="regexUrls")
    @DisplayName(value="Regex URLs List")
    @Summary(value="List of regex patterns for URLs to include or exclude while crawling.")
    @Placement(order=4)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Example(value="https://www\\.googletagmanager\\.com/.*")
    @Optional(defaultValue="#[[\"https://www\\.googletagmanager\\.com/.*\"]]")
    private List<String> regexUrls;

    public boolean isRestrictToPath() {
        return this.restrictToPath;
    }

    public void setRestrictToPath(boolean restrictToPath) {
        this.restrictToPath = restrictToPath;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public Constants.RegexUrlsFilterLogic getRegexUrlsFilterLogic() {
        return this.regexUrlsFilterLogic;
    }

    public void setRegexUrlsFilterLogic(Constants.RegexUrlsFilterLogic regexUrlsFilterLogic) {
        this.regexUrlsFilterLogic = regexUrlsFilterLogic;
    }

    public List<String> getRegexUrls() {
        return this.regexUrls;
    }

    public void setRegexUrls(List<String> regexUrls) {
        this.regexUrls = regexUrls;
    }

    public String toString() {
        return "CrawlerTargetPagesParameters{maxDepth=" + this.maxDepth + ", restrictToPath=" + this.restrictToPath + ", urlFilterType=" + this.regexUrlsFilterLogic + ", regexUrls=" + this.regexUrls + "}";
    }
}

