/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.helper.page;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.mule.extension.webcrawler.internal.config.PageLoadOptions;
import org.mule.extension.webcrawler.internal.config.WebCrawlerConfiguration;
import org.mule.extension.webcrawler.internal.connection.WebCrawlerConnection;
import org.mule.extension.webcrawler.internal.connection.webdriver.WebDriverConnection;
import org.mule.extension.webcrawler.internal.constant.Constants;
import org.mule.extension.webcrawler.internal.error.WebCrawlerErrorType;
import org.mule.extension.webcrawler.internal.util.URLUtils;
import org.mule.extension.webcrawler.internal.util.Utils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageHelper.class);
    private static final ConcurrentHashMap<String, String> robotsTxtCache = new ConcurrentHashMap();

    public static Document getDocument(WebCrawlerConfiguration webCrawlerConfiguration, WebCrawlerConnection connection, String url, PageLoadOptions pageLoadOptions) throws IOException {
        return PageHelper.getDocument(webCrawlerConfiguration, connection, url, connection.getReferrer(), pageLoadOptions);
    }

    public static Document getDocument(WebCrawlerConfiguration webCrawlerConfiguration, WebCrawlerConnection connection, String url, String referrer, PageLoadOptions pageLoadOptions) throws IOException {
        Document document;
        block10: {
            LOGGER.debug(String.format("Retrieving JSoup Document for url %s and referer %s", url, referrer));
            InputStream pageSourceInputStream = connection.getPageSource(url, referrer, pageLoadOptions).get();
            try {
                String pageSource = new String(pageSourceInputStream.readAllBytes(), StandardCharsets.UTF_8);
                Document document2 = Jsoup.parse((String)pageSource, (String)url);
                if (connection instanceof WebDriverConnection && pageLoadOptions.isExtractShadowDom()) {
                    ((WebDriverConnection)connection).injectAllShadowDOMs(document2, pageLoadOptions.getShadowHostXPath());
                }
                document = document2;
                if (pageSourceInputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (pageSourceInputStream != null) {
                        try {
                            pageSourceInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ModuleException me) {
                    throw me;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new IOException(String.format("Error fetching page source for %s", url), e);
                }
            }
            pageSourceInputStream.close();
        }
        return document;
    }

    public static boolean isURLValid(WebCrawlerConfiguration webCrawlerConfiguration, WebCrawlerConnection connection, String url, String referrer) {
        LOGGER.debug(String.format("Retrieving status code for url %s and referer %s", url, referrer));
        try {
            Integer urlStatusCode = connection.getUrlStatusCode(url, referrer).get();
            if (urlStatusCode != 200) {
                LOGGER.debug(String.format("URL %s is not valid. Status code: %d", url, urlStatusCode));
            }
            return urlStatusCode == 200;
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error(String.format("Error while checking statur for url %s", url), (Throwable)e);
            return false;
        }
    }

    public static JSONArray getPageMetaTags(Document document) {
        JSONArray metaTagArray = new JSONArray();
        Elements metaTags = document.select("meta");
        for (Element metaTag : metaTags) {
            String name = metaTag.attr("name");
            String property = metaTag.attr("property");
            String content = metaTag.attr("content");
            if (name.isEmpty() && property.isEmpty() || content.isEmpty()) continue;
            JSONObject metaTagObject = new JSONObject();
            if (!property.isEmpty()) {
                metaTagObject.put("property", (Object)property);
            } else {
                metaTagObject.put("name", (Object)name);
            }
            metaTagObject.put("content", (Object)content);
            metaTagArray.put((Object)metaTagObject);
        }
        return metaTagArray;
    }

    public static HashMap<String, Object> getPageInsights(Document document, List<String> tags, Constants.PageInsightType insight) {
        return PageHelper.getPageInsights(document, tags, insight, null, null);
    }

    public static HashMap<String, Object> getPageInsights(Document document, List<String> tags, Constants.PageInsightType insight, Constants.RegexUrlsFilterLogic regexUrlsFilterLogic, List<String> regexUrls) {
        HashMap<String, Object> pageInsightData = new HashMap<String, Object>();
        try {
            Elements linkElements;
            HashSet<String> documentLinks = new HashSet<String>();
            HashSet<String> internalLinks = new HashSet<String>();
            HashSet<String> externalLinks = new HashSet<String>();
            HashSet<String> referenceLinks = new HashSet<String>();
            HashSet<String> iframeLinks = new HashSet<String>();
            HashSet<String> imageLinks = new HashSet<String>();
            HashMap<String, HashSet<String>> linksMap = new HashMap<String, HashSet<String>>();
            HashMap<String, Integer> elementCounts = new HashMap<String, Integer>();
            String baseUrl = document.baseUri();
            if (insight == Constants.PageInsightType.ALL || insight == Constants.PageInsightType.DOCUMENTLINKS || insight == Constants.PageInsightType.INTERNALLINKS || insight == Constants.PageInsightType.REFERENCELINKS || insight == Constants.PageInsightType.EXTERNALLINKS) {
                linkElements = document.select("a[href]");
                for (Element linkElement : linkElements) {
                    String link = linkElement.absUrl("href");
                    if (PageHelper.skipUrl(link, regexUrlsFilterLogic, regexUrls)) continue;
                    if (URLUtils.isDocumentUrl(link)) {
                        documentLinks.add(link);
                        continue;
                    }
                    if (URLUtils.isExternalLink(baseUrl, link)) {
                        externalLinks.add(link);
                        continue;
                    }
                    if (URLUtils.isReferenceLink(baseUrl, link)) {
                        referenceLinks.add(link);
                        continue;
                    }
                    internalLinks.add(link);
                }
                if (insight == Constants.PageInsightType.ALL || insight == Constants.PageInsightType.DOCUMENTLINKS) {
                    linksMap.put("documents", documentLinks);
                }
                if (insight == Constants.PageInsightType.ALL || insight == Constants.PageInsightType.INTERNALLINKS) {
                    linksMap.put("internal", internalLinks);
                }
                if (insight == Constants.PageInsightType.ALL || insight == Constants.PageInsightType.EXTERNALLINKS) {
                    linksMap.put("external", externalLinks);
                }
                if (insight == Constants.PageInsightType.ALL || insight == Constants.PageInsightType.REFERENCELINKS) {
                    linksMap.put("reference", referenceLinks);
                }
            }
            if (insight == Constants.PageInsightType.ALL || insight == Constants.PageInsightType.IFRAMELINKS) {
                linkElements = document.select("iframe[src]");
                for (Element linkElement : linkElements) {
                    String iFrameUrl = linkElement.absUrl("src");
                    if (PageHelper.skipUrl(iFrameUrl, regexUrlsFilterLogic, regexUrls)) continue;
                    iframeLinks.add(iFrameUrl);
                }
                linksMap.put("iframe", iframeLinks);
            }
            if (insight == Constants.PageInsightType.ALL || insight == Constants.PageInsightType.IMAGELINKS) {
                Elements images = document.select("img[src]");
                for (Element img : images) {
                    String imageUrl = img.absUrl("src");
                    if (PageHelper.skipUrl(imageUrl, regexUrlsFilterLogic, regexUrls)) continue;
                    imageLinks.add(imageUrl);
                }
                linksMap.put("images", imageLinks);
            }
            if (insight == Constants.PageInsightType.ALL || insight == Constants.PageInsightType.ELEMENTCOUNTSTATS) {
                String[] elementsToCount = new String[]{"div", "p", "h1", "h2", "h3", "h4", "h5"};
                if (tags != null && !tags.isEmpty()) {
                    elementsToCount = tags.toArray(new String[tags.size()]);
                }
                for (String tag : elementsToCount) {
                    Elements elements = document.select(tag);
                    elementCounts.put(tag, elements.size());
                }
                elementCounts.put("internal", internalLinks.size());
                elementCounts.put("external", externalLinks.size());
                elementCounts.put("reference", referenceLinks.size());
                elementCounts.put("iframe", iframeLinks.size());
                elementCounts.put("images", imageLinks.size());
                elementCounts.put("wordCount", Utils.countWords(PageHelper.getPageContent(document, tags, Constants.OutputFormat.TEXT)));
                pageInsightData.put("pageStats", elementCounts);
            }
            pageInsightData.put("url", document.baseUri());
            pageInsightData.put("title", document.title());
            if (insight == Constants.PageInsightType.ALL || insight == Constants.PageInsightType.DOCUMENTLINKS || insight == Constants.PageInsightType.INTERNALLINKS || insight == Constants.PageInsightType.REFERENCELINKS || insight == Constants.PageInsightType.EXTERNALLINKS || insight == Constants.PageInsightType.IFRAMELINKS || insight == Constants.PageInsightType.IMAGELINKS) {
                pageInsightData.put("links", linksMap);
            }
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Error while getting page insights for %s.", document.baseUri()), (ErrorTypeDefinition)WebCrawlerErrorType.PAGE_OPERATIONS_FAILURE, (Throwable)e);
        }
        return pageInsightData;
    }

    private static boolean skipUrl(String url, Constants.RegexUrlsFilterLogic regexUrlsFilterLogic, List<String> regexUrls) {
        if (regexUrlsFilterLogic != null && regexUrls != null && !regexUrls.isEmpty()) {
            boolean matchesPattern = regexUrls.stream().anyMatch(pattern -> Pattern.matches(pattern, url));
            if (regexUrlsFilterLogic == Constants.RegexUrlsFilterLogic.INCLUDE && !matchesPattern || regexUrlsFilterLogic == Constants.RegexUrlsFilterLogic.EXCLUDE && matchesPattern) {
                return true;
            }
        }
        return false;
    }

    public static String getPageContent(Document document, List<String> tags, Constants.OutputFormat outputFormat) {
        switch (outputFormat) {
            case TEXT: {
                return PageHelper.getPageContent(document, tags);
            }
            case HTML: {
                return PageHelper.getPageRawHtmlContent(document, tags);
            }
            case MARKDOWN: {
                return Utils.convertHtmlToMarkdown(PageHelper.getPageRawHtmlContent(document, tags));
            }
        }
        return PageHelper.getPageRawHtmlContent(document, tags);
    }

    private static String getPageContent(Document document, List<String> tags) {
        StringBuilder collectedText = new StringBuilder();
        HashSet<Element> selectedElements = new HashSet<Element>();
        if (tags != null && !tags.isEmpty()) {
            for (String selector : tags) {
                Elements elements = document.select(selector);
                for (Element element : elements) {
                    if (PageHelper.isNestedInsideAnotherSelected(element, selectedElements)) continue;
                    collectedText.append(element.text()).append(" ");
                    selectedElements.add(element);
                }
            }
        } else {
            collectedText.append(document.text());
        }
        return collectedText.toString().trim();
    }

    private static String getPageRawHtmlContent(Document document, List<String> tags) {
        StringBuilder collectedHtml = new StringBuilder();
        HashSet<Element> selectedElements = new HashSet<Element>();
        if (tags != null && !tags.isEmpty()) {
            for (String selector : tags) {
                Elements elements = document.select(selector);
                for (Element element : elements) {
                    if (PageHelper.isNestedInsideAnotherSelected(element, selectedElements)) continue;
                    collectedHtml.append(element.outerHtml()).append("\n");
                    selectedElements.add(element);
                }
            }
        } else {
            collectedHtml.append(document.html());
        }
        return collectedHtml.toString().trim();
    }

    private static boolean isNestedInsideAnotherSelected(Element element, Set<Element> selectedElements) {
        for (Element selected : selectedElements) {
            if (!PageHelper.isDescendant(selected, element)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDescendant(Element parent, Element element) {
        for (Element e : element.parents()) {
            if (e != parent) continue;
            return true;
        }
        return false;
    }

    public static String savePageContents(JSONObject results, String downloadPath, String title) throws IOException {
        String pageContents = results.toString();
        Object fileName = "";
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        fileName = Utils.getSanitizedFilename(title) + "_" + timestamp + ".json";
        File file = new File(downloadPath, (String)fileName);
        file.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(pageContents);
            LOGGER.info("Saved content to file: " + (String)fileName);
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while writing to the file: " + e.getMessage());
        }
        return file != null ? file.getName() : "File is null";
    }

    public static JSONArray downloadWebsiteImages(Document document, String saveDirectory, int maxNumber) throws IOException {
        return PageHelper.downloadWebsiteImages(document, saveDirectory, "", maxNumber);
    }

    public static JSONArray downloadWebsiteImages(Document document, String saveDirectory, String imagesSubFolder, int maxNumber) throws IOException {
        JSONArray imagesJSONArray = new JSONArray();
        Set imageUrls = new HashSet();
        Map linksMap = (Map)PageHelper.getPageInsights(document, null, Constants.PageInsightType.IMAGELINKS).get("links");
        if (linksMap != null) {
            imageUrls = (Set)linksMap.get("images");
        }
        if (imageUrls != null) {
            LOGGER.info("Number of img[src] elements found : " + imageUrls.size());
            for (String imageUrl : imageUrls) {
                JSONObject imageJSONObject = PageHelper.downloadSingleImage(imageUrl, saveDirectory, imagesSubFolder);
                if (imageJSONObject != null) {
                    imagesJSONArray.put((Object)imageJSONObject);
                }
                if (maxNumber <= 0 || imagesJSONArray.length() < maxNumber) continue;
                break;
            }
        }
        return imagesJSONArray;
    }

    public static JSONObject downloadSingleImage(String imageUrl, String saveDirectory) throws IOException {
        return PageHelper.downloadSingleImage(imageUrl, saveDirectory, "");
    }

    public static JSONObject downloadSingleImage(String imageUrl, String saveDirectory, String imagesSubFolder) throws IOException {
        JSONObject jsonObject;
        block26: {
            LOGGER.info("Processing image: " + imageUrl);
            String imagesSaveDirectory = saveDirectory + "/" + imagesSubFolder;
            jsonObject = new JSONObject();
            try {
                jsonObject.put("url", (Object)imageUrl);
                if (imagesSubFolder.compareTo("") != 0) {
                    jsonObject.put("relativePath", (Object)imagesSubFolder);
                }
                if (imageUrl.startsWith("data:image/")) {
                    byte[] imageBytes;
                    String base64Data = imageUrl.substring(imageUrl.indexOf(",") + 1);
                    if (base64Data.isEmpty()) {
                        LOGGER.info("Base64 data is empty for URL: " + imageUrl);
                        return null;
                    }
                    try {
                        imageBytes = Base64.getDecoder().decode(base64Data);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.info("Error decoding base64 data: " + e.getMessage());
                        return null;
                    }
                    if (imageBytes.length == 0) {
                        LOGGER.info("Decoded image bytes are empty for URL: " + imageUrl);
                        return null;
                    }
                    String mimeType = imageUrl.substring(5, imageUrl.indexOf(";"));
                    String fileExtension = mimeType.split("/")[1];
                    String timestamp = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
                    String fileName = "image_" + timestamp + "." + fileExtension;
                    File file = new File(imagesSaveDirectory, fileName);
                    file.getParentFile().mkdirs();
                    try (FileOutputStream out = new FileOutputStream(file);){
                        out.write(imageBytes);
                        LOGGER.info("Data URL image saved: " + file.getAbsolutePath());
                    }
                    jsonObject.put("fileName", (Object)fileName);
                    jsonObject.put("mimeType", (Object)mimeType);
                    break block26;
                }
                URL url = new URL(imageUrl);
                String decodedUrl = URLUtils.extractAndDecodeUrl(imageUrl);
                String fileName = URLUtils.extractFileNameFromUrl(decodedUrl);
                String mimeType = URLUtils.detectMimeTypeFromFileName(fileName);
                File file = new File(imagesSaveDirectory, fileName);
                file.getParentFile().mkdirs();
                try (InputStream in = url.openStream();
                     FileOutputStream out = new FileOutputStream(file);){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                }
                LOGGER.debug("Image saved: " + file.getAbsolutePath());
                jsonObject.put("fileName", (Object)fileName);
                jsonObject.put("mimeType", (Object)mimeType);
            }
            catch (IOException e) {
                LOGGER.error("Error saving image: " + imageUrl, (Throwable)e);
                return null;
            }
        }
        return jsonObject;
    }

    public static JSONArray downloadFiles(Document document, String saveDir, int maxNumber) throws IOException {
        return PageHelper.downloadFiles(document, saveDir, "", maxNumber);
    }

    public static JSONArray downloadFiles(Document document, String saveDir, String filesSubFolder, int maxNumber) throws IOException {
        JSONArray documentsJSONArray = new JSONArray();
        Set documentURLs = new HashSet();
        HashMap linkFileMap = new HashMap();
        Map linksMap = (Map)PageHelper.getPageInsights(document, null, Constants.PageInsightType.DOCUMENTLINKS).get("links");
        if (linksMap != null) {
            documentURLs = (Set)linksMap.get("documents");
        }
        if (documentURLs != null) {
            LOGGER.debug("Number of documents found : " + documentURLs.size());
            for (String documentURL : documentURLs) {
                JSONObject documentJSONObject = PageHelper.downloadFile(documentURL, saveDir, filesSubFolder);
                if (documentJSONObject != null) {
                    documentsJSONArray.put((Object)documentJSONObject);
                }
                if (maxNumber <= 0 || documentsJSONArray.length() < maxNumber) continue;
                break;
            }
        }
        return documentsJSONArray;
    }

    public static JSONObject downloadFile(String fileURL, String saveDir) {
        return PageHelper.downloadFile(fileURL, saveDir, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject downloadFile(String fileURL, String saveDir, String filesSubFolder) {
        JSONObject jsonObject;
        String fileName;
        block26: {
            String docsSaveDirectory = saveDir + "/" + filesSubFolder;
            HttpURLConnection httpConn = null;
            fileName = null;
            jsonObject = new JSONObject();
            try {
                jsonObject.put("url", (Object)fileURL);
                if (filesSubFolder.compareTo("") != 0) {
                    jsonObject.put("relativePath", (Object)filesSubFolder);
                }
                URL url = new URL(fileURL);
                httpConn = (HttpURLConnection)url.openConnection();
                httpConn.setRequestMethod("GET");
                int responseCode = httpConn.getResponseCode();
                if (responseCode == 200) {
                    String disposition = httpConn.getHeaderField("Content-Disposition");
                    if (disposition != null && disposition.contains("filename=")) {
                        int index = disposition.indexOf("filename=");
                        fileName = disposition.substring(index + 9).replaceAll("\"", "");
                    } else {
                        String urlPath = fileURL.split("\\?")[0];
                        fileName = urlPath.substring(urlPath.lastIndexOf("/") + 1);
                    }
                    fileName = URLDecoder.decode(fileName, StandardCharsets.UTF_8.name());
                    LOGGER.debug(String.format("Downloading file %s at %s", fileName, fileURL));
                    File directory = new File(docsSaveDirectory);
                    if (!directory.exists()) {
                        if (directory.mkdirs()) {
                            LOGGER.debug("Directory created: " + directory.getAbsolutePath());
                        } else {
                            LOGGER.error("Failed to create directory: " + directory.getAbsolutePath());
                            JSONObject jSONObject = null;
                            return jSONObject;
                        }
                    }
                    try (BufferedInputStream inputStream = new BufferedInputStream(httpConn.getInputStream());
                         FileOutputStream outputStream = new FileOutputStream(docsSaveDirectory + fileName);){
                        int bytesRead;
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                        LOGGER.debug("File downloaded: " + docsSaveDirectory + fileName);
                        break block26;
                    }
                }
                LOGGER.debug("No file to download. Server replied HTTP code: " + responseCode);
            }
            catch (IOException e) {
                LOGGER.error("Error downloading file: " + e.getMessage());
            }
            finally {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
        }
        if (fileName == null) {
            return null;
        }
        jsonObject.put("fileName", fileName);
        String mimeType = URLUtils.detectMimeTypeFromFileName(fileName);
        jsonObject.put("mimeType", (Object)mimeType);
        return jsonObject;
    }

    public static boolean canCrawl(String url, String userAgent) {
        String baseUrl;
        String robotsTxtContent = PageHelper.getRobotsTxt(url);
        if (robotsTxtContent == null) {
            return true;
        }
        try {
            URL base = new URL(url);
            baseUrl = base.getProtocol() + "://" + base.getHost();
        }
        catch (MalformedURLException e) {
            LOGGER.error("Invalid URL: " + url, (Throwable)e);
            return false;
        }
        String[] lines = robotsTxtContent.split("\n");
        boolean userAgentMatched = false;
        boolean isAllowed = true;
        for (String line : lines) {
            String path;
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            if (line.toLowerCase().startsWith("user-agent:")) {
                String agent = line.substring(11).trim();
                userAgentMatched = agent.equals("*") || agent.equalsIgnoreCase(userAgent);
                continue;
            }
            if (!userAgentMatched) continue;
            if (line.toLowerCase().startsWith("disallow:")) {
                path = line.substring(9).trim();
                if (!path.isEmpty() && !url.startsWith(baseUrl + path)) continue;
                isAllowed = false;
                break;
            }
            if (!line.toLowerCase().startsWith("allow:") || !url.startsWith(baseUrl + (path = line.substring(6).trim()))) continue;
            isAllowed = true;
            break;
        }
        return isAllowed;
    }

    public static String getRobotsTxt(String url) {
        try {
            URL baseUrl = new URL(url);
            String baseUrlString = baseUrl.getProtocol() + "://" + baseUrl.getHost();
            if (robotsTxtCache.containsKey(baseUrlString)) {
                return robotsTxtCache.get(baseUrlString);
            }
            String robotsTxtUrl = baseUrlString + "/robots.txt";
            Document document = Jsoup.connect((String)robotsTxtUrl).get();
            String robotsTxtContent = Jsoup.connect((String)robotsTxtUrl).ignoreContentType(true).execute().body();
            LOGGER.debug("Retrieved robots.txt content:\n\n " + robotsTxtContent + "\n\n");
            robotsTxtCache.put(baseUrlString, robotsTxtContent);
            return robotsTxtContent;
        }
        catch (Exception e) {
            LOGGER.debug("Error retrieving robots.txt from " + url, (Throwable)e);
            return null;
        }
    }
}

