/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.operation;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.mule.extension.webcrawler.api.metadata.SearchResponseAttributes;
import org.mule.extension.webcrawler.internal.error.WebCrawlerErrorType;
import org.mule.extension.webcrawler.internal.error.provider.WebCrawlerErrorTypeProvider;
import org.mule.extension.webcrawler.internal.helper.ResponseHelper;
import org.mule.extension.webcrawler.internal.helper.search.SerperDev;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchOperations.class);

    @MediaType(value="application/json", strict=false)
    @Alias(value="search-google")
    @DisplayName(value="[Search] Google")
    @Throws(value={WebCrawlerErrorTypeProvider.class})
    @OutputJsonType(schema="api/metadata/SearchGoogle.json")
    public Result<InputStream, SearchResponseAttributes> googleSearch(final @DisplayName(value="Search Query") @Placement(order=1) @Example(value="apple inc") String query, @DisplayName(value="API Key") @Placement(order=2) @Example(value="your_api_key_here") String apiKey) throws IOException {
        try {
            LOGGER.info("Performing Google search for query: " + query);
            String responseBody = SerperDev.search(query, apiKey);
            JSONObject jsonResponse = new JSONObject(responseBody);
            return ResponseHelper.createSearchResponse(jsonResponse.toString(), (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("query", query);
                }
            });
        }
        catch (ModuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Error while searching '%s'.", query), (ErrorTypeDefinition)WebCrawlerErrorType.SEARCH_OPERATIONS_FAILURE, (Throwable)e);
        }
    }
}

