/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.helper;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.mule.extension.webcrawler.api.metadata.PageResponseAttributes;
import org.mule.extension.webcrawler.api.metadata.ResponseAttributes;
import org.mule.extension.webcrawler.api.metadata.SearchResponseAttributes;
import org.mule.extension.webcrawler.api.metadata.SitemapResponseAttributes;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class ResponseHelper {
    public static Result<InputStream, ResponseAttributes> createResponse(String output, Map<String, Object> responseAttributes) {
        return Result.builder().attributes((Object)new ResponseAttributes((HashMap)responseAttributes)).attributesMediaType(MediaType.APPLICATION_JAVA).output((Object)IOUtils.toInputStream((String)output, (Charset)StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_JSON).build();
    }

    public static Result<InputStream, PageResponseAttributes> createPageResponse(String output, Map<String, Object> pageAttributes) {
        return Result.builder().attributes((Object)new PageResponseAttributes((HashMap)pageAttributes)).attributesMediaType(MediaType.APPLICATION_JAVA).output((Object)IOUtils.toInputStream((String)output, (Charset)StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_JSON).build();
    }

    public static Result<InputStream, SitemapResponseAttributes> createSitemapResponse(String output, Map<String, Object> sitemapAttributes) {
        return Result.builder().attributes((Object)new SitemapResponseAttributes((HashMap)sitemapAttributes)).attributesMediaType(MediaType.APPLICATION_JAVA).output((Object)IOUtils.toInputStream((String)output, (Charset)StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_XML).build();
    }

    public static Result<InputStream, SearchResponseAttributes> createSearchResponse(String output, Map<String, Object> searchAttributes) {
        return Result.builder().attributes((Object)new SearchResponseAttributes((HashMap)searchAttributes)).attributesMediaType(MediaType.APPLICATION_JAVA).output((Object)IOUtils.toInputStream((String)output, (Charset)StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_JSON).build();
    }

    public static List<Result<CursorProvider, PageResponseAttributes>> createPageResponse(String response, Map<String, Object> documentAttributes, StreamingHelper streamingHelper) {
        LinkedList<Result<CursorProvider, PageResponseAttributes>> page = new LinkedList<Result<CursorProvider, PageResponseAttributes>>();
        page.add(Result.builder().attributes((Object)new PageResponseAttributes((HashMap)documentAttributes)).output((Object)((CursorProvider)streamingHelper.resolveCursorProvider((Object)IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8)))).mediaType(MediaType.APPLICATION_JSON).attributesMediaType(MediaType.APPLICATION_JAVA).build());
        return page;
    }
}

