/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.html2markdown;

import java.util.HashMap;
import java.util.Map;
import org.mule.extension.webcrawler.internal.html2markdown.BlockquoteConverter;
import org.mule.extension.webcrawler.internal.html2markdown.BoldConverter;
import org.mule.extension.webcrawler.internal.html2markdown.BreakConverter;
import org.mule.extension.webcrawler.internal.html2markdown.CodeBlockConverter;
import org.mule.extension.webcrawler.internal.html2markdown.CodeConverter;
import org.mule.extension.webcrawler.internal.html2markdown.DefaultConverter;
import org.mule.extension.webcrawler.internal.html2markdown.DivConverter;
import org.mule.extension.webcrawler.internal.html2markdown.ElementConverter;
import org.mule.extension.webcrawler.internal.html2markdown.EmphasisConverter;
import org.mule.extension.webcrawler.internal.html2markdown.HeadingConverter;
import org.mule.extension.webcrawler.internal.html2markdown.HorizontalRuleConverter;
import org.mule.extension.webcrawler.internal.html2markdown.ImageConverter;
import org.mule.extension.webcrawler.internal.html2markdown.LinkConverter;
import org.mule.extension.webcrawler.internal.html2markdown.ListItemConverter;
import org.mule.extension.webcrawler.internal.html2markdown.OrderedListConverter;
import org.mule.extension.webcrawler.internal.html2markdown.ParagraphConverter;
import org.mule.extension.webcrawler.internal.html2markdown.SpanConverter;
import org.mule.extension.webcrawler.internal.html2markdown.TableConverter;
import org.mule.extension.webcrawler.internal.html2markdown.UnorderedListConverter;

public class ElementConverterRegistry {
    private final Map<String, ElementConverter> converters = new HashMap<String, ElementConverter>();
    private final ElementConverter defaultConverter = new DefaultConverter();

    public ElementConverterRegistry() {
        this.registerConverter("h1", new HeadingConverter("# "));
        this.registerConverter("h2", new HeadingConverter("## "));
        this.registerConverter("h3", new HeadingConverter("### "));
        this.registerConverter("h4", new HeadingConverter("#### "));
        this.registerConverter("h5", new HeadingConverter("##### "));
        this.registerConverter("h6", new HeadingConverter("###### "));
        this.registerConverter("p", new ParagraphConverter());
        this.registerConverter("strong", new BoldConverter());
        this.registerConverter("b", new BoldConverter());
        this.registerConverter("em", new EmphasisConverter());
        this.registerConverter("i", new EmphasisConverter());
        this.registerConverter("ul", new UnorderedListConverter());
        this.registerConverter("ol", new OrderedListConverter());
        this.registerConverter("li", new ListItemConverter());
        this.registerConverter("br", new BreakConverter());
        this.registerConverter("hr", new HorizontalRuleConverter());
        this.registerConverter("table", new TableConverter());
        this.registerConverter("blockquote", new BlockquoteConverter());
        this.registerConverter("a", new LinkConverter());
        this.registerConverter("img", new ImageConverter());
        this.registerConverter("pre", new CodeBlockConverter());
        this.registerConverter("span", new SpanConverter());
        this.registerConverter("div", new DivConverter());
        this.registerConverter("code", new CodeConverter());
    }

    public void registerConverter(String tagName, ElementConverter converter) {
        this.converters.put(tagName, converter);
    }

    public ElementConverter getConverter(String tagName) {
        return this.converters.getOrDefault(tagName, this.defaultConverter);
    }
}

