/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.html2markdown;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.mule.extension.webcrawler.internal.html2markdown.ElementConverter;
import org.mule.extension.webcrawler.internal.html2markdown.ElementConverterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlToMarkdownConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlToMarkdownConverter.class);
    private final ElementConverterRegistry converterRegistry = new ElementConverterRegistry();
    private final int maxDepth;

    public HtmlToMarkdownConverter(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public String convert(String html) {
        Document document = Jsoup.parse((String)html);
        StringBuilder markdown = new StringBuilder();
        for (Element element : document.body().children()) {
            markdown.append(this.convertElement(element, 1));
        }
        return markdown.toString();
    }

    private String convertElement(Element element, int depth) {
        if (depth > this.maxDepth) {
            LOGGER.warn("Depth for URI {} is too large; review markdown output", (Object)element.baseUri());
            return "";
        }
        ElementConverter converter = this.converterRegistry.getConverter(element.tagName());
        StringBuilder markdown = new StringBuilder();
        if (converter != null) {
            markdown.append(converter.convert(element, this::convertElement, depth));
        } else {
            for (Node node : element.childNodes()) {
                if (node instanceof TextNode) {
                    markdown.append(((TextNode)node).text());
                    continue;
                }
                if (!(node instanceof Element)) continue;
                markdown.append(this.convertElement((Element)node, depth + 1));
            }
        }
        return markdown.toString();
    }
}

