/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.html2markdown;

import java.util.function.BiFunction;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.mule.extension.webcrawler.internal.html2markdown.ElementConverter;

class LinkConverter
implements ElementConverter {
    LinkConverter() {
    }

    @Override
    public String convert(Element element, BiFunction<Element, Integer, String> childConverter, int depth) {
        String href = element.attr("href");
        StringBuilder text = new StringBuilder();
        for (Node node : element.childNodes()) {
            if (node instanceof TextNode) {
                text.append(((TextNode)node).text());
                continue;
            }
            if (!(node instanceof Element)) continue;
            text.append(childConverter.apply((Element)node, depth + 1));
        }
        if (href.isEmpty()) {
            return text.toString();
        }
        return "[" + text.toString() + "](" + href + ")";
    }
}

