/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.connection.http;

import javax.inject.Inject;
import org.mule.extension.webcrawler.internal.connection.http.HttpConnection;
import org.mule.extension.webcrawler.internal.helper.provider.UserAgentNameProvider;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;

@Alias(value="http")
@DisplayName(value="HTTP")
public class HttpConnectionProvider
implements CachedConnectionProvider<HttpConnection>,
Startable,
Stoppable {
    private HttpClient httpClient;
    @RefName
    private String configName;
    @Inject
    private HttpService httpService;
    @Parameter
    @Alias(value="userAgent")
    @DisplayName(value="User agent")
    @Summary(value="The request user-agent header.")
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=UserAgentNameProvider.class)
    @Optional
    private String userAgent;
    @Parameter
    @Alias(value="referrer")
    @DisplayName(value="Referrer")
    @Summary(value="The request referrer (aka \"referer\") header..")
    @Placement(order=2)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Example(value="https://www.google.com")
    @Optional
    private String referrer;
    @Parameter
    @Placement(order=2)
    @Optional(defaultValue="10000")
    private int timeout;
    @Parameter
    @Placement(order=2, tab="Advanced")
    @Optional
    private TlsContextFactory tlsContext;

    public HttpConnection connect() throws ConnectionException {
        return new HttpConnection(this.httpClient, this.timeout, this.userAgent, this.referrer);
    }

    public void disconnect(HttpConnection httpConnection) {
    }

    public ConnectionValidationResult validate(HttpConnection httpConnection) {
        try {
            httpConnection.validate();
            return ConnectionValidationResult.success();
        }
        catch (ConnectionException e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void start() throws MuleException {
        HttpClientConfiguration config = this.createClientConfiguration();
        this.httpClient = this.httpService.getClientFactory().create(config);
        this.httpClient.start();
    }

    private HttpClientConfiguration createClientConfiguration() {
        HttpClientConfiguration.Builder builder = new HttpClientConfiguration.Builder().setName(this.configName);
        if (null != this.tlsContext) {
            builder.setTlsContextFactory(this.tlsContext);
        } else {
            builder.setTlsContextFactory(TlsContextFactory.builder().buildDefault());
        }
        return builder.build();
    }

    public void stop() throws MuleException {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }
}

