/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.helper.webdriver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudHubChromeConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudHubChromeConfigurer.class);
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    public static final String LATEST_MILESTONE_VERSION_URL = "https://googlechromelabs.github.io/chrome-for-testing/latest-versions-per-milestone.json";
    public static final String CHROME_CDP_VERSION = "135";
    public static final String CHROME_DEPENDENCY_RESOURCE_PATH = "/cloudhub-chrome-dependencies.zip";
    public static final String CHROME_DEPENDENCY_LIBS_PATH = "/tmp/chrome-deps-linux64";
    public static final String CHROME_PATH = "/tmp/chrome-headless-shell-linux64";
    public static final String CHROME_WRAPPER_SCRIPT_CONTENT = "#!/bin/bash\nexport LD_LIBRARY_PATH=/tmp/chrome-deps-linux64:$LD_LIBRARY_PATH\nexport FONTCONFIG_PATH=/tmp\nexec /tmp/chrome-headless-shell-linux64/chrome-headless-shell \"$@\"\n";
    public static final String CHROME_WEBDRIVER_PATH = "/tmp/chromedriver-linux64";
    public static String CHROME_WEBDRIVER_WRAPPER_SCRIPT_CONTENT = "#!/bin/bash\nexport LD_LIBRARY_PATH=/tmp/chrome-deps-linux64:$LD_LIBRARY_PATH\nexport FONTCONFIG_PATH=/tmp\nexec /tmp/chromedriver-linux64/chromedriver \"$@\"\n";
    public static final String CHROME_LIB_WRAPPER_SCRIPT = "/tmp/chrome-linux64/chrome-lib-wrapper";
    public static final String CHROME_WEBDRIVER_WRAPPER_SCRIPT = "/tmp/chrome-linux64/chrome-webdriver-wrapper";

    public static boolean isCloudHubDeployment() {
        return Boolean.getBoolean("cloudhub.deployment");
    }

    public static void setup() {
        if (initialized.compareAndSet(false, true)) {
            LOGGER.debug("Executing Chrome setup");
            try {
                JSONObject jsonResponse = new JSONObject(CloudHubChromeConfigurer.getChromeMilestoneVersionJsonAsString());
                String chromeVersion = jsonResponse.getJSONObject("milestones").getJSONObject(CHROME_CDP_VERSION).getString("version");
                String chromeDownloadUrl = String.format("https://storage.googleapis.com/chrome-for-testing-public/%s/linux64/chrome-headless-shell-linux64.zip", chromeVersion);
                String chromeDriverDownloadUrl = String.format("https://storage.googleapis.com/chrome-for-testing-public/%s/linux64/chromedriver-linux64.zip", chromeVersion);
                LOGGER.info("Downloading Chrome Headless Shell from: {}", (Object)chromeDownloadUrl);
                FileUtils.copyURLToFile((URL)new URL(chromeDownloadUrl), (File)new File("/tmp/chrome-headless-shell-linux64.zip"));
                LOGGER.info("Downloading ChromeDriver from: {}", (Object)chromeDriverDownloadUrl);
                FileUtils.copyURLToFile((URL)new URL(chromeDriverDownloadUrl), (File)new File("/tmp/chromedriver-linux64.zip"));
                CloudHubChromeConfigurer.unzip("/tmp/chrome-headless-shell-linux64.zip", "/tmp");
                CloudHubChromeConfigurer.unzip("/tmp/chromedriver-linux64.zip", "/tmp");
                CloudHubChromeConfigurer.createLibWrapperScript(CHROME_LIB_WRAPPER_SCRIPT, CHROME_WRAPPER_SCRIPT_CONTENT);
                CloudHubChromeConfigurer.createLibWrapperScript(CHROME_WEBDRIVER_WRAPPER_SCRIPT, CHROME_WEBDRIVER_WRAPPER_SCRIPT_CONTENT);
                CloudHubChromeConfigurer.extractSoLibs();
                System.setProperty("webdriver.chrome.driver", CHROME_WEBDRIVER_WRAPPER_SCRIPT);
                CloudHubChromeConfigurer.logVersion(CHROME_LIB_WRAPPER_SCRIPT, "/tmp/chrome-headless-shell-linux64/chrome-headless-shell");
                CloudHubChromeConfigurer.logVersion(CHROME_WEBDRIVER_WRAPPER_SCRIPT, "/tmp/chromedriver-linux64/chromedriver");
            }
            catch (Exception e) {
                LOGGER.error("Error in Chrome setup", (Throwable)e);
            }
            CloudHubChromeConfigurer.startMemoryMonitor();
        }
    }

    private static String getChromeMilestoneVersionJsonAsString() {
        try {
            String line;
            URL url = new URL(LATEST_MILESTONE_VERSION_URL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = in.readLine()) != null) {
                response.append(line);
            }
            in.close();
            return response.toString();
        }
        catch (Exception e) {
            LOGGER.error("Error fetching latest Chrome milestone version JSON", (Object)e.getMessage());
            return null;
        }
    }

    private static void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                CloudHubChromeConfigurer.extractEntry(zipFile, entry, destDir);
            }
        }
    }

    private static void extractSoLibs() throws IOException {
        File tempZip = File.createTempFile("chrome_dependencies", ".zip", new File("/tmp"));
        try (InputStream zipStream = CloudHubChromeConfigurer.class.getResourceAsStream(CHROME_DEPENDENCY_RESOURCE_PATH);
             FileOutputStream outStream = new FileOutputStream(tempZip);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = zipStream.read(buffer)) != -1) {
                ((OutputStream)outStream).write(buffer, 0, bytesRead);
            }
        }
        try (ZipFile zipFile = new ZipFile(tempZip);){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                CloudHubChromeConfigurer.extractEntry(zipFile, entry, new File(CHROME_DEPENDENCY_LIBS_PATH));
            }
        }
        tempZip.delete();
    }

    private static void extractEntry(ZipFile zipFile, ZipArchiveEntry entry, File destDir) throws IOException {
        File outputFile = new File(destDir, entry.getName());
        if (entry.isDirectory()) {
            outputFile.mkdirs();
        } else {
            outputFile.getParentFile().mkdirs();
            if (entry.isUnixSymlink()) {
                String targetPath = zipFile.getUnixSymlink(entry);
                Path target = Paths.get(destDir.getAbsolutePath(), targetPath);
                Files.createSymbolicLink(outputFile.toPath(), target, new FileAttribute[0]);
            } else {
                Files.copy(zipFile.getInputStream(entry), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                Files.setPosixFilePermissions(outputFile.toPath(), PosixFilePermissions.fromString("rwxr-xr-x"));
            }
            if ((entry.getUnixMode() & 0x40) != 0) {
                outputFile.setExecutable(true);
            }
        }
    }

    public static void logFilesWithProperties(String directoryPath) {
        File directory = new File(directoryPath);
        if (!directory.exists() || !directory.isDirectory()) {
            LOGGER.info("Invalid directory path: {}", (Object)directoryPath);
            return;
        }
        File[] files = directory.listFiles();
        if (files == null || files.length == 0) {
            LOGGER.info("No files found in the directory: {}", (Object)directoryPath);
            return;
        }
        for (File file : files) {
            CloudHubChromeConfigurer.logFileProperties(file);
        }
    }

    public static void logFileProperties(File file) {
        try {
            Path filePath = file.toPath();
            boolean isExecutable = Files.isExecutable(filePath);
            boolean isReadable = Files.isReadable(filePath);
            boolean isWritable = Files.isWritable(filePath);
            boolean isSymbolicLink = Files.isSymbolicLink(filePath);
            long fileSize = Files.size(filePath);
            LOGGER.info("{} | Executable: {} | Readable: {} | Writable: {} | SymLink: {} | Size: {} bytes", new Object[]{file.getAbsolutePath(), isExecutable, isReadable, isWritable, isSymbolicLink, fileSize});
        }
        catch (Exception e) {
            LOGGER.info("Error reading properties for file: {}", (Object)file.getAbsolutePath());
        }
    }

    public static void testCommand(String[] command) throws IOException, InterruptedException {
        LOGGER.info("Executing command: {}", (Object)String.join((CharSequence)" ", command));
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                LOGGER.info(line);
            }
        }
        int exitCode = process.waitFor();
        if (exitCode == 0) {
            LOGGER.info("command completed successfully.");
        } else {
            LOGGER.error("command failed with exit code: {}", (Object)exitCode);
        }
    }

    public static void logVersion(String wrapperScript, String binary) throws IOException, InterruptedException {
        try {
            Process process = new ProcessBuilder(wrapperScript, "--version").start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String version = reader.readLine();
            if (version != null) {
                LOGGER.info("{} version is: {}", (Object)wrapperScript, (Object)version);
            } else {
                LOGGER.info("Dumping diagnostic logs for {}", (Object)binary);
                CloudHubChromeConfigurer.logLddOutput(binary);
                CloudHubChromeConfigurer.logFilesWithProperties(Paths.get(binary, new String[0]).getParent().toString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to get version", (Object)e.getMessage());
        }
    }

    public static void createLibWrapperScript(String path, String content) {
        try {
            File scriptFile = new File(path);
            scriptFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(scriptFile);){
                writer.write(content);
            }
            scriptFile.setExecutable(true);
            LOGGER.info("Wrapper script created at: {}", (Object)path);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create wrapper script", (Object)e.getMessage());
        }
    }

    public static void logLddOutput(String lddCommand) throws IOException, InterruptedException {
        String[] command = new String[]{"/bin/bash", "-c", "export LD_LIBRARY_PATH=/tmp/chrome-deps-linux64 && ldd " + lddCommand};
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        LOGGER.info("ldd diagnostic logs");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                LOGGER.info(line);
            }
        }
        int exitCode = process.waitFor();
        if (exitCode == 0) {
            LOGGER.info("ldd completed successfully.");
        } else {
            LOGGER.error("ldd failed with exit code: {}", (Object)exitCode);
        }
    }

    private static void startMemoryMonitor() {
        Timer timer = new Timer("MemoryMonitor", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                CloudHubChromeConfigurer.logMemoryStats();
            }
        }, 0L, 60000L);
    }

    private static void logMemoryStats() {
        long heapUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long heapMax = Runtime.getRuntime().maxMemory();
        String memUsage = CloudHubChromeConfigurer.readCgroupValue("/sys/fs/cgroup/memory/memory.usage_in_bytes");
        String memLimit = CloudHubChromeConfigurer.readCgroupValue("/sys/fs/cgroup/memory/memory.limit_in_bytes");
        LOGGER.info(String.format("[MemoryMonitor] Heap used: %.2f MB / %.2f MB | CGroup used: %.2f MB / %.2f MB%n", (double)heapUsed / 1048576.0, (double)heapMax / 1048576.0, CloudHubChromeConfigurer.parseToMB(memUsage), CloudHubChromeConfigurer.parseToMB(memLimit)));
    }

    private static String readCgroupValue(String path) {
        try {
            return new String(Files.readAllBytes(Paths.get(path, new String[0]))).trim();
        }
        catch (IOException e) {
            return "0";
        }
    }

    private static double parseToMB(String bytes) {
        try {
            return (double)Long.parseLong(bytes) / 1048576.0;
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }
}

