/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.html2markdown;

import java.util.function.BiFunction;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.mule.extension.webcrawler.internal.html2markdown.ElementConverter;

class OrderedListConverter
implements ElementConverter {
    OrderedListConverter() {
    }

    @Override
    public String convert(Element element, BiFunction<Element, Integer, String> childConverter, int depth) {
        StringBuilder markdown = new StringBuilder();
        int counter = 1;
        for (Element li : element.select("> li")) {
            markdown.append(counter++).append(". ");
            for (Node node : li.childNodes()) {
                if (node instanceof TextNode) {
                    markdown.append(((TextNode)node).text());
                    continue;
                }
                if (!(node instanceof Element)) continue;
                markdown.append(childConverter.apply((Element)node, depth + 1));
            }
            markdown.append("\n");
        }
        markdown.append("\n");
        return markdown.toString();
    }
}

