/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.connection.webdriver;

import org.mule.extension.webcrawler.internal.connection.webdriver.WebDriverConnection;
import org.mule.extension.webcrawler.internal.helper.provider.UserAgentNameProvider;
import org.mule.extension.webcrawler.internal.helper.webdriver.CloudHubChromeConfigurer;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="web-driver")
@DisplayName(value="WebDriver")
public class WebDriverConnectionProvider
implements CachedConnectionProvider<WebDriverConnection>,
Startable,
Stoppable {
    private static Logger LOGGER = LoggerFactory.getLogger(WebDriverConnectionProvider.class);
    @Parameter
    @Alias(value="userAgent")
    @DisplayName(value="User agent")
    @Summary(value="The request user-agent header.")
    @Placement(order=1)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=UserAgentNameProvider.class)
    @Optional
    private String userAgent;
    @Parameter
    @Alias(value="referrer")
    @DisplayName(value="Referrer")
    @Summary(value="The request referrer (aka \"referer\") header..")
    @Placement(order=2)
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Example(value="https://www.google.com")
    @Optional
    private String referrer;
    private WebDriver driver;

    public WebDriverConnection connect() throws ConnectionException {
        return new WebDriverConnection(this.driver, this.userAgent, this.referrer, this);
    }

    public void disconnect(WebDriverConnection webDriverConnection) {
    }

    public ConnectionValidationResult validate(WebDriverConnection webDriverConnection) {
        return ConnectionValidationResult.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() throws MuleException {
        if (this.driver != null) return;
        Class<WebDriverConnectionProvider> clazz = WebDriverConnectionProvider.class;
        synchronized (WebDriverConnectionProvider.class) {
            if (this.driver != null) return;
            this.driver = this.createNewWebDriver();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void stop() throws MuleException {
        if (this.driver != null) {
            LOGGER.debug("Quitting Selenium WebDriver");
            this.driver.quit();
            this.driver = null;
        }
    }

    public WebDriver createNewWebDriver() {
        ChromeOptions options = new ChromeOptions();
        if (CloudHubChromeConfigurer.isCloudHubDeployment()) {
            CloudHubChromeConfigurer.setup();
            options.setBinary("/tmp/chrome-linux64/chrome-lib-wrapper");
            options.addArguments(new String[]{"--blink-settings=imagesEnabled=false"});
            options.addArguments(new String[]{"--disable-software-rasterizer"});
            options.addArguments(new String[]{"--disable-background-networking"});
            options.addArguments(new String[]{"--disable-sync"});
            options.addArguments(new String[]{"--disable-default-apps"});
            options.addArguments(new String[]{"--renderer-process-limit=1"});
        } else {
            options.addArguments(new String[]{"--headless"});
        }
        options.addArguments(new String[]{"--disable-gpu"});
        options.addArguments(new String[]{"--no-sandbox"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
        options.addArguments(new String[]{"--allow-running-insecure-content"});
        if (!this.userAgent.isEmpty()) {
            options.addArguments(new String[]{"--user-agent=" + this.userAgent});
        }
        if (!this.referrer.isEmpty()) {
            options.addArguments(new String[]{"--referer=" + this.referrer});
        }
        this.driver = new ChromeDriver(options);
        String actualUserAgent = (String)((JavascriptExecutor)this.driver).executeScript("return navigator.userAgent;", new Object[0]);
        LOGGER.info("User Agent: {}", (Object)actualUserAgent);
        return this.driver;
    }
}

