/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.html2markdown;

import java.util.function.BiFunction;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.mule.extension.webcrawler.internal.html2markdown.ElementConverter;

class BlockquoteConverter
implements ElementConverter {
    BlockquoteConverter() {
    }

    @Override
    public String convert(Element element, BiFunction<Element, Integer, String> childConverter, int depth) {
        StringBuilder markdown = new StringBuilder();
        for (Node node : element.childNodes()) {
            String[] lines;
            if (node instanceof TextNode) {
                String[] lines2;
                for (String line : lines2 = ((TextNode)node).text().split("\\n")) {
                    markdown.append("> ").append(line.trim()).append("\n");
                }
                continue;
            }
            if (!(node instanceof Element)) continue;
            String childMarkdown = childConverter.apply((Element)node, depth + 1);
            for (String line : lines = childMarkdown.split("\\n")) {
                markdown.append("> ").append(line).append("\n");
            }
        }
        markdown.append("\n");
        return markdown.toString();
    }
}

