/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.html2markdown;

import java.util.function.BiFunction;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.mule.extension.webcrawler.internal.html2markdown.ElementConverter;

class CodeBlockConverter
implements ElementConverter {
    CodeBlockConverter() {
    }

    @Override
    public String convert(Element element, BiFunction<Element, Integer, String> childConverter, int depth) {
        String language = "";
        if (element.hasClass("language-") && element.className().contains("language-")) {
            language = element.className().substring(element.className().indexOf("language-") + "language-".length()).split("\\s+")[0];
        } else {
            Element codeElement = element.selectFirst("code[data-language]");
            if (codeElement != null) {
                language = codeElement.attr("data-language");
            }
        }
        StringBuilder content = new StringBuilder();
        for (Node node : element.childNodes()) {
            if (node instanceof TextNode) {
                content.append(((TextNode)node).text());
                continue;
            }
            if (!(node instanceof Element)) continue;
            content.append(((Element)node).text());
        }
        return "```" + language + "\n" + content.toString() + "\n```\n\n";
    }
}

