/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.html2markdown;

import java.util.function.BiFunction;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.mule.extension.webcrawler.internal.html2markdown.ElementConverter;

class TableConverter
implements ElementConverter {
    TableConverter() {
    }

    @Override
    public String convert(Element element, BiFunction<Element, Integer, String> childConverter, int depth) {
        int i;
        if (depth > 1) {
            return element.text();
        }
        StringBuilder markdown = new StringBuilder();
        Elements rows = element.select("tr");
        if (rows.isEmpty()) {
            return "";
        }
        Elements headerCells = rows.first().select("th, td");
        if (!headerCells.isEmpty()) {
            for (i = 0; i < headerCells.size(); ++i) {
                StringBuilder cellContent = new StringBuilder();
                for (Node node : ((Element)headerCells.get(i)).childNodes()) {
                    if (node instanceof TextNode) {
                        cellContent.append(((TextNode)node).text());
                        continue;
                    }
                    if (!(node instanceof Element)) continue;
                    cellContent.append(childConverter.apply((Element)node, depth + 1));
                }
                markdown.append(cellContent.toString());
                if (i >= headerCells.size() - 1) continue;
                markdown.append(" | ");
            }
            markdown.append("\n");
            for (i = 0; i < headerCells.size(); ++i) {
                markdown.append("---");
                if (i >= headerCells.size() - 1) continue;
                markdown.append(" | ");
            }
            markdown.append("\n");
        }
        int n = i = headerCells.isEmpty() ? 0 : 1;
        while (i < rows.size()) {
            Elements dataCells = ((Element)rows.get(i)).select("td");
            for (int j = 0; j < dataCells.size(); ++j) {
                StringBuilder cellContent = new StringBuilder();
                for (Node node : ((Element)dataCells.get(j)).childNodes()) {
                    if (node instanceof TextNode) {
                        cellContent.append(((TextNode)node).text());
                        continue;
                    }
                    if (!(node instanceof Element)) continue;
                    cellContent.append(childConverter.apply((Element)node, depth + 1));
                }
                markdown.append(cellContent.toString());
                if (j >= dataCells.size() - 1) continue;
                markdown.append(" | ");
            }
            markdown.append("\n");
            ++i;
        }
        markdown.append("\n");
        return markdown.toString();
    }
}

