/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.webcrawler.internal.connection.webdriver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.mule.extension.webcrawler.internal.config.PageLoadOptions;
import org.mule.extension.webcrawler.internal.connection.WebCrawlerConnection;
import org.mule.extension.webcrawler.internal.connection.webdriver.WebDriverConnectionProvider;
import org.mule.extension.webcrawler.internal.helper.webdriver.CloudHubChromeConfigurer;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.v139.fetch.Fetch;
import org.openqa.selenium.devtools.v139.log.Log;
import org.openqa.selenium.devtools.v139.network.Network;
import org.openqa.selenium.devtools.v139.network.model.Headers;
import org.openqa.selenium.devtools.v139.overlay.Overlay;
import org.openqa.selenium.devtools.v139.page.Page;
import org.openqa.selenium.devtools.v139.performance.Performance;
import org.openqa.selenium.devtools.v139.runtime.Runtime;
import org.openqa.selenium.devtools.v139.security.Security;
import org.openqa.selenium.support.ui.FluentWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverConnection
implements WebCrawlerConnection {
    private static Logger LOGGER = LoggerFactory.getLogger(WebDriverConnection.class);
    private WebDriver driver;
    private String userAgent;
    private String referrer;
    private WebDriverConnectionProvider connectionProvider;
    private DevTools devTools;

    public WebDriverConnection(WebDriver driver, String userAgent, String referrer, WebDriverConnectionProvider connectionProvider) {
        this.driver = driver;
        this.userAgent = userAgent;
        this.referrer = referrer;
        this.connectionProvider = connectionProvider;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public String getReferrer() {
        return this.referrer;
    }

    @Override
    public synchronized void restartDriver() {
        LOGGER.info("Restarting WebDriver for new crawl");
        try {
            if (this.driver != null) {
                this.driver.quit();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while quitting the old WebDriver: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.driver = null;
        }
        this.driver = this.connectionProvider.createNewWebDriver();
    }

    private void configureDevTools() {
        this.devTools = ((ChromeDriver)this.driver).getDevTools();
        this.devTools.createSession();
        this.devTools.send(Network.enable(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        this.devTools.send(Network.setCacheDisabled((Boolean)true));
        this.devTools.send(Log.disable());
        this.devTools.send(Performance.disable());
        this.devTools.send(Page.disable());
        this.devTools.send(Runtime.disable());
        this.devTools.send(Overlay.disable());
        this.devTools.send(Security.disable());
        this.devTools.send(Fetch.disable());
    }

    @Override
    public CompletableFuture<InputStream> getPageSource(String url, String currentReferrer, PageLoadOptions pageLoadOptions) {
        LOGGER.debug(String.format("Retrieving page source for url %s using webdrive (wait %s millisec)", url, pageLoadOptions.getWaitOnPageLoad()));
        return CompletableFuture.supplyAsync(() -> {
            if (!(CloudHubChromeConfigurer.isCloudHubDeployment() || currentReferrer == null || currentReferrer.isEmpty() || currentReferrer.equalsIgnoreCase(this.referrer))) {
                try {
                    if (this.devTools == null || this.devTools.getCdpSession() == null) {
                        this.configureDevTools();
                    }
                    Map<String, String> headers = Map.of("User-Agent", this.userAgent, "Referer", currentReferrer);
                    this.devTools.send(Network.setExtraHTTPHeaders((Headers)new Headers(headers)));
                }
                catch (Exception e) {
                    LOGGER.debug("Error while trying to set referer for web driver");
                }
            }
            this.driver.get(url);
            Long effectiveTimeout = Optional.ofNullable(pageLoadOptions.getWaitOnPageLoad()).filter(t -> t > 0L).orElse(30000L);
            JavascriptExecutor js = (JavascriptExecutor)this.driver;
            new FluentWait((Object)this.driver).withTimeout(Duration.ofSeconds(effectiveTimeout)).pollingEvery(Duration.ofMillis(500L)).until(d -> js.executeScript("return document.readyState", new Object[0]).equals("complete"));
            if (pageLoadOptions.getWaitForXPath() != null && pageLoadOptions.getWaitForXPath().compareTo("") != 0) {
                this.waitForXPathLoad(effectiveTimeout, pageLoadOptions.getWaitForXPath());
            }
            if (pageLoadOptions.getJavascript() != null && !pageLoadOptions.getJavascript().isEmpty()) {
                LOGGER.debug(String.format("Executing javascript %s", pageLoadOptions.getJavascript()));
                this.executeScript(pageLoadOptions.getJavascript());
            }
            String pageSource = this.driver.getPageSource();
            return new ByteArrayInputStream(pageSource.getBytes(StandardCharsets.UTF_8));
        });
    }

    private void waitForXPathLoad(Long waitOnPageLoad, String waitForXPath) {
        LOGGER.debug(String.format("Wait until %s for %s milliseconds", waitForXPath, waitOnPageLoad));
        try {
            new FluentWait((Object)this.driver).withTimeout(Duration.ofSeconds(waitOnPageLoad)).pollingEvery(Duration.ofMillis(500L)).until(d -> {
                boolean finalElementPresent = false;
                try {
                    this.driver.findElement(By.xpath((String)waitForXPath));
                    finalElementPresent = true;
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                return finalElementPresent;
            });
        }
        catch (TimeoutException e) {
            LOGGER.warn(String.format("Element %s not found within the timeout period %s", waitForXPath, waitOnPageLoad));
        }
    }

    public void injectAllShadowDOMs(Document document, String shadowHostXPath) {
        JavascriptExecutor jsExecutor = (JavascriptExecutor)this.driver;
        if (shadowHostXPath == null) {
            shadowHostXPath = "//*";
        }
        List shadowHosts = this.driver.findElements(By.xpath((String)shadowHostXPath));
        for (WebElement shadowHost : shadowHosts) {
            Boolean hasShadowRoot = (Boolean)jsExecutor.executeScript("return arguments[0].shadowRoot !== null", new Object[]{shadowHost});
            if (!hasShadowRoot.booleanValue()) continue;
            String shadowContent = (String)jsExecutor.executeScript("return arguments[0].shadowRoot.innerHTML;", new Object[]{shadowHost});
            String tagName = shadowHost.getTagName();
            String jsoupXPath = tagName;
            Element jsoupElement = document.selectFirst(jsoupXPath);
            if (jsoupElement != null) {
                jsoupElement.append(shadowContent);
            }
            this.injectNestedShadowDOMs(jsExecutor, document, shadowHost);
        }
    }

    private void injectNestedShadowDOMs(JavascriptExecutor jsExecutor, Document document, WebElement shadowHost) {
        String shadowRootContent = (String)jsExecutor.executeScript("return arguments[0].shadowRoot ? arguments[0].shadowRoot.innerHTML : null;", new Object[]{shadowHost});
        if (shadowRootContent != null) {
            String tagName = shadowHost.getTagName();
            Element jsoupElement = document.selectFirst(tagName);
            if (jsoupElement != null) {
                jsoupElement.append(shadowRootContent);
            }
            List nestedElements = (List)jsExecutor.executeScript("return Array.from(arguments[0].shadowRoot.querySelectorAll('*'))", new Object[]{shadowHost});
            for (WebElement nestedElement : nestedElements) {
                this.injectNestedShadowDOMs(jsExecutor, document, nestedElement);
            }
        }
    }

    private void executeScript(String script) {
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        js.executeScript(script, new Object[0]);
    }

    @Override
    public CompletableFuture<Integer> getUrlStatusCode(String url, String currentReferrer) {
        LOGGER.debug(String.format("Checking status for url %s using webdriver", url));
        return CompletableFuture.supplyAsync(() -> {
            if (!(CloudHubChromeConfigurer.isCloudHubDeployment() || currentReferrer == null || currentReferrer.isEmpty() || currentReferrer.equalsIgnoreCase(this.referrer))) {
                try {
                    if (this.devTools == null || this.devTools.getCdpSession() == null) {
                        this.configureDevTools();
                    }
                    this.devTools.send(Network.setExtraHTTPHeaders((Headers)new Headers(Map.of("Referer", currentReferrer))));
                }
                catch (Exception e) {
                    LOGGER.debug("Error while trying to set referer for web driver");
                }
            }
            this.driver.get(url);
            JavascriptExecutor js = (JavascriptExecutor)this.driver;
            Object status = js.executeScript("return fetch(arguments[0], { method: 'HEAD' }).then(response => response.status).catch(() => 0);", new Object[]{url});
            return status instanceof Long ? ((Long)status).intValue() : 500;
        });
    }
}

