/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.whisperer.internal.connection.openai;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.json.JSONObject;
import org.mule.extension.whisperer.api.OpenAiTranscriptionAttributes;
import org.mule.extension.whisperer.api.STTParamsModelDetails;
import org.mule.extension.whisperer.api.TTSParamsModelDetails;
import org.mule.extension.whisperer.internal.connection.WhisperConnection;
import org.mule.extension.whisperer.internal.error.GenerationException;
import org.mule.extension.whisperer.internal.error.TranscriptionException;
import org.mule.extension.whisperer.internal.helpers.audio.AudioUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAiConnection
implements WhisperConnection {
    private static Logger LOGGER = LoggerFactory.getLogger(OpenAiConnection.class);
    private final String apiKey;
    private final HttpClient httpClient;
    private final URI apiUri;

    public OpenAiConnection(String apiKey, HttpClient httpClient, URI apiUri) {
        this.apiKey = apiKey;
        this.httpClient = httpClient;
        this.apiUri = apiUri;
    }

    public void validate() throws ConnectionException {
        URI healthCheckEndpoint = this.apiUri.resolve("models");
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().addHeader("Authorization", "Bearer " + this.apiKey)).method(HttpConstants.Method.GET).uri(healthCheckEndpoint).build();
        try {
            HttpResponse response = this.httpClient.send(request);
            if (200 != response.getStatusCode()) {
                throw new ConnectionException("Unexpected status code " + response.getStatusCode() + " from " + healthCheckEndpoint.toString());
            }
            LOGGER.trace("Successfully validated connection " + healthCheckEndpoint.toString());
        }
        catch (IOException e) {
            throw new ConnectionException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new ConnectionException((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Result<String, Object>> transcribe(TypedValue<InputStream> audioContent, String fineTuningPrompt, STTParamsModelDetails params) {
        URI transcriptionEndpoint = this.apiUri.resolve("audio/transcriptions");
        String responseFormat = "text";
        if (params.isVerbose()) {
            responseFormat = "verbose_json";
        }
        byte[] audioBytes = IOUtils.toByteArray((InputStream)((InputStream)audioContent.getValue()));
        ArrayList<HttpPart> parts = new ArrayList<HttpPart>();
        parts.add(new HttpPart("model", params.getModelName().getBytes(), "text/plain", params.getModelName().getBytes().length));
        parts.add(new HttpPart("response_format", responseFormat.getBytes(), "text/plain", responseFormat.getBytes().length));
        parts.add(new HttpPart("file", "speech." + AudioUtils.guessAudioFileExtension(audioContent.getDataType().getMediaType()), audioBytes, audioContent.getDataType().getMediaType().toString(), audioBytes.length));
        if (null != fineTuningPrompt && !fineTuningPrompt.isEmpty()) {
            parts.add(new HttpPart("prompt", fineTuningPrompt.getBytes(), "text/plain", fineTuningPrompt.getBytes().length));
        }
        if (params.getTemperature().floatValue() > 0.0f) {
            parts.add(new HttpPart("temperature", params.getTemperature().toString().getBytes(), "text/plain", params.getTemperature().toString().getBytes().length));
        }
        if (null != params.getLanguage() && !params.getLanguage().isEmpty()) {
            parts.add(new HttpPart("language", params.getLanguage().getBytes(), "text/plain", params.getLanguage().getBytes().length));
        }
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().addHeader("Authorization", "Bearer " + this.apiKey)).method(HttpConstants.Method.POST).uri(transcriptionEndpoint).entity((HttpEntity)new MultipartHttpEntity(parts))).build();
        return this.httpClient.sendAsync(request).thenApply(response -> {
            if (200 != response.getStatusCode()) {
                LOGGER.error(IOUtils.toString((InputStream)response.getEntity().getContent()));
                throw new TranscriptionException("Unexpected status code " + response.getStatusCode() + " from OpenAI API");
            }
            if (params.isVerbose()) {
                JSONObject responseObject = new JSONObject(IOUtils.toString((InputStream)response.getEntity().getContent()));
                OpenAiTranscriptionAttributes attributes = new OpenAiTranscriptionAttributes();
                attributes.setLanguage(responseObject.optString("language"));
                attributes.setDuration(responseObject.optDouble("duration"));
                return Result.builder().output((Object)responseObject.getString("text")).attributes((Object)attributes).build();
            }
            return Result.builder().output((Object)IOUtils.toString((InputStream)response.getEntity().getContent())).build();
        });
    }

    @Override
    public CompletableFuture<InputStream> generate(String text, TTSParamsModelDetails params) {
        URI speechEndpoint = this.apiUri.resolve("audio/speech");
        JSONObject requestObject = new JSONObject();
        requestObject.put("model", (Object)params.getModelName());
        requestObject.put("input", (Object)text);
        requestObject.put("voice", (Object)params.getVoice());
        requestObject.put("response_format", (Object)params.getResponseFormat());
        requestObject.put("speed", (Object)params.getSpeed());
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().addHeader("Authorization", "Bearer " + this.apiKey)).method(HttpConstants.Method.POST).uri(speechEndpoint).addHeader("Content-Type", "application/json")).entity((HttpEntity)new ByteArrayHttpEntity(requestObject.toString().getBytes()))).build();
        return this.httpClient.sendAsync(request).thenApply(response -> {
            if (200 != response.getStatusCode()) {
                LOGGER.error(IOUtils.toString((InputStream)response.getEntity().getContent()));
                throw new GenerationException("Unexpected status code " + response.getStatusCode() + " from OpenAI API");
            }
            return response.getEntity().getContent();
        });
    }
}

