/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.whisperer.internal.connection.openai;

import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import org.mule.extension.whisperer.internal.connection.openai.OpenAiConnection;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;

@Alias(value="openai")
@DisplayName(value="OpenAI")
public class OpenAiConnectionProvider
implements CachedConnectionProvider<OpenAiConnection>,
Startable,
Stoppable {
    private static final String API_URL = "https://api.openai.com/v1/";
    @Parameter
    private String apiKey;
    private HttpClient httpClient;
    @RefName
    private String configName;
    @Inject
    private HttpService httpService;
    @Parameter
    @Optional
    private TlsContextFactory tlsContext;

    public OpenAiConnection connect() throws ConnectionException {
        try {
            return new OpenAiConnection(this.apiKey, this.httpClient, new URI(API_URL));
        }
        catch (URISyntaxException e) {
            throw new ConnectionException((Throwable)e);
        }
    }

    public void disconnect(OpenAiConnection openAiConnection) {
    }

    public ConnectionValidationResult validate(OpenAiConnection openAiConnection) {
        try {
            openAiConnection.validate();
            return ConnectionValidationResult.success();
        }
        catch (ConnectionException e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void start() throws MuleException {
        HttpClientConfiguration config = this.createClientConfiguration();
        this.httpClient = this.httpService.getClientFactory().create(config);
        this.httpClient.start();
    }

    private HttpClientConfiguration createClientConfiguration() {
        HttpClientConfiguration.Builder builder = new HttpClientConfiguration.Builder().setName(this.configName);
        if (null != this.tlsContext) {
            builder.setTlsContextFactory(this.tlsContext);
        } else {
            builder.setTlsContextFactory(TlsContextFactory.builder().buildDefault());
        }
        return builder.build();
    }

    public void stop() throws MuleException {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }
}

