/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.whisperer.internal.connection.whisperjni;

import io.github.givimad.whisperjni.WhisperContext;
import io.github.givimad.whisperjni.WhisperFullParams;
import io.github.givimad.whisperjni.WhisperJNI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.mule.extension.whisperer.api.STTParamsModelDetails;
import org.mule.extension.whisperer.api.TTSParamsModelDetails;
import org.mule.extension.whisperer.api.error.ConnectorError;
import org.mule.extension.whisperer.internal.connection.WhisperConnection;
import org.mule.extension.whisperer.internal.error.ConnectionIncompatibleException;
import org.mule.extension.whisperer.internal.error.TranscriptionException;
import org.mule.extension.whisperer.internal.helpers.audio.AudioFileReader;
import org.mule.extension.whisperer.internal.helpers.audio.AudioUtils;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhisperJNIConnection
implements WhisperConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(WhisperJNIConnection.class);
    private final WhisperJNI whisper;
    private final WhisperContext whisperContext;
    private final int threads;
    private final boolean translate;
    private final boolean printProgress;

    public WhisperJNIConnection(WhisperJNI whisper, WhisperContext whisperContext, int threads, boolean translate, boolean printProgress) {
        this.whisper = whisper;
        this.whisperContext = whisperContext;
        this.threads = threads;
        this.translate = translate;
        this.printProgress = printProgress;
    }

    @Override
    public CompletableFuture<Result<String, Object>> transcribe(TypedValue<InputStream> audioContent, String fineTuningPrompt, STTParamsModelDetails params) {
        WhisperFullParams whisperParams = new WhisperFullParams();
        whisperParams.nThreads = this.threads;
        whisperParams.translate = this.translate;
        whisperParams.printProgress = this.printProgress;
        whisperParams.language = params.getLanguage();
        whisperParams.temperature = params.getTemperature().floatValue();
        whisperParams.initialPrompt = fineTuningPrompt;
        LOGGER.debug("Whisper context initialized successfully. Processing audio input.");
        String appHomePath = System.getProperty("app.home");
        File tempAudioFile = new File(appHomePath, "audio." + AudioUtils.guessAudioFileExtension(audioContent.getDataType().getMediaType()));
        try (FileOutputStream outStream = new FileOutputStream(tempAudioFile);){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = ((InputStream)audioContent.getValue()).read(buffer)) != -1) {
                ((OutputStream)outStream).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            return CompletableFuture.supplyAsync(() -> {
                throw new TranscriptionException("Unable to buffer audio data for transcription", e);
            });
        }
        LOGGER.trace("Audio file successfully saved to temporary file: {}", (Object)tempAudioFile.getAbsolutePath());
        String processedFilePath = tempAudioFile.getAbsolutePath();
        String audioFormat = AudioUtils.guessAudioFormat(audioContent.getDataType().getMediaType());
        if (audioFormat != null) {
            try {
                LOGGER.trace("Converting audio file to WAV format.");
                String wavFilePath = processedFilePath.replaceAll("\\.\\w+$", ".wav");
                switch (audioFormat) {
                    case "wav": {
                        break;
                    }
                    case "mp3": {
                        AudioFileReader.convertMp3ToWav(processedFilePath, wavFilePath);
                        processedFilePath = wavFilePath;
                        break;
                    }
                    case "m4a": {
                        AudioFileReader.convertM4AToWavWithFFmpeg(processedFilePath, wavFilePath);
                        processedFilePath = wavFilePath;
                        break;
                    }
                    default: {
                        throw new ModuleException("Audio format not supported: " + audioFormat, (ErrorTypeDefinition)ConnectorError.AUDIO_FORMAT_NOT_SUPPORTED);
                    }
                }
                LOGGER.debug("Audio file converted to WAV format: {}", (Object)wavFilePath);
            }
            catch (IOException | UnsupportedAudioFileException e) {
                return CompletableFuture.supplyAsync(() -> {
                    throw new TranscriptionException("Error converting audio content to wav format", e);
                });
            }
        } else {
            throw new ModuleException("Audio format not supported: " + audioContent.getDataType().getMediaType().toString(), (ErrorTypeDefinition)ConnectorError.AUDIO_FORMAT_NOT_SUPPORTED);
        }
        LOGGER.trace("Reading audio file and extracting samples.");
        try {
            float[] samples = AudioFileReader.readFile(new File(processedFilePath));
            LOGGER.debug("Performing speech-to-text operation with local Whisper.");
            int result = this.whisper.full(this.whisperContext, whisperParams, samples, samples.length);
            if (result != 0) {
                return CompletableFuture.supplyAsync(() -> {
                    throw new TranscriptionException("Transcription failed with code " + result);
                });
            }
            int segments = this.whisper.fullNSegments(this.whisperContext);
            StringBuilder transcription = new StringBuilder();
            for (int i = 0; i < segments; ++i) {
                transcription.append(this.whisper.fullGetSegmentText(this.whisperContext, i)).append(" ");
            }
            return CompletableFuture.supplyAsync(() -> Result.builder().output((Object)transcription.toString()).build());
        }
        catch (IOException | UnsupportedAudioFileException e) {
            return CompletableFuture.supplyAsync(() -> {
                throw new TranscriptionException(e);
            });
        }
    }

    @Override
    public CompletableFuture<InputStream> generate(String text, TTSParamsModelDetails params) {
        return CompletableFuture.supplyAsync(() -> {
            throw new ConnectionIncompatibleException("Operation not supported by Local Whisper connection");
        });
    }

    public WhisperContext getWhisperContext() {
        return this.whisperContext;
    }
}

