/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.whisperer.internal.connection.whisperjni;

import io.github.givimad.whisperjni.WhisperContext;
import io.github.givimad.whisperjni.WhisperJNI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.mule.extension.whisperer.internal.connection.whisperjni.WhisperJNIConnection;
import org.mule.extension.whisperer.internal.connection.whisperjni.WhisperJNIRemoteModelParameters;
import org.mule.extension.whisperer.internal.helpers.models.WhisperJNICloudhubConfigurer;
import org.mule.extension.whisperer.internal.helpers.models.WhisperJNIModelConfigurer;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.lifecycle.StartException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="whisperjniurl")
@DisplayName(value="Whisper JNI (Remote .bin)")
public class WhisperJNIRemoteConnectionProvider
implements CachedConnectionProvider<WhisperJNIConnection>,
Startable,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WhisperJNIRemoteConnectionProvider.class);
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="4")
    private int threads;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="false")
    private boolean translate;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="false")
    private boolean printProgress;
    @ParameterGroup(name="Model")
    @Expression(value=ExpressionSupport.SUPPORTED)
    private WhisperJNIRemoteModelParameters model;
    private WhisperJNI whisper;
    private WhisperContext whisperContext;

    public WhisperJNIConnection connect() throws ConnectionException {
        return new WhisperJNIConnection(this.whisper, this.whisperContext, this.threads, this.translate, this.printProgress);
    }

    public void disconnect(WhisperJNIConnection whisperJNIConnection) {
    }

    public ConnectionValidationResult validate(WhisperJNIConnection whisperJNIConnection) {
        return ConnectionValidationResult.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void start() throws MuleException {
        try {
            String modelFilePathString = this.model.getInstallationFilePath();
            Path modelFilePath = Paths.get(modelFilePathString, new String[0]);
            if (!Files.exists(modelFilePath, new LinkOption[0])) {
                Class<WhisperJNIRemoteConnectionProvider> clazz = WhisperJNIRemoteConnectionProvider.class;
                // MONITORENTER : org.mule.extension.whisperer.internal.connection.whisperjni.WhisperJNIRemoteConnectionProvider.class
                if (!Files.exists(modelFilePath, new LinkOption[0])) {
                    WhisperJNIModelConfigurer.setup(this.model.getModelURL(), this.model.getInstallationFilePath());
                }
                // MONITOREXIT : clazz
            }
            if (WhisperJNICloudhubConfigurer.isCloudHubDeployment()) {
                LOGGER.info("CloudHub deployment detected. Performing CloudHub specific setup.");
                Path dependenciesPath = Paths.get("/tmp/whisper-deps-linux64", new String[0]);
                if (!Files.exists(dependenciesPath, new LinkOption[0])) {
                    Class<WhisperJNIRemoteConnectionProvider> clazz = WhisperJNIRemoteConnectionProvider.class;
                    // MONITORENTER : org.mule.extension.whisperer.internal.connection.whisperjni.WhisperJNIRemoteConnectionProvider.class
                    if (!Files.exists(dependenciesPath, new LinkOption[0])) {
                        WhisperJNICloudhubConfigurer.setup();
                    }
                    // MONITOREXIT : clazz
                }
            }
            WhisperJNI.loadLibrary();
            this.whisper = new WhisperJNI();
            this.whisperContext = this.whisper.init(modelFilePath);
            return;
        }
        catch (IOException e) {
            throw new StartException((Throwable)e, (Startable)this);
        }
    }

    public void stop() throws MuleException {
        if (null != this.whisperContext) {
            this.whisperContext.close();
        }
    }
}

