/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.whisperer.internal.connection.whisperjni;

import java.net.MalformedURLException;
import java.net.URL;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class WhisperJNIRemoteModelParameters {
    @Parameter
    @DisplayName(value="Repository url")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Placement(order=1)
    @Example(value="https://huggingface.co/ggerganov/whisper.cpp/blob/main/ggml-large-v3-turbo-q8_0.bin")
    private String modelURL;
    @Parameter
    @DisplayName(value="Installation file path")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Placement(order=2)
    @Example(value="mule.home ++ \"/apps/\" ++ app.name ++ \"/model.bin\"")
    private String installationFilePath;

    public String getModelURL() {
        return this.modelURL;
    }

    public void setModelURL(String modelURL) {
        this.modelURL = modelURL;
    }

    public String getInstallationFilePath() {
        return this.installationFilePath;
    }

    public void setInstallationFilePath(String installationFilePath) {
        this.installationFilePath = installationFilePath;
    }

    private String getModelFileName() {
        try {
            URL urlObj = new URL(this.modelURL);
            String path = urlObj.getPath();
            String fileName = path.substring(path.lastIndexOf(47) + 1);
            if (fileName.isEmpty()) {
                throw new IllegalArgumentException("No filename found in URL: " + this.modelURL);
            }
            return fileName;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + this.modelURL, e);
        }
    }
}

