/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.whisperer.internal.helpers.audio;

import com.github.kokorin.jaffree.ffmpeg.FFmpeg;
import com.github.kokorin.jaffree.ffmpeg.Input;
import com.github.kokorin.jaffree.ffmpeg.Output;
import com.github.kokorin.jaffree.ffmpeg.UrlInput;
import com.github.kokorin.jaffree.ffmpeg.UrlOutput;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.mule.extension.whisperer.internal.helpers.audio.Mp3ToWavConverter;

public class AudioFileReader {
    public static float[] readFile(File audioFile) throws UnsupportedAudioFileException, IOException {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(audioFile);
        AudioFormat format = audioInputStream.getFormat();
        if (format.getChannels() != 1 || format.getSampleRate() != 16000.0f) {
            File convertedFile = AudioFileReader.convertToMono16kHz(audioFile);
            return AudioFileReader.readFile(convertedFile);
        }
        ByteBuffer captureBuffer = ByteBuffer.allocate(audioInputStream.available());
        captureBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int bytesRead = audioInputStream.read(captureBuffer.array());
        if (bytesRead == -1) {
            throw new IOException("Unable to read audio file: " + audioFile.getAbsolutePath());
        }
        ShortBuffer shortBuffer = captureBuffer.asShortBuffer();
        float[] samples = new float[shortBuffer.capacity()];
        int i = 0;
        while (shortBuffer.hasRemaining()) {
            samples[i++] = Math.max(-1.0f, Math.min((float)shortBuffer.get() / 32767.0f, 1.0f));
        }
        return samples;
    }

    public static File convertToMono16kHz(File inputFile) throws UnsupportedAudioFileException, IOException {
        File outputFile = new File(inputFile.getParent(), "converted_16kHz_mono.wav");
        AudioInputStream inputStream = AudioSystem.getAudioInputStream(inputFile);
        AudioFormat originalFormat = inputStream.getFormat();
        AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, false);
        AudioInputStream convertedStream = AudioSystem.getAudioInputStream(targetFormat, inputStream);
        AudioSystem.write(convertedStream, AudioFileFormat.Type.WAVE, outputFile);
        return outputFile;
    }

    public static void convertMp3ToWav(String mp3FilePath, String wavFilePath) throws IOException, UnsupportedAudioFileException {
        Mp3ToWavConverter.convertMp3ToWav(mp3FilePath, wavFilePath);
    }

    public static void convertM4AToWavWithFFmpeg(String m4aFilePath, String wavFilePath) throws IOException {
        try {
            FFmpeg ffmpeg = FFmpeg.atPath((Path)Paths.get("/opt/homebrew/Cellar/ffmpeg/7.1_4/bin", new String[0])).addInput((Input)UrlInput.fromPath((Path)Paths.get(m4aFilePath, new String[0]))).addOutput((Output)UrlOutput.toPath((Path)Paths.get(wavFilePath, new String[0])).addArguments("-acodec", "pcm_s16le")).setOverwriteOutput(true);
            ffmpeg.execute();
            System.out.println("\nConversion finished successfully!");
        }
        catch (Exception e) {
            System.err.println("\nError during conversion: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

