/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.whisperer.internal.helpers.models;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhisperJNICloudhubConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WhisperJNICloudhubConfigurer.class);
    public static final String WHISPER_DEPENDENCY_RESOURCE_PATH = "/cloudhub-whisper-dependencies.zip";
    public static final String WHISPER_DEPENDENCY_LIBS_PATH = "/tmp/whisper-deps-linux64";

    public static boolean isCloudHubDeployment() {
        return Boolean.getBoolean("cloudhub.deployment");
    }

    public static void setup() {
        try {
            LOGGER.info("Setting up Whisper JNI for CloudHub deployment. io.github.givimad.whisperjni.libdir={}", (Object)WHISPER_DEPENDENCY_LIBS_PATH);
            System.setProperty("io.github.givimad.whisperjni.libdir", WHISPER_DEPENDENCY_LIBS_PATH);
            LOGGER.info("Extracting Whisper JNI dependencies from JAR resource.");
            WhisperJNICloudhubConfigurer.extractSoLibs();
        }
        catch (Exception e) {
            LOGGER.error("Error in Whisper setup", (Throwable)e);
        }
    }

    private static void extractSoLibs() throws IOException {
        File tempZip = File.createTempFile("whisper-dependencies", ".zip", new File("/tmp"));
        LOGGER.info("Extracting {}.", (Object)WHISPER_DEPENDENCY_RESOURCE_PATH);
        try (InputStream zipStream = WhisperJNICloudhubConfigurer.class.getResourceAsStream(WHISPER_DEPENDENCY_RESOURCE_PATH);
             FileOutputStream outStream = new FileOutputStream(tempZip);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = zipStream.read(buffer)) != -1) {
                ((OutputStream)outStream).write(buffer, 0, bytesRead);
            }
        }
        File destDir = new File(WHISPER_DEPENDENCY_LIBS_PATH);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try (ZipFile zipFile = new ZipFile(tempZip);){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                String fileName = new File(entry.getName()).getName();
                ZipArchiveEntry newEntry = new ZipArchiveEntry(fileName);
                newEntry.setUnixMode(entry.getUnixMode());
                LOGGER.info("Extracting Whisper JNI dependency {}", (Object)fileName);
                WhisperJNICloudhubConfigurer.extractZipEntry(zipFile, entry, destDir, fileName);
            }
        }
        tempZip.delete();
    }

    private static void extractZipEntry(ZipFile zipFile, ZipArchiveEntry entry, File destDir, String fileName) throws IOException {
        File outputFile = new File(destDir, fileName);
        if (!entry.isDirectory()) {
            if (entry.isUnixSymlink()) {
                String targetPath = zipFile.getUnixSymlink(entry);
                String targetFileName = new File(targetPath).getName();
                Path target = Paths.get(destDir.getAbsolutePath(), targetFileName);
                Files.createSymbolicLink(outputFile.toPath(), target, new FileAttribute[0]);
            } else {
                Files.copy(zipFile.getInputStream(entry), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                Files.setPosixFilePermissions(outputFile.toPath(), PosixFilePermissions.fromString("rwxr-xr-x"));
            }
            if ((entry.getUnixMode() & 0x40) != 0) {
                outputFile.setExecutable(true);
            }
        }
    }
}

