/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.whisperer.internal.helpers.models;

import java.io.File;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.mule.extension.whisperer.api.error.ConnectorError;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhisperJNIModelConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WhisperJNIModelConfigurer.class);

    public static void setup(String modelURL, String modelFilePath) {
        try {
            LOGGER.info("Downloading Whisper Model from: {}", (Object)modelURL);
            FileUtils.copyURLToFile((URL)new URL(modelURL), (File)new File(modelFilePath));
            LOGGER.info("Whisper Model downloaded from {} and installed at {}", (Object)modelURL, (Object)modelFilePath);
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Failed to download model file from URL: %s ", modelURL), (ErrorTypeDefinition)ConnectorError.MODEL_SETUP_FAILURE, (Throwable)e);
        }
    }
}

