/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.whisperer.internal.operation;

import java.io.InputStream;
import org.mule.extension.whisperer.api.STTParamsModelDetails;
import org.mule.extension.whisperer.api.TTSParamsModelDetails;
import org.mule.extension.whisperer.internal.connection.WhisperConnection;
import org.mule.extension.whisperer.internal.error.GenerationErrorTypeProvider;
import org.mule.extension.whisperer.internal.error.TranscriptionErrorTypeProvider;
import org.mule.extension.whisperer.internal.metadata.TranscriptionOutputResolver;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhispererOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(WhispererOperations.class);

    @DisplayName(value="Speech to Text")
    @Alias(value="speech-to-text")
    @OutputResolver(output=TranscriptionOutputResolver.class, attributes=TranscriptionOutputResolver.class)
    @MediaType(value="text/plain", strict=false)
    @Throws(value={TranscriptionErrorTypeProvider.class})
    public void transcribe(@Connection WhisperConnection connection, @Content TypedValue<InputStream> audioContent, @Optional String finetuningPrompt, @MetadataKeyId @ParameterGroup(name="Transcription Options") STTParamsModelDetails transcriptionOptions, CompletionCallback<String, Object> callback) {
        connection.transcribe(audioContent, finetuningPrompt, transcriptionOptions).whenComplete((result, e) -> {
            if (null == e) {
                callback.success(Result.builder().output((Object)((String)result.getOutput())).build());
            } else {
                callback.error(e.getCause());
            }
        });
    }

    @DisplayName(value="Text to Speech")
    @Alias(value="text-to-speech")
    @MediaType(value="audio/mp3", strict=false)
    @Throws(value={GenerationErrorTypeProvider.class})
    public void generateSpeech(@Connection WhisperConnection connection, @Content String text, @ParameterGroup(name="Generation Options") TTSParamsModelDetails generationOptions, CompletionCallback<InputStream, Void> callback) {
        connection.generate(text, generationOptions).whenComplete((audioData, e) -> {
            if (null == e) {
                callback.success(Result.builder().output(audioData).mediaType(this.inferMediaType(generationOptions)).build());
            } else {
                callback.error(e.getCause());
            }
        });
    }

    private org.mule.runtime.api.metadata.MediaType inferMediaType(TTSParamsModelDetails params) {
        switch (params.getResponseFormat()) {
            case "mp3": {
                return org.mule.runtime.api.metadata.MediaType.create((String)"audio", (String)"mp3");
            }
            case "ogg": {
                return org.mule.runtime.api.metadata.MediaType.create((String)"audio", (String)"ogg");
            }
            case "aac": {
                return org.mule.runtime.api.metadata.MediaType.create((String)"audio", (String)"aac");
            }
            case "flac": {
                return org.mule.runtime.api.metadata.MediaType.create((String)"audio", (String)"flac");
            }
            case "pcm": {
                return org.mule.runtime.api.metadata.MediaType.create((String)"audio", (String)"pcm");
            }
            case "wav": {
                return org.mule.runtime.api.metadata.MediaType.create((String)"audio", (String)"wav");
            }
        }
        LOGGER.warn("unknown media type for speech response format " + params.getResponseFormat());
        return org.mule.runtime.api.metadata.MediaType.BINARY;
    }
}

