/*
 * Decompiled with CFR 0.152.
 */
package org.mule.custom.annotation.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import java.util.Map;
import org.jsonschema2pojo.AbstractAnnotator;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class CustomMuleAnnotator
extends AbstractAnnotator {
    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
        super.propertyField(field, clazz, propertyName, propertyNode);
        ObjectMapper mapper = new ObjectMapper();
        Map jsonMap = (Map)mapper.convertValue((Object)propertyNode, Map.class);
        Map sdkMap = (Map)jsonMap.get("sdk");
        if (sdkMap != null) {
            System.out.println(">> sdkMap: " + sdkMap);
            field.annotate(Parameter.class);
            if (sdkMap.get("default") != null) {
                String defaultValue = String.valueOf(sdkMap.get("default"));
                System.out.println(">> Found default: " + defaultValue);
                field.annotate(Optional.class).param("defaultValue", defaultValue);
            } else if (sdkMap.get("required") != null && Boolean.FALSE.equals(sdkMap.get("required"))) {
                System.out.println(">> Field is not required");
                field.annotate(Optional.class);
            }
            if (sdkMap.get("displayName") != null) {
                String displayNameValue = String.valueOf(sdkMap.get("displayName"));
                System.out.println(">> Found displayName: " + displayNameValue);
                field.annotate(DisplayName.class).param("value", displayNameValue);
            }
            if (sdkMap.get("summary") != null) {
                String summaryValue = String.valueOf(sdkMap.get("summary"));
                System.out.println(">> Found summary: " + summaryValue);
                field.annotate(Summary.class).param("value", summaryValue);
            }
            if (sdkMap.get("example") != null) {
                String exampleValue = String.valueOf(sdkMap.get("example"));
                System.out.println(">> Found example: " + exampleValue);
                field.annotate(Example.class).param("value", exampleValue);
            }
            if (sdkMap.get("isContent") != null) {
                System.out.println(">> Found isContent: " + String.valueOf(sdkMap.get("isContent")));
                if (Boolean.TRUE.equals(sdkMap.get("isContent"))) {
                    field.annotate(Content.class);
                }
            }
            if (sdkMap.get("isPrimaryContent") != null) {
                System.out.println(">> Found isPrimaryContent: " + String.valueOf(sdkMap.get("isPrimaryContent")));
                if (Boolean.TRUE.equals(sdkMap.get("isPrimaryContent"))) {
                    field.annotate(Content.class).param("primary", true);
                }
            }
            if (sdkMap.get("isNullSafe") != null) {
                System.out.println(">> Found isNullSafe: " + String.valueOf(sdkMap.get("isNullSafe")));
                if (Boolean.TRUE.equals(sdkMap.get("isNullSafe"))) {
                    field.annotate(NullSafe.class);
                }
            }
            if (sdkMap.get("isPassword") != null) {
                System.out.println(">> Found isPassword: " + String.valueOf(sdkMap.get("isPassword")));
                if (Boolean.TRUE.equals(sdkMap.get("isPassword"))) {
                    field.annotate(Password.class);
                }
            }
            if (sdkMap.get("expressionSupport") != null) {
                String expressionSupportValue = String.valueOf(sdkMap.get("expressionSupport"));
                System.out.println(">> Found expressionSupport: " + expressionSupportValue);
                switch (expressionSupportValue) {
                    case "NOT_SUPPORTED": {
                        field.annotate(Expression.class).param("value", (Enum)ExpressionSupport.NOT_SUPPORTED);
                        break;
                    }
                    case "SUPPORTED": {
                        field.annotate(Expression.class).param("value", (Enum)ExpressionSupport.SUPPORTED);
                        break;
                    }
                    case "REQUIRED": {
                        field.annotate(Expression.class).param("value", (Enum)ExpressionSupport.REQUIRED);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("expressionSupport value not supported");
                    }
                }
            }
            if (sdkMap.get("placement") != null) {
                Integer orderValue;
                Map placementMap = (Map)sdkMap.get("placement");
                if (placementMap.get("order") != null && placementMap.get("tab") != null) {
                    orderValue = Integer.valueOf(String.valueOf(placementMap.get("order")));
                    System.out.println(">> Found placement.order: " + orderValue);
                    String tabValue = String.valueOf(placementMap.get("tab"));
                    System.out.println(">> Found placement.tab: " + tabValue);
                    field.annotate(Placement.class).param("order", orderValue.intValue()).param("tab", tabValue);
                } else if (placementMap.get("order") != null) {
                    orderValue = Integer.valueOf(String.valueOf(placementMap.get("order")));
                    System.out.println(">> Found placement.order: " + orderValue);
                    field.annotate(Placement.class).param("order", orderValue.intValue());
                } else if (placementMap.get("tab") != null) {
                    String tabValue = String.valueOf(placementMap.get("tab"));
                    System.out.println(">> Found placement.tab: " + tabValue);
                    field.annotate(Placement.class).param("tab", tabValue);
                }
            }
            if (sdkMap.get("parameterGroup") != null) {
                String parameterGroupValue = String.valueOf(sdkMap.get("parameterGroup"));
                System.out.println(">> Found parameterGroup: " + parameterGroupValue);
                field.annotate(ParameterGroup.class).param("name", parameterGroupValue);
            }
        }
    }
}

