/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.idp.internal.operation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.validation.constraints.NotNull;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.text.PDFTextStripper;
import org.mule.extension.idp.internal.connection.IDPAuthentication;
import org.mule.extension.idp.internal.connection.IDPConnection;
import org.mule.extension.idp.internal.error.IDPErrorProvider;
import org.mule.extension.idp.internal.metadata.IDPUtilsInputAnyJsonResolver;
import org.mule.extension.idp.internal.metadata.IDPUtilsOutputAnyJsonResolver;
import org.mule.extension.idp.internal.operation.utils.IDPOperationsUtils;
import org.mule.extension.idp.internal.operation.utils.IDPUtilsPdfOptions;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDPUtilsPDFOperations {
    private final Logger LOGGER = LoggerFactory.getLogger(IDPUtilsPDFOperations.class);

    @DisplayName(value="Utils IDP - HTTP - Request")
    @Summary(value="Utils HTTP Request Reusing your Connectivity<ul><li> Problem:; New resources available but connector not updatedso you have to use HTTP Request and redo Connectivity and maintain in two places<li> Solution: Use this!</ul>")
    @MediaType(value="application/json", strict=false)
    @Throws(value={IDPErrorProvider.class})
    @OutputResolver(output=IDPUtilsOutputAnyJsonResolver.class)
    public void utilsHttpRequest(@Connection IDPConnection connection, @NotNull @DisplayName(value="HTTP Method") @Example(value="POST") @Summary(value="Compose your http call by choosing what method to use") HttpConstants.Method httpMethods, @NotNull @DisplayName(value="Full URL") @Example(value="https://anypoint.mulesoft.com/idp/api/v1/organizations/01f79c97-9a83-4194-b922-15b64fd7305e/actions?page=0&size=20&sort=updatedAt%2Cdesc") @Summary(value="Compose your http call by providing the full url") String url, @Optional(defaultValue="#[payload]") @DisplayName(value="JSON Payload") @Expression(value=ExpressionSupport.REQUIRED) @TypeResolver(value=IDPUtilsInputAnyJsonResolver.class) TypedValue<InputStream> jsonContents, CompletionCallback<InputStream, Void> completionCallback) throws ModuleException {
        HashMap<String, String> uriParameters = new HashMap<String, String>();
        String uri = IDPOperationsUtils.createEndpoint(url, uriParameters);
        connection.sendRequestNonBlocking(requestBuilder -> {
            requestBuilder.addHeader("Content-Type", "application/json");
            if (httpMethods != HttpConstants.Method.GET) {
                requestBuilder.entity((HttpEntity)new InputStreamHttpEntity((InputStream)jsonContents.getValue()));
            }
        }, uri, httpMethods, IDPAuthentication.BASIC_AUTH, "").whenCompleteAsync((BiConsumer)IDPOperationsUtils.createCompletionHandler(completionCallback, uri));
    }

    @DisplayName(value="Utils IDP - PDF - ExtractText")
    @MediaType(value="text/plain")
    @Throws(value={IDPErrorProvider.class})
    public String utilsPdfExtractText(@DisplayName(value="PDF Pages to Include") @Example(value="1,2,4,6,12") @Optional @Summary(value="Comma separated list of pages to be included as new PDF") String pdfCsvPages, @Content TypedValue<InputStream> pdfFile) throws IOException, NumberFormatException, IllegalArgumentException {
        this.LOGGER.info("Starting PDF text extraction...");
        StringBuilder extractedText = new StringBuilder();
        try {
            int bytesRead;
            InputStream inputStream = (InputStream)pdfFile.getValue();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            this.LOGGER.debug("Reading InputStream into byte array...");
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            byte[] pdfBytes = byteArrayOutputStream.toByteArray();
            this.LOGGER.info("Finished reading InputStream. PDF size: " + pdfBytes.length + " bytes");
            try (PDDocument document = Loader.loadPDF((byte[])pdfBytes);){
                this.LOGGER.info("PDF loaded successfully.");
                PDFTextStripper textStripper = new PDFTextStripper();
                if (pdfCsvPages != null && !pdfCsvPages.isEmpty()) {
                    String[] pageNumbers;
                    for (String pageNumStr : pageNumbers = pdfCsvPages.split(",")) {
                        int pageNum = Integer.parseInt(pageNumStr.trim());
                        if (pageNum <= 0 || pageNum > document.getNumberOfPages()) {
                            throw new IllegalArgumentException("Invalid page number: " + pageNum);
                        }
                        textStripper.setStartPage(pageNum);
                        textStripper.setEndPage(pageNum);
                        extractedText.append(textStripper.getText(document));
                    }
                } else {
                    extractedText.append(textStripper.getText(document));
                }
                this.LOGGER.info("Extracted PDF Text:");
                this.LOGGER.debug(extractedText.toString());
            }
        }
        catch (NumberFormatException e) {
            this.LOGGER.error("Invalid page number format: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentException e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        this.LOGGER.info("PDF text extraction completed successfully.");
        return extractedText.toString();
    }

    /*
     * Exception decompiling
     */
    @DisplayName(value="Utils IDP - PDF - RemovePages")
    @MediaType(value="application/octet-stream")
    @Throws(value={IDPErrorProvider.class})
    public Result<InputStream, Map<String, Object>> utilsPdfRemovePages(@ParameterGroup(name="Remove Options [Only one choice allowed]") IDPUtilsPdfOptions pdfOptions, @Content TypedValue<InputStream> pdfFile) throws IOException, IllegalArgumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, Object> createAttributes(int originalPageCount, int pagesRemoved) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("originalPageCount", originalPageCount);
        attributes.put("pagesRemoved", pagesRemoved);
        return attributes;
    }

    private static boolean isPageBlank(PDPage page, PDDocument document) throws IOException {
        PDFTextStripper textStripper = new PDFTextStripper();
        int pageIndex = document.getPages().indexOf(page) + 1;
        textStripper.setStartPage(pageIndex);
        textStripper.setEndPage(pageIndex);
        String pageText = textStripper.getText(document);
        if (pageText != null && !pageText.trim().isEmpty()) {
            return false;
        }
        if (page.getResources() != null && page.getResources().getXObjectNames() != null && page.getResources().getXObjectNames().iterator().hasNext()) {
            return false;
        }
        return page.getAnnotations() == null || page.getAnnotations().isEmpty();
    }
}

