/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.idp.internal.operation.utils;

import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class IDPSubmitDocOptions {
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Filename [File Extension Required]")
    @Example(value="myFileName.pdf")
    @Summary(value="Filename must have the file extension")
    private String fileName;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Callback URL")
    @Example(value="https://my-cloudhub.io/api/v1/idp/callback?context=myCaseId&apikey=MzDUdfsfg")
    @Summary(value="Optional - You can define a callback URL when you call IDP to execute your document actions. If defined, IDP calls the callback URL when the document action execution finishes with states https://docs.mulesoft.com/idp/automate-document-processing-with-the-idp-api#callback-url")
    @Optional
    private String callbackUrl;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Override Salesforce Org ID")
    @Example(value="18-char-sfdc-org-id")
    @Summary(value="Optional - If you have multiple Salesforce Orgs connected with your Anypoint Platform organization, you can specify the Org to use when executing your document actions. https://docs.mulesoft.com/idp/automate-document-processing-with-the-idp-api#use-a-different-salesforce-org-to-execute-your-document-actions")
    @Optional
    private String headerXSfdcCoreTenantId;

    public IDPSubmitDocOptions() {
    }

    public IDPSubmitDocOptions(String fileName, String callbackUrl, String headerXSfdcCoreTenantId) {
        this.fileName = fileName;
        this.callbackUrl = callbackUrl;
        this.headerXSfdcCoreTenantId = headerXSfdcCoreTenantId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getHeaderXSfdcCoreTenantId() {
        return this.headerXSfdcCoreTenantId;
    }
}

