/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.idp.internal.connection.provider;

import java.util.HashMap;
import javax.inject.Inject;
import org.mule.extension.idp.internal.config.IDPProxyConfiguration;
import org.mule.extension.idp.internal.connection.IDPAuthentication;
import org.mule.extension.idp.internal.connection.IDPConnection;
import org.mule.extension.idp.internal.connection.provider.IDPAnypointAccountDetails;
import org.mule.extension.idp.internal.connection.provider.IDPServiceDetails;
import org.mule.extension.idp.internal.error.IDPError;
import org.mule.extension.idp.internal.error.IDPHttpException;
import org.mule.extension.idp.internal.operation.utils.IDPOperationsUtils;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsState;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.sdk.api.annotation.Alias;

@Alias(value="connection")
@ClientCredentials(tokenUrl="https://anypoint.mulesoft.com/accounts/api/v2/oauth2/token")
public class IDPConnectionProvider
implements CachedConnectionProvider<IDPConnection>,
Initialisable,
Startable,
Stoppable {
    @ParameterGroup(name="MuleSoft Intelligent Document Processing Service")
    IDPServiceDetails serviceEndpoint;
    @ParameterGroup(name="MuleSoft Anypoint Platform Account for Config Introspection and Platform API")
    IDPAnypointAccountDetails accountLoginDetails;
    @Parameter
    @Placement(tab="TLS")
    @DisplayName(value="TLS")
    @Optional
    private TlsContextFactory tlsContextFactory;
    @Parameter
    @Placement(tab="Proxy")
    @DisplayName(value="Proxy")
    @Optional
    private IDPProxyConfiguration proxyConfiguration;
    @Inject
    protected HttpService httpService;
    protected HttpClient httpClient;
    @RefName
    protected String configName;
    private ClientCredentialsState state;

    private TlsContextFactory getTlsContextFactory() {
        return this.tlsContextFactory;
    }

    private IDPProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public void initialise() throws InitialisationException {
        if (this.getTlsContextFactory() != null) {
            ((Initialisable)this.getTlsContextFactory()).initialise();
        }
    }

    public void start() throws MuleException {
        this.httpClient = this.createHttpClient(this.httpService);
    }

    public void stop() throws MuleException {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }

    private HttpClient createHttpClient(HttpService httpService) {
        HttpClient httpClient = httpService.getClientFactory().create(new HttpClientConfiguration.Builder().setName(this.configName).setTlsContextFactory(this.getTlsContextFactory()).setProxyConfig((ProxyConfig)this.getProxyConfiguration()).build());
        httpClient.start();
        return httpClient;
    }

    public IDPConnection connect() throws ConnectionException {
        HttpAuthentication httpAuthentication = HttpAuthentication.basic((String)this.accountLoginDetails.getUsername(), (String)this.accountLoginDetails.getPassword()).build();
        return new IDPConnection.Builder().setServiceBaseUrl(this.serviceEndpoint.serviceBaseUrl).setOrganisationId(this.serviceEndpoint.organisationId).setPlatformBaseUrl(this.accountLoginDetails.getPlatformBaseUrl()).setHttpAuthentication(httpAuthentication).setClientCredentialsState(this.state).setHttpClient(this.httpClient).build();
    }

    public void disconnect(IDPConnection connection) {
        connection.invalidate();
    }

    public ConnectionValidationResult validate(IDPConnection connection) {
        HashMap<String, String> uriParameters = new HashMap<String, String>();
        uriParameters.put("organizationId", connection.getOrganisationId());
        String uri = connection.getPlatformBaseUrl() + IDPOperationsUtils.createEndpoint("/idp/api/v1/organizations/{organizationId}/actions", uriParameters);
        try {
            HttpResponse httpResponse = connection.sendRequestBlocking(requestBuilder -> {}, uri, HttpConstants.Method.GET, IDPAuthentication.BASIC_AUTH, "");
            int statusCode = httpResponse.getStatusCode();
            String reason = httpResponse.getReasonPhrase();
            if (statusCode >= 400) {
                return ConnectionValidationResult.failure((String)"could not list actions!", (Exception)((Object)new IDPHttpException("Status code: " + statusCode + " " + reason, IDPError.CONNECTIVITY)));
            }
            return ConnectionValidationResult.success();
        }
        catch (Throwable e) {
            return ConnectionValidationResult.failure((String)"could not list actions", (Exception)((Object)new IDPHttpException(e.getMessage(), IDPError.CONNECTIVITY)));
        }
    }
}

