/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.idp.internal.operation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiConsumer;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;
import org.mule.extension.idp.internal.connection.IDPAuthentication;
import org.mule.extension.idp.internal.connection.IDPConnection;
import org.mule.extension.idp.internal.error.IDPErrorProvider;
import org.mule.extension.idp.internal.metadata.IDPServiceExecutionResultRetrieveOutputResolver;
import org.mule.extension.idp.internal.metadata.IDPServiceExecutionSubmitOutputResolver;
import org.mule.extension.idp.internal.metadata.IDPServiceReviewTaskGetOutputResolver;
import org.mule.extension.idp.internal.metadata.IDPServiceReviewTaskUpdateInputResolver;
import org.mule.extension.idp.internal.metadata.IDPServiceReviewTaskUpdateOutputResolver;
import org.mule.extension.idp.internal.metadata.IDPServiceReviewTasksListOutputResolver;
import org.mule.extension.idp.internal.operation.utils.IDPOperationsUtils;
import org.mule.extension.idp.internal.operation.utils.IDPPageableNoSort;
import org.mule.extension.idp.internal.operation.utils.IDPSubmitDocOptions;
import org.mule.extension.idp.internal.operation.valueprovider.IDPActionIdValueProvider;
import org.mule.extension.idp.internal.operation.valueprovider.IDPVersionIdValueProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDPServiceOperations {
    private final Logger LOGGER = LoggerFactory.getLogger(IDPServiceOperations.class);

    @DisplayName(value="Service IDP - Execution - Submit")
    @MediaType(value="application/json")
    @Throws(value={IDPErrorProvider.class})
    @OutputResolver(output=IDPServiceExecutionSubmitOutputResolver.class)
    public void submitExecution(@Connection IDPConnection connection, @OfValues(value=IDPActionIdValueProvider.class) String actionId, @OfValues(value=IDPVersionIdValueProvider.class) String versionSemantic, @ParameterGroup(name="Submission Options") IDPSubmitDocOptions SubmitDocOptions, @Content TypedValue<InputStream> fileContent, CompletionCallback<InputStream, Void> completionCallback) throws ModuleException {
        HashMap<String, String> uriParameters = new HashMap<String, String>();
        uriParameters.put("organizationId", connection.getOrganisationId());
        uriParameters.put("actionId", actionId);
        uriParameters.put("version", versionSemantic);
        String uri = connection.getServiceBaseUrl() + IDPOperationsUtils.createEndpoint("/api/v1/organizations/{organizationId}/actions/{actionId}/versions/{version}/executions", uriParameters);
        connection.sendRequestNonBlocking(requestBuilder -> {
            if (SubmitDocOptions.getHeaderXSfdcCoreTenantId() != null) {
                requestBuilder.addHeader("x-sfdc-core-tenant-id", SubmitDocOptions.getHeaderXSfdcCoreTenantId());
            }
            requestBuilder.addHeader("accept", "application/json");
            ArrayList<HttpPart> multiPartsFormData = new ArrayList<HttpPart>();
            String partName = "callback";
            byte[] content = new String("{\"noAuthUrl\": \"" + SubmitDocOptions.getCallbackUrl() + "\"}").getBytes();
            String contentType = "application/json";
            multiPartsFormData.add(new HttpPart(partName, content, contentType, content.length));
            partName = "file";
            String fileName = SubmitDocOptions.getFileName();
            byte[] content2 = null;
            try {
                content2 = IOUtils.toByteArray((InputStream)((InputStream)fileContent.getValue()));
            }
            catch (IOException e) {
                throw new MuleRuntimeException(e.getCause());
            }
            String contentType2 = "application/octet-stream";
            multiPartsFormData.add(new HttpPart(partName, fileName, content2, contentType2, content2.length));
            requestBuilder.entity((HttpEntity)new MultipartHttpEntity(multiPartsFormData));
        }, uri, HttpConstants.Method.POST, IDPAuthentication.OAUTH, connection.getClientCredentialsState().getAccessToken()).whenCompleteAsync((BiConsumer)IDPOperationsUtils.createCompletionHandler(completionCallback, uri));
    }

    @DisplayName(value="Service IDP - Execution Result - Retrieve")
    @MediaType(value="application/json")
    @Throws(value={IDPErrorProvider.class})
    @OutputResolver(output=IDPServiceExecutionResultRetrieveOutputResolver.class)
    public void retrieveExecutionResult(@Connection IDPConnection connection, @OfValues(value=IDPActionIdValueProvider.class) String actionId, @OfValues(value=IDPVersionIdValueProvider.class) String versionSemantic, @NotNull String executionId, @NotNull boolean valueOnly, CompletionCallback<InputStream, Void> completionCallback) throws ModuleException {
        HashMap<String, String> uriParameters = new HashMap<String, String>();
        uriParameters.put("organizationId", connection.getOrganisationId());
        uriParameters.put("actionId", actionId);
        uriParameters.put("version", versionSemantic);
        uriParameters.put("executionId", executionId);
        String uri = connection.getServiceBaseUrl() + IDPOperationsUtils.createEndpoint("/api/v1/organizations/{organizationId}/actions/{actionId}/versions/{version}/executions/{executionId}", uriParameters);
        connection.sendRequestNonBlocking(requestBuilder -> requestBuilder.addQueryParam("valueOnly", String.valueOf(valueOnly)), uri, HttpConstants.Method.GET, IDPAuthentication.OAUTH, connection.getClientCredentialsState().getAccessToken()).whenCompleteAsync((BiConsumer)IDPOperationsUtils.createCompletionHandler(completionCallback, uri));
    }

    @DisplayName(value="Service IDP - Review Tasks - List")
    @MediaType(value="application/json")
    @Throws(value={IDPErrorProvider.class})
    @OutputResolver(output=IDPServiceReviewTasksListOutputResolver.class)
    public void listReviewTasks(@Connection IDPConnection connection, @ParameterGroup(name="Pageable [optional]") IDPPageableNoSort pageable, CompletionCallback<InputStream, Void> completionCallback) throws ModuleException {
        HashMap<String, String> uriParameters = new HashMap<String, String>();
        uriParameters.put("organizationId", connection.getOrganisationId());
        String uri = connection.getServiceBaseUrl() + IDPOperationsUtils.createEndpoint("/api/v1/organizations/{organizationId}/reviews", uriParameters);
        connection.sendRequestNonBlocking(requestBuilder -> {
            if (pageable.getPage() > 0) {
                requestBuilder.addQueryParam("page", String.valueOf(pageable.getPage()));
            }
            if (pageable.getSize() > 0) {
                requestBuilder.addQueryParam("size", String.valueOf(pageable.getSize()));
            }
        }, uri, HttpConstants.Method.GET, IDPAuthentication.BASIC_AUTH, "").whenCompleteAsync((BiConsumer)IDPOperationsUtils.createCompletionHandler(completionCallback, uri));
    }

    @DisplayName(value="Service IDP - Review Task - Retrieve")
    @MediaType(value="application/json")
    @Throws(value={IDPErrorProvider.class})
    @OutputResolver(output=IDPServiceReviewTaskGetOutputResolver.class)
    public void retrieveReviewTask(@Connection IDPConnection connection, @OfValues(value=IDPActionIdValueProvider.class) String actionId, @NotNull String executionId, CompletionCallback<InputStream, Void> completionCallback) throws ModuleException {
        HashMap<String, String> uriParameters = new HashMap<String, String>();
        uriParameters.put("organizationId", connection.getOrganisationId());
        uriParameters.put("actionId", actionId);
        uriParameters.put("executionId", executionId);
        String uri = connection.getServiceBaseUrl() + IDPOperationsUtils.createEndpoint("/api/v1/organizations/{organizationId}/actions/{actionId}/reviews/{executionId}", uriParameters);
        connection.sendRequestNonBlocking(requestBuilder -> {}, uri, HttpConstants.Method.GET, IDPAuthentication.BASIC_AUTH, "").whenCompleteAsync((BiConsumer)IDPOperationsUtils.createCompletionHandler(completionCallback, uri));
    }

    @DisplayName(value="Service IDP - Review Task - Delete")
    @MediaType(value="application/json")
    @Throws(value={IDPErrorProvider.class})
    public void deleteReviewTask(@Connection IDPConnection connection, @OfValues(value=IDPActionIdValueProvider.class) String actionId, @NotNull String executionId, CompletionCallback<InputStream, Void> completionCallback) throws ModuleException {
        HashMap<String, String> uriParameters = new HashMap<String, String>();
        uriParameters.put("organizationId", connection.getOrganisationId());
        uriParameters.put("actionId", actionId);
        uriParameters.put("executionId", executionId);
        String uri = connection.getServiceBaseUrl() + IDPOperationsUtils.createEndpoint("/api/v1/organizations/{organizationId}/actions/{actionId}/reviews/{executionId}", uriParameters);
        connection.sendRequestNonBlocking(requestBuilder -> {}, uri, HttpConstants.Method.DELETE, IDPAuthentication.BASIC_AUTH, "").whenCompleteAsync((BiConsumer)IDPOperationsUtils.createCompletionHandler(completionCallback, uri));
    }

    @DisplayName(value="Service IDP - Review Task - Update")
    @MediaType(value="application/json")
    @Throws(value={IDPErrorProvider.class})
    @OutputResolver(output=IDPServiceReviewTaskUpdateOutputResolver.class)
    public void updateReviewTask(@Connection IDPConnection connection, @OfValues(value=IDPActionIdValueProvider.class) String actionId, @NotNull String executionId, @Expression(value=ExpressionSupport.REQUIRED) @Optional(defaultValue="#[payload]") @TypeResolver(value=IDPServiceReviewTaskUpdateInputResolver.class) TypedValue<InputStream> contents, CompletionCallback<InputStream, Void> completionCallback) throws ModuleException {
        HashMap<String, String> uriParameters = new HashMap<String, String>();
        uriParameters.put("organizationId", connection.getOrganisationId());
        uriParameters.put("actionId", executionId);
        uriParameters.put("executionId", executionId);
        String uri = connection.getServiceBaseUrl() + IDPOperationsUtils.createEndpoint("/api/v1/organizations/{organizationId}/actions/{actionId}/reviews/{executionId}", uriParameters);
        connection.sendRequestNonBlocking(requestBuilder -> {
            requestBuilder.addHeader("Content-Type", "application/json");
            requestBuilder.entity((HttpEntity)new InputStreamHttpEntity((InputStream)contents.getValue()));
        }, uri, HttpConstants.Method.PATCH, IDPAuthentication.BASIC_AUTH, "").whenCompleteAsync((BiConsumer)IDPOperationsUtils.createCompletionHandler(completionCallback, uri));
    }
}

