/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.idp.internal.config;

import java.util.Objects;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;

public class IDPProxyConfiguration
implements ProxyConfig {
    @Parameter
    @Optional
    @Summary(value="The host name of the HTTP proxy which also requires the port number to be set.")
    @DisplayName(value="Host")
    @Placement(tab="Proxy", order=1)
    private String host;
    @Parameter
    @Optional
    @Summary(value="The port number of the HTTP proxy which also requires the host name to be set.")
    @DisplayName(value="Port")
    @Placement(tab="Proxy", order=2)
    private int port;
    @Parameter
    @Optional
    @Summary(value="User name is optional for HTTP proxies without authentication.")
    @DisplayName(value="Username")
    @Placement(tab="Proxy", order=3)
    private String username;
    @Parameter
    @Optional
    @Summary(value="Password is optional for HTTP proxies without authentication.")
    @DisplayName(value="Password")
    @Password
    @Placement(tab="Proxy", order=4)
    private String password;
    @Parameter
    @Optional
    @DisplayName(value="Non proxied hosts")
    @Placement(tab="Proxy", order=5)
    @Summary(value="A list of comma separated hosts against which the proxy should not be used")
    private String nonProxyHosts;

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IDPProxyConfiguration)) {
            return false;
        }
        IDPProxyConfiguration that = (IDPProxyConfiguration)o;
        return this.port == that.port && Objects.equals(this.host, that.host) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.nonProxyHosts, that.nonProxyHosts);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.username, this.password, this.nonProxyHosts);
    }
}

