/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.idp.internal.connection;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.extension.idp.internal.connection.IDPAuthentication;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsState;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class IDPConnection {
    private final HttpClient httpClient;
    private final String serviceBaseUrl;
    private final String organisationId;
    private final String platformBaseUrl;
    private final HttpAuthentication httpAuthentication;
    private ClientCredentialsState state;

    public IDPConnection(Builder builder) {
        this.httpClient = builder.httpClient;
        this.serviceBaseUrl = builder.serviceBaseUrl;
        this.organisationId = builder.organisationId;
        this.platformBaseUrl = builder.platformBaseUrl;
        this.httpAuthentication = builder.httpAuthentication;
        this.state = builder.state;
    }

    public String getServiceBaseUrl() {
        return this.serviceBaseUrl;
    }

    public String getOrganisationId() {
        return this.organisationId;
    }

    public String getPlatformBaseUrl() {
        return this.platformBaseUrl;
    }

    public HttpAuthentication getHttpAuthentication() {
        return this.httpAuthentication;
    }

    public ClientCredentialsState getClientCredentialsState() {
        return this.state;
    }

    public CompletableFuture<HttpResponse> sendRequestNonBlocking(Consumer<HttpRequestBuilder> httpRequestBuilderConsumer, String uri, HttpConstants.Method method, IDPAuthentication authentication, String accessTokenIfAuthenticationIsOAuth) {
        HttpRequestBuilder builder = HttpRequest.builder();
        if (httpRequestBuilderConsumer != null) {
            httpRequestBuilderConsumer.accept(builder);
        }
        HttpRequest request = null;
        HttpRequestOptions options = null;
        if (authentication == IDPAuthentication.BASIC_AUTH) {
            options = HttpRequestOptions.builder().authentication(this.httpAuthentication).build();
            request = builder.method(method).uri(uri).build();
            return this.httpClient.sendAsync(request, options);
        }
        if (authentication == IDPAuthentication.OAUTH) {
            request = ((HttpRequestBuilder)builder.method(method).uri(uri).addHeader("Authorization", "Bearer " + accessTokenIfAuthenticationIsOAuth)).build();
            return this.httpClient.sendAsync(request);
        }
        request = builder.method(method).uri(uri).build();
        return this.httpClient.sendAsync(request);
    }

    public HttpResponse sendRequestBlocking(Consumer<HttpRequestBuilder> httpRequestBuilderConsumer, String uri, HttpConstants.Method method, IDPAuthentication authentication, String accessTokenIfAuthenticationIsOAuth) throws Throwable {
        HttpRequestBuilder builder = HttpRequest.builder();
        if (httpRequestBuilderConsumer != null) {
            httpRequestBuilderConsumer.accept(builder);
        }
        HttpRequest request = null;
        HttpRequestOptions options = null;
        if (authentication == IDPAuthentication.BASIC_AUTH) {
            options = HttpRequestOptions.builder().authentication(this.httpAuthentication).build();
            request = builder.method(method).uri(uri).build();
            return this.httpClient.send(request, options);
        }
        if (authentication == IDPAuthentication.OAUTH) {
            request = ((HttpRequestBuilder)builder.method(method).uri(uri).addHeader("Authorization", "Bearer " + accessTokenIfAuthenticationIsOAuth)).build();
            return this.httpClient.send(request);
        }
        request = builder.method(method).uri(uri).build();
        return this.httpClient.send(request);
    }

    public void invalidate() {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }

    public static class Builder {
        private HttpClient httpClient;
        private String serviceBaseUrl;
        private String organisationId;
        private String platformBaseUrl;
        private HttpAuthentication httpAuthentication;
        private ClientCredentialsState state;

        public Builder setHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder setServiceBaseUrl(String serviceBaseUrl) {
            this.serviceBaseUrl = serviceBaseUrl;
            return this;
        }

        public Builder setOrganisationId(String organisationId) {
            this.organisationId = organisationId;
            return this;
        }

        public Builder setPlatformBaseUrl(String platformBaseUrl) {
            this.platformBaseUrl = platformBaseUrl;
            return this;
        }

        public Builder setHttpAuthentication(HttpAuthentication httpAuthentication) {
            this.httpAuthentication = httpAuthentication;
            return this;
        }

        public Builder setClientCredentialsState(ClientCredentialsState state) {
            this.state = state;
            return this;
        }

        public IDPConnection build() {
            return new IDPConnection(this);
        }
    }
}

