/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.idp.internal.operation.utils;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.Map;
import java.util.function.BiConsumer;
import org.mule.extension.idp.internal.error.IDPError;
import org.mule.extension.idp.internal.error.IDPHttpException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class IDPOperationsUtils {
    public static BiConsumer<HttpResponse, Throwable> createCompletionHandler(CompletionCallback<InputStream, Void> completionCallback, String uri) {
        return (httpResponse, throwable) -> {
            if (throwable != null) {
                completionCallback.error((Throwable)new RuntimeException("Unexpected Error Occurred", (Throwable)throwable));
            } else {
                int statusCode = httpResponse.getStatusCode();
                String reason = httpResponse.getReasonPhrase();
                if (statusCode >= 400) {
                    completionCallback.error((Throwable)((Object)new IDPHttpException(IDPOperationsUtils.createHttpResponseMessage("IDP Error Occured", reason, statusCode, uri), IDPError.CONNECTIVITY)));
                } else {
                    completionCallback.success(Result.builder().output((Object)httpResponse.getEntity().getContent()).mediaType(MediaType.APPLICATION_JSON).build());
                }
            }
        };
    }

    private static String createHttpResponseMessage(String message, String reason, int statusCode, String uri) {
        JsonObject jsonObjects = new JsonObject();
        jsonObjects.addProperty("message", message);
        jsonObjects.addProperty("reason", reason);
        jsonObjects.addProperty("code", (Number)statusCode);
        jsonObjects.addProperty("resource", uri);
        String jsonMessage = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObjects);
        return jsonMessage;
    }

    public static String createEndpoint(String endpointTemplate, Map<String, String> uriParameters) {
        String endpoint = endpointTemplate;
        for (String uriParameter : uriParameters.keySet()) {
            endpoint = endpoint.replace("{" + uriParameter + "}", uriParameters.get(uriParameter));
        }
        return endpoint;
    }
}

