/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.idp.internal.operation.valueprovider;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import org.mule.extension.idp.api.IDPSortOption;
import org.mule.extension.idp.internal.connection.IDPConnection;
import org.mule.extension.idp.internal.operation.IDPPlatformOperations;
import org.mule.extension.idp.internal.operation.utils.IDPPageable;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;

public class IDPActionIdValueProvider
implements ValueProvider {
    private static final String EXPRESSION = "%dw 2.0\noutput application/java\n---\npayload.actions map { ($.id) : $.name } reduce ($$ ++ $) ";
    @Connection
    private IDPConnection connection;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ExpressionManager expressionManager;

    public Set<Value> resolve() throws ValueResolvingException {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Reference valuesReference = new Reference(new HashSet());
        Reference throwableReference = new Reference();
        try {
            new IDPPlatformOperations().listActions(this.connection, new IDPPageable(0, 1999999999, IDPSortOption.UPDATED_AT_DESC), this.createCallbackHandler(countDownLatch, (Reference<Set<Value>>)valuesReference, (Reference<Throwable>)throwableReference, EXPRESSION));
        }
        catch (ModuleException e) {
            throw new RuntimeException(e);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new ValueResolvingException("Unexpected Error", "UNKNOWN", (Throwable)e);
        }
        if (throwableReference.get() != null) {
            throw new ValueResolvingException("Unexpected Error", "UNKNOWN", (Throwable)throwableReference.get());
        }
        return (Set)valuesReference.get();
    }

    public String getId() {
        return super.getId();
    }

    private CompletionCallback<InputStream, Void> createCallbackHandler(final CountDownLatch countDownLatch, final Reference<Set<Value>> values, final Reference<Throwable> throwableReference, final String expression) {
        return new CompletionCallback<InputStream, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void success(Result<InputStream, Void> result) {
                CountDownLatch transformationLatch = new CountDownLatch(1);
                Scheduler scheduler = IDPActionIdValueProvider.this.schedulerService.cpuLightScheduler();
                scheduler.execute(() -> {
                    try {
                        TypedValue payload = IDPActionIdValueProvider.this.expressionManager.evaluate(expression, BindingContext.builder().addBinding("payload", IDPActionIdValueProvider.this.getTypedValue((Result<InputStream, Void>)result)).build());
                        Map value = (Map)payload.getValue();
                        values.set((Object)ValueBuilder.getValuesFor((Map)(value == null ? Collections.emptyMap() : value)));
                    }
                    finally {
                        transformationLatch.countDown();
                    }
                });
                try {
                    transformationLatch.await();
                }
                catch (InterruptedException e) {
                    throwableReference.set((Object)e);
                }
                finally {
                    scheduler.stop();
                    scheduler = null;
                    countDownLatch.countDown();
                }
            }

            public void error(Throwable throwable) {
                throwableReference.set((Object)throwable);
                countDownLatch.countDown();
            }
        };
    }

    private TypedValue getTypedValue(Result<InputStream, Void> result) {
        InputStream output = (InputStream)result.getOutput();
        String s = IOUtils.toString((InputStream)output);
        return new TypedValue((Object)s, DataType.builder().type(InputStream.class).mediaType((MediaType)result.getMediaType().get()).build());
    }
}

