/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.pdfBox.internal.operation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.multipdf.Splitter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.text.PDFTextStripper;
import org.jetbrains.annotations.NotNull;
import org.mule.extension.pdfBox.api.PdfBoxFileAttributes;
import org.mule.extension.pdfBox.internal.error.PdfBoxErrorTypeProvider;
import org.mule.extension.pdfBox.internal.error.PdfBoxErrors;
import org.mule.extension.pdfBox.internal.metadata.PdfBoxBinaryMetadataResolver;
import org.mule.extension.pdfBox.internal.operation.parts.PdfBoxPageRotation;
import org.mule.extension.pdfBox.internal.operation.parts.PdfBoxPdfOptions;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfBoxOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfBoxOperations.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MediaType(value="application/octet-stream")
    @DisplayName(value="Apache PDFBox - Get Info")
    @Summary(value="Extracts the number of pages and file size from a PDF document.")
    @Throws(value={PdfBoxErrorTypeProvider.class})
    public Result<InputStream, PdfBoxFileAttributes> getPdfInfo(@DisplayName(value="PDF File [Binary]") @Content @TypeResolver(value=PdfBoxBinaryMetadataResolver.class) @NotNull InputStream pdfFile, StreamingHelper streamingHelper) throws IOException {
        byte[] pdfBytes = PdfBoxOperations.toByteArray(pdfFile);
        long pdfSize = pdfBytes.length;
        try (PDDocument pdfDoc = Loader.loadPDF((byte[])pdfBytes);){
            PdfBoxFileAttributes attributes = this.extractPdfMetadata(pdfDoc, pdfSize);
            LOGGER.info("Extracted PDF Info - Pages: {}, Size: {}, Title: {}, Author: {}", new Object[]{pdfDoc.getNumberOfPages(), pdfSize, attributes.getTitle(), attributes.getAuthor()});
            Result result = Result.builder().output((Object)new ByteArrayInputStream(pdfBytes)).mediaType(org.mule.runtime.api.metadata.MediaType.parse((String)"application/octet-stream")).attributes((Object)attributes).build();
            return result;
        }
        catch (IOException e) {
            throw new ModuleException("Failed to load PDF document. It may be corrupt or invalid.", (ErrorTypeDefinition)PdfBoxErrors.PDF_LOAD_FAILED, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MediaType(value="text/plain")
    @DisplayName(value="Apache PDFBox - Extract Text")
    @Summary(value="Extracts text from specific pages/ranges in a PDF, e.g., 2,4,9-11.")
    @Throws(value={PdfBoxErrorTypeProvider.class})
    public Result<String, PdfBoxFileAttributes> extractTextWithPageRange(@DisplayName(value="PDF File [Binary]") @Content @TypeResolver(value=PdfBoxBinaryMetadataResolver.class) @NotNull InputStream pdfFile, @DisplayName(value="Page Range") @Summary(value="Comma-separated list of pages or ranges (e.g., 2,4,5,9-12,15).") @Example(value="1,2,4,6-12") @Optional String pageRange, StreamingHelper streamingHelper) throws IOException {
        byte[] pdfBytes = PdfBoxOperations.toByteArray(pdfFile);
        long pdfSize = pdfBytes.length;
        try (PDDocument pdfDoc = Loader.loadPDF((byte[])pdfBytes);){
            int totalPages = pdfDoc.getNumberOfPages();
            Set<Integer> pageSet = this.parsePageRange(pageRange, totalPages);
            PDFTextStripper stripper = new PDFTextStripper();
            StringBuilder combinedText = new StringBuilder();
            for (Integer page : pageSet) {
                stripper.setStartPage(page.intValue());
                stripper.setEndPage(page.intValue());
                try {
                    combinedText.append(stripper.getText(pdfDoc)).append("\n");
                }
                catch (IOException e) {
                    throw new ModuleException("Error extracting text from page " + page, (ErrorTypeDefinition)PdfBoxErrors.PDF_TEXT_EXTRACTION_FAILED, (Throwable)e);
                }
            }
            PdfBoxFileAttributes attributes = this.extractPdfMetadata(pdfDoc, pdfSize);
            LOGGER.info("Extracted text from pages: {}", pageSet);
            Result result = Result.builder().output((Object)combinedText.toString()).mediaType(org.mule.runtime.api.metadata.MediaType.TEXT).attributes((Object)attributes).build();
            return result;
        }
        catch (IOException e) {
            throw new ModuleException("Failed to load PDF document. It may be corrupt or invalid.", (ErrorTypeDefinition)PdfBoxErrors.PDF_LOAD_FAILED, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    @MediaType(value="application/octet-stream")
    @Throws(value={PdfBoxErrorTypeProvider.class})
    @DisplayName(value="Apache PDFBox - Filter Pages")
    @Summary(value="Removes blank pages and/or keeps only selected page ranges. Returns a filtered PDF.")
    public Result<InputStream, PdfBoxFileAttributes> filterPages(@DisplayName(value="PDF File [Binary]") @Content @TypeResolver(value=PdfBoxBinaryMetadataResolver.class) @NotNull InputStream pdfFile, @ParameterGroup(name="Filter Options [Only one choice allowed]") PdfBoxPdfOptions options, StreamingHelper streamingHelper) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MediaType(value="application/octet-stream")
    @DisplayName(value="Apache PDFBox - Rotate Pages")
    @Summary(value="Rotates specific pages in a PDF document based on the provided page range and rotation angle.")
    @Throws(value={PdfBoxErrorTypeProvider.class})
    public Result<InputStream, PdfBoxFileAttributes> rotatePdfPages(@DisplayName(value="PDF File [Binary]") @Content @TypeResolver(value=PdfBoxBinaryMetadataResolver.class) @NotNull InputStream pdfFile, @DisplayName(value="Page Range") @Summary(value="Comma-separated list of pages or ranges (e.g., 2,4,5,9-12,15).") @Example(value="1,2,4,6-12") @Optional String pageRange, @DisplayName(value="Rotation Angle") @Expression(value=ExpressionSupport.NOT_SUPPORTED) @Summary(value="The rotation angle in degrees (e.g., 90, 180, 270).") PdfBoxPageRotation rotationAngle, StreamingHelper streamingHelper) throws IOException {
        byte[] pdfBytes = PdfBoxOperations.toByteArray(pdfFile);
        long pdfSize = pdfBytes.length;
        try (PDDocument pdfDoc = Loader.loadPDF((byte[])pdfBytes);){
            int totalPages = pdfDoc.getNumberOfPages();
            Set<Integer> pageSet = this.parsePageRange(pageRange, totalPages);
            for (Integer pageNumber : pageSet) {
                if (pageNumber < 1 || pageNumber > totalPages) continue;
                PDPage page = pdfDoc.getPage(pageNumber - 1);
                page.setRotation(rotationAngle.getValue());
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            pdfDoc.save((OutputStream)outputStream);
            PdfBoxFileAttributes attributes = new PdfBoxFileAttributes();
            attributes.setNumberOfPages(pdfDoc.getNumberOfPages());
            attributes.setPdfSize(outputStream.size());
            Result result = Result.builder().output((Object)new ByteArrayInputStream(outputStream.toByteArray())).mediaType(org.mule.runtime.api.metadata.MediaType.parse((String)"application/octet-stream")).attributes((Object)attributes).build();
            return result;
        }
        catch (IOException e) {
            throw new ModuleException("Failed to load or process PDF document.", (ErrorTypeDefinition)PdfBoxErrors.PDF_LOAD_FAILED, (Throwable)e);
        }
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = input.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    private Set<Integer> parsePageRange(String pageRange, int totalPages) {
        TreeSet<Integer> pages = new TreeSet<Integer>();
        if (pageRange == null || pageRange.trim().isEmpty()) {
            for (int i = 1; i <= totalPages; ++i) {
                pages.add(i);
            }
            return pages;
        }
        String sanitized = pageRange.replaceAll("\\s", "");
        String[] segments = sanitized.split(",");
        Pattern pattern = Pattern.compile("(\\d+)(?:-(\\d+))?");
        for (String segment : segments) {
            int end;
            Matcher matcher = pattern.matcher(segment);
            if (!matcher.matches()) {
                throw new ModuleException("Invalid page range segment: \"" + segment + "\". Expected format like 2,4,9-12.", (ErrorTypeDefinition)PdfBoxErrors.PDF_INVALID_PAGE_RANGE);
            }
            int start = Integer.parseInt(matcher.group(1));
            int n = end = matcher.group(2) != null ? Integer.parseInt(matcher.group(2)) : start;
            if (start > end) {
                throw new ModuleException("Invalid page range: \"" + segment + "\". Start page must not be greater than end page.", (ErrorTypeDefinition)PdfBoxErrors.PDF_INVALID_PAGE_RANGE);
            }
            for (int i = start; i <= end; ++i) {
                if (i < 1 || i > totalPages) continue;
                pages.add(i);
            }
        }
        return pages;
    }

    private boolean isPageBlank(PDDocument doc, PDPage page) throws IOException {
        int pageIndex = doc.getPages().indexOf(page) + 1;
        PDFTextStripper stripper = new PDFTextStripper();
        stripper.setStartPage(pageIndex);
        stripper.setEndPage(pageIndex);
        String text = stripper.getText(doc);
        if (!text.trim().isEmpty()) {
            return false;
        }
        PDResources resources = page.getResources();
        if (resources != null) {
            try {
                Iterator iterator;
                Iterable xObjectNames = resources.getXObjectNames();
                if (xObjectNames != null && (iterator = xObjectNames.iterator()).hasNext()) {
                    COSName cosName = (COSName)iterator.next();
                    return false;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error accessing XObject names on page {}: {}", (Object)pageIndex, (Object)e.getMessage());
            }
        }
        if (page.getAnnotations() != null && !page.getAnnotations().isEmpty()) {
            return false;
        }
        if (doc.getDocumentCatalog().getAcroForm() != null && doc.getDocumentCatalog().getAcroForm().getFields() != null && !doc.getDocumentCatalog().getAcroForm().getFields().isEmpty()) {
            for (PDField field : doc.getDocumentCatalog().getAcroForm().getFields()) {
                if (field.getWidgets() == null) continue;
                for (PDAnnotationWidget widget : field.getWidgets()) {
                    if (widget.getPage() == null || !widget.getPage().equals((Object)page)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private PdfBoxFileAttributes extractPdfMetadata(PDDocument pdfDoc, long pdfSize) {
        PDDocumentInformation info = pdfDoc.getDocumentInformation();
        if (info == null) {
            throw new ModuleException("Unable to extract PDF metadata.", (ErrorTypeDefinition)PdfBoxErrors.PDF_METADATA_EXTRACTION_FAILED);
        }
        PdfBoxFileAttributes attributes = new PdfBoxFileAttributes();
        attributes.setNumberOfPages(pdfDoc.getNumberOfPages());
        attributes.setPdfSize(pdfSize);
        attributes.setTitle(info.getTitle());
        attributes.setAuthor(info.getAuthor());
        attributes.setSubject(info.getSubject());
        attributes.setKeywords(info.getKeywords());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (info.getCreationDate() != null) {
            attributes.setCreationDate(sdf.format(info.getCreationDate().getTime()));
        }
        if (info.getModificationDate() != null) {
            attributes.setModificationDate(sdf.format(info.getModificationDate().getTime()));
        }
        return attributes;
    }

    @DisplayName(value="Apache PDFBox - Split Pages")
    @Summary(value="Splits the PDF into multiple documents, each containing the specified number of pages.")
    @Throws(value={PdfBoxErrorTypeProvider.class})
    public Result<List<InputStream>, PdfBoxFileAttributes> splitPdfByIncrement(@DisplayName(value="PDF File [Binary]") @Content @TypeResolver(value=PdfBoxBinaryMetadataResolver.class) @NotNull InputStream pdfFile, @DisplayName(value="Page Increment") @Summary(value="Number of pages for each split document.") @Optional(defaultValue="1") Integer pageIncrement, StreamingHelper streamingHelper) throws IOException {
        if (pageIncrement == null || pageIncrement <= 0) {
            throw new ModuleException("Page increment must be a positive integer.", (ErrorTypeDefinition)PdfBoxErrors.PDF_PROCESSING_ERROR);
        }
        byte[] pdfBytes = PdfBoxOperations.toByteArray(pdfFile);
        long originalPdfSize = pdfBytes.length;
        ArrayList<ByteArrayInputStream> splitDocuments = new ArrayList<ByteArrayInputStream>();
        PdfBoxFileAttributes originalAttributes = null;
        PDDocument document = null;
        try {
            document = Loader.loadPDF((byte[])pdfBytes);
            originalAttributes = this.extractPdfMetadata(document, originalPdfSize);
            int totalPages = document.getNumberOfPages();
            if (totalPages == 0) {
                LOGGER.warn("Input PDF has 0 pages. Returning empty list of split documents.");
                Result result = Result.builder().output(splitDocuments).attributes((Object)originalAttributes).build();
                return result;
            }
            Splitter splitter = new Splitter();
            splitter.setSplitAtPage(pageIncrement.intValue());
            List splitPDDocs = splitter.split(document);
            ArrayList<Object> resourcesToClose = new ArrayList<Object>();
            try {
                for (PDDocument splitDoc : splitPDDocs) {
                    resourcesToClose.add(splitDoc);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    resourcesToClose.add(baos);
                    splitDoc.save((OutputStream)baos);
                    splitDocuments.add(new ByteArrayInputStream(baos.toByteArray()));
                }
            }
            catch (IOException e) {
                throw new ModuleException("Failed to save a split PDF document part.", (ErrorTypeDefinition)PdfBoxErrors.PDF_PROCESSING_ERROR, (Throwable)e);
            }
            finally {
                for (Closeable closeable : resourcesToClose) {
                    if (!(closeable instanceof PDDocument)) continue;
                    try {
                        closeable.close();
                    }
                    catch (IOException ce) {
                        LOGGER.error("Failed to close split PDDocument resource.", (Throwable)ce);
                    }
                }
            }
            LOGGER.info("Successfully split PDF into {} documents with increment {}", (Object)splitDocuments.size(), (Object)pageIncrement);
            Result result = Result.builder().output(splitDocuments).attributes((Object)originalAttributes).build();
            return result;
        }
        catch (IOException e) {
            throw new ModuleException("Failed to load or split PDF document.", (ErrorTypeDefinition)PdfBoxErrors.PDF_LOAD_FAILED, (Throwable)e);
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to close original PDF document.", (Throwable)e);
                }
            }
        }
    }
}

