/*
 * Decompiled with CFR 0.152.
 */
package io.github.mymonstercat;

import io.github.mymonstercat.Model;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarFileUtil {
    private static final Logger log = LoggerFactory.getLogger(JarFileUtil.class);
    public static final String TEMP_DIR = new File(Objects.toString(System.getProperty("java.io.tmpdir")), "ocrJava").getPath();
    static File tempDir = null;

    private JarFileUtil() {
    }

    public static synchronized void copyFileFromJar(String filePath, String aimDir, boolean load, boolean deleteOnExit) throws IOException {
        File temp;
        block21: {
            String filename;
            String[] parts = filePath.split("/");
            String string = filename = parts.length > 1 ? parts[parts.length - 1] : null;
            if (filename == null || filename.length() < 3) {
                throw new IllegalArgumentException("\u6587\u4ef6\u540d\u5fc5\u987b\u81f3\u5c11\u67093\u4e2a\u5b57\u7b26\u957f.");
            }
            if (tempDir == null && !(tempDir = new File(TEMP_DIR, aimDir)).exists() && !tempDir.mkdirs()) {
                throw new IOException("\u65e0\u6cd5\u5728\u4e34\u65f6\u76ee\u5f55\u521b\u5efa\u6587\u4ef6\u5939" + tempDir);
            }
            temp = new File(tempDir, filename.startsWith("/") ? filename : "/" + filename);
            if (!temp.exists()) {
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);){
                    if (is != null) {
                        Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        break block21;
                    }
                    throw new NullPointerException();
                }
                catch (IOException e) {
                    Files.delete(temp.toPath());
                    throw new IOException("\u65e0\u6cd5\u590d\u5236\u6587\u4ef6 " + filePath + " \u5230 " + temp.getAbsolutePath(), e);
                }
                catch (NullPointerException e) {
                    throw new FileNotFoundException("\u6587\u4ef6 " + filePath + " \u5728JAR\u4e2d\u672a\u627e\u5230.");
                }
            }
        }
        if (load) {
            System.load(temp.getAbsolutePath());
        }
        if (deleteOnExit) {
            temp.deleteOnExit();
            tempDir.deleteOnExit();
        }
        log.debug("\u5c06\u6587\u4ef6{}\u590d\u5236\u5230{}\uff0c\u52a0\u8f7d\u6b64\u6587\u4ef6\uff1a{}\uff0cJVM\u9000\u51fa\u65f6\u5220\u9664\u6b64\u6587\u4ef6\uff1a{}", new Object[]{filePath, aimDir, load, deleteOnExit});
    }

    public static void copyModelsFromJar(Model model, boolean isDelOnExit) throws IOException {
        String modelsDir = model.getModelsDir();
        String noStart = modelsDir.startsWith("/") ? modelsDir.substring(1, modelsDir.length()) : modelsDir;
        String base = noStart.endsWith("/") ? noStart : noStart + "/";
        for (String path : model.getModelFileArray()) {
            JarFileUtil.copyFileFromJar(base + path, "/" + model.getModelType(), Boolean.FALSE, isDelOnExit);
        }
    }
}

