/*
 * Decompiled with CFR 0.152.
 */
package io.github.mymonstercat.ocr;

import io.github.mymonstercat.loader.LibraryLoader;
import io.github.mymonstercat.loader.ModelsLoader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadUtil {
    private static final Logger log = LoggerFactory.getLogger(LoadUtil.class);

    private LoadUtil() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LibraryLoader findLibLoader(String engine) {
        Properties props = new Properties();
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("load/loaders.properties");){
            String loaderClassName;
            block27: {
                String osArch;
                String osName;
                block26: {
                    if (input == null) {
                        throw new FileNotFoundException("\u5728\u52a0\u8f7d\u76ee\u5f55\u4e2d\u627e\u4e0d\u5230loaders.properties");
                    }
                    props.load(input);
                    osName = System.getProperty("os.name").toLowerCase();
                    osArch = System.getProperty("os.arch").toLowerCase();
                    log.debug("osName: {}, osArch: {}", (Object)osName, (Object)osArch);
                    loaderClassName = null;
                    if (!osName.contains("win")) break block26;
                    if (osArch.contains("amd64")) {
                        loaderClassName = props.getProperty(engine + ".win-x86_64");
                        break block27;
                    } else if (osArch.contains("x86")) {
                        loaderClassName = props.getProperty(engine + ".win-x86");
                    }
                    break block27;
                }
                if (osName.contains("mac")) {
                    loaderClassName = osArch.contains("arch64") ? props.getProperty(engine + ".mac-arm64") : props.getProperty(engine + ".mac-x86_64");
                } else if (osName.contains("linux")) {
                    if (osArch.contains("x86") || osArch.contains("amd64")) {
                        loaderClassName = props.getProperty(engine + ".linux-x86_64");
                    } else if (osArch.contains("arm")) {
                        loaderClassName = props.getProperty("linuxArmLoader");
                    }
                }
            }
            if (loaderClassName == null) return null;
            LibraryLoader libraryLoader = (LibraryLoader)Class.forName(loaderClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return libraryLoader;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5e93\u6587\u4ef6\u52a0\u8f7d\u5668 {} \u5931\u8d25", (Object)e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ModelsLoader findModelsLoader(String engine) {
        Properties props = new Properties();
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("load/loaders.properties");){
            if (input == null) {
                throw new FileNotFoundException("\u5728\u52a0\u8f7d\u76ee\u5f55\u4e2d\u627e\u4e0d\u5230loaders.properties");
            }
            props.load(input);
            ModelsLoader modelsLoader = (ModelsLoader)Class.forName(props.getProperty(engine + ".model")).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return modelsLoader;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6a21\u578b\u6587\u4ef6\u52a0\u8f7d\u5668 {} \u5931\u8d25", (Object)e.getMessage());
            return null;
        }
    }
}

