/*
 * Decompiled with CFR 0.152.
 */
package com.privacylogistics;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class FF3Cipher {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final int NUM_ROUNDS = 8;
    private static final int BLOCK_SIZE = 16;
    private static final int TWEAK_LEN = 8;
    private static final int TWEAK_LEN_NEW = 7;
    private static final int HALF_TWEAK_LEN = 4;
    private static final int MAX_RADIX = 256;
    private static final Logger logger = LogManager.getLogger((String)FF3Cipher.class.getName());
    public static final int DOMAIN_MIN = 1000000;
    public static final String DIGITS = "0123456789";
    public static final String ASCII_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String ASCII_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final int radix;
    private final String alphabet;
    private byte[] defaultTweak;
    private final int minLen;
    private final int maxLen;
    private final Cipher aesCipher;

    public FF3Cipher(String key, String tweak) {
        this(key, tweak, 10);
    }

    public FF3Cipher(byte[] key, byte[] tweak) {
        this(key, tweak, 10);
    }

    public FF3Cipher(byte[] key, byte[] tweak, String alphabet) {
        this.alphabet = alphabet;
        this.radix = alphabet.length();
        this.minLen = (int)Math.ceil(Math.log(1000000.0) / Math.log(this.radix));
        this.maxLen = (int)(2.0 * Math.floor(Math.log(Math.pow(2.0, 96.0)) / Math.log(this.radix)));
        if (key.length != 16 && key.length != 24 && key.length != 32) {
            throw new IllegalArgumentException("key length " + key.length + " but must be 128, 192, or 256 bits");
        }
        if (this.radix < 2 || this.radix > 256) {
            throw new IllegalArgumentException("radix must be between 2 and 256, inclusive");
        }
        if (this.minLen < 2 || this.maxLen < this.minLen) {
            throw new IllegalArgumentException("minLen or maxLen invalid, adjust your radix");
        }
        this.defaultTweak = tweak;
        try {
            byte[] reversedKey = (byte[])key.clone();
            FF3Cipher.reverseBytes(reversedKey);
            SecretKeySpec keySpec = new SecretKeySpec(reversedKey, "AES");
            this.aesCipher = Cipher.getInstance("AES/ECB/NoPadding");
            this.aesCipher.init(1, keySpec);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public FF3Cipher(String key, String tweak, String alphabet) {
        this(FF3Cipher.hexStringToByteArray(key), FF3Cipher.hexStringToByteArray(tweak), alphabet);
    }

    public FF3Cipher(String key, String tweak, int radix) {
        this(FF3Cipher.hexStringToByteArray(key), FF3Cipher.hexStringToByteArray(tweak), FF3Cipher.alphabetForBase(radix));
    }

    public FF3Cipher(byte[] key, byte[] tweak, int radix) {
        this(key, tweak, FF3Cipher.alphabetForBase(radix));
    }

    public int getMinMessageLength() {
        return this.minLen;
    }

    public int getMaxMessageLength() {
        return this.maxLen;
    }

    public String encrypt(String plaintext) throws BadPaddingException, IllegalBlockSizeException {
        return this.encrypt(plaintext, this.defaultTweak);
    }

    public String encrypt(String plaintext, String tweak) throws BadPaddingException, IllegalBlockSizeException {
        return this.encrypt(plaintext, FF3Cipher.hexStringToByteArray(tweak));
    }

    public String encrypt(String plaintext, byte[] tweak) throws BadPaddingException, IllegalBlockSizeException {
        int n = plaintext.length();
        if (n < this.minLen || n > this.maxLen) {
            throw new IllegalArgumentException(String.format("message length %d is not within min %d and max %d bounds", n, this.minLen, this.maxLen));
        }
        int u = (int)Math.ceil((double)n / 2.0);
        int v = n - u;
        char[] A = new char[u];
        char[] B = new char[v];
        plaintext.getChars(0, u, A, 0);
        plaintext.getChars(u, plaintext.length(), B, 0);
        logger.trace("r {} A {} B {}", (Object)this.radix, (Object)A, (Object)B);
        if (tweak.length != 8 && tweak.length != 7) {
            throw new IllegalArgumentException(String.format("tweak length %d is invalid: tweak must be 56 or 64 bits", tweak.length));
        }
        logger.trace("tweak: {}", new Supplier[]{() -> FF3Cipher.byteArrayToHexString(tweak)});
        byte[] tweak64 = tweak.length == 7 ? FF3Cipher.calculateTweak64_FF3_1(tweak) : tweak;
        byte[] Tl = Arrays.copyOf(tweak64, 4);
        byte[] Tr = Arrays.copyOfRange(tweak64, 4, 8);
        BigInteger modU = BigInteger.valueOf(this.radix).pow(u);
        BigInteger modV = BigInteger.valueOf(this.radix).pow(v);
        logger.trace("u {} v {} modU: {} modV: {}", (Object)u, (Object)v, (Object)modU, (Object)modV);
        logger.trace("tL: {} tR: {}", new Supplier[]{() -> FF3Cipher.byteArrayToHexString(Tl), () -> FF3Cipher.byteArrayToHexString(Tr)});
        for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
            byte[] W;
            int m;
            if (i % 2 == 0) {
                m = u;
                W = Tr;
            } else {
                m = v;
                W = Tl;
            }
            byte[] P = FF3Cipher.calculateP(i, this.alphabet, W, B);
            FF3Cipher.reverseBytes(P);
            byte[] S = this.aesCipher.doFinal(P);
            FF3Cipher.reverseBytes(S);
            logger.trace("\tS: {}", new Supplier[]{() -> FF3Cipher.byteArrayToHexString(S)});
            BigInteger y = new BigInteger(FF3Cipher.byteArrayToHexString(S), 16);
            BigInteger c = FF3Cipher.decode_int_r(A, this.alphabet);
            c = c.add(y);
            c = i % 2 == 0 ? c.mod(modU) : c.mod(modV);
            logger.trace("\tm: {} A: {} c: {} y: {}", (Object)m, (Object)A, (Object)c, (Object)y);
            char[] C = FF3Cipher.encode_int_r(c, this.alphabet, m);
            A = B;
            B = C;
            logger.trace("A: {} B: {}", (Object)A, (Object)B);
        }
        return new String(A) + new String(B);
    }

    public String decrypt(String ciphertext) throws BadPaddingException, IllegalBlockSizeException {
        return this.decrypt(ciphertext, this.defaultTweak);
    }

    public String decrypt(String ciphertext, String tweak) throws BadPaddingException, IllegalBlockSizeException {
        return this.decrypt(ciphertext, FF3Cipher.hexStringToByteArray(tweak));
    }

    public String decrypt(String ciphertext, byte[] tweak) throws BadPaddingException, IllegalBlockSizeException {
        int n = ciphertext.length();
        if (n < this.minLen || n > this.maxLen) {
            throw new IllegalArgumentException(String.format("message length %d is not within min %d and max %d bounds", n, this.minLen, this.maxLen));
        }
        int u = (int)Math.ceil((double)n / 2.0);
        int v = n - u;
        char[] A = new char[u];
        char[] B = new char[v];
        ciphertext.getChars(0, u, A, 0);
        ciphertext.getChars(u, ciphertext.length(), B, 0);
        if (tweak.length != 8 && tweak.length != 7) {
            throw new IllegalArgumentException(String.format("tweak length %d is invalid: tweak must be 56 or 64 bits", tweak.length));
        }
        logger.trace("tweak: {}", new Supplier[]{() -> FF3Cipher.byteArrayToHexString(tweak)});
        byte[] tweak64 = tweak.length == 7 ? FF3Cipher.calculateTweak64_FF3_1(tweak) : tweak;
        byte[] Tl = Arrays.copyOf(tweak64, 4);
        byte[] Tr = Arrays.copyOfRange(tweak64, 4, 8);
        BigInteger modU = BigInteger.valueOf(this.radix).pow(u);
        BigInteger modV = BigInteger.valueOf(this.radix).pow(v);
        logger.trace("modU: {} modV: {}", (Object)modU, (Object)modV);
        logger.trace("tL: {} tR: {}", new Supplier[]{() -> FF3Cipher.byteArrayToHexString(Tl), () -> FF3Cipher.byteArrayToHexString(Tr)});
        for (int i = 7; i >= 0; i = (int)((byte)(i - 1))) {
            byte[] W;
            int m;
            if (i % 2 == 0) {
                m = u;
                W = Tr;
            } else {
                m = v;
                W = Tl;
            }
            byte[] P = FF3Cipher.calculateP(i, this.alphabet, W, A);
            FF3Cipher.reverseBytes(P);
            byte[] S = this.aesCipher.doFinal(P);
            FF3Cipher.reverseBytes(S);
            logger.trace("\tS: {}", new Supplier[]{() -> FF3Cipher.byteArrayToHexString(S)});
            BigInteger y = new BigInteger(FF3Cipher.byteArrayToHexString(S), 16);
            BigInteger c = FF3Cipher.decode_int_r(B, this.alphabet);
            c = c.subtract(y);
            c = i % 2 == 0 ? c.mod(modU) : c.mod(modV);
            logger.trace("\tm: {} B: {} c: {} y: {}", (Object)m, (Object)B, (Object)c, (Object)y);
            char[] C = FF3Cipher.encode_int_r(c, this.alphabet, m);
            B = A;
            A = C;
            logger.trace("A: {} B: {}", (Object)A, (Object)B);
        }
        return new String(A) + new String(B);
    }

    protected static byte[] calculateTweak64_FF3_1(byte[] tweak56) {
        byte[] tweak64 = new byte[]{tweak56[0], tweak56[1], tweak56[2], (byte)(tweak56[3] & 0xF0), tweak56[4], tweak56[5], tweak56[6], (byte)((tweak56[3] & 0xF) << 4)};
        return tweak64;
    }

    protected static byte[] calculateP(int i, String alphabet, byte[] W, char[] B) {
        byte[] P = new byte[16];
        P[0] = W[0];
        P[1] = W[1];
        P[2] = W[2];
        P[3] = (byte)(W[3] ^ i);
        BigInteger val = FF3Cipher.decode_int_r(B, alphabet);
        byte[] bBytes = val.toByteArray();
        if (bBytes.length > 12) {
            System.arraycopy(bBytes, 1, P, 4, 12);
        } else {
            System.arraycopy(bBytes, 0, P, 16 - bBytes.length, bBytes.length);
        }
        logger.trace("round: {} P: {} W: {}", new Supplier[]{() -> i, () -> FF3Cipher.byteArrayToHexString(P), () -> FF3Cipher.byteArrayToHexString(W)});
        return P;
    }

    protected static String reverseString(String s) {
        return new StringBuilder(s).reverse().toString();
    }

    protected static void reverseBytes(byte[] b) {
        for (int i = 0; i < b.length / 2; ++i) {
            byte temp = b[i];
            b[i] = b[b.length - i - 1];
            b[b.length - i - 1] = temp;
        }
    }

    public static byte[] hexStringToByteArray(String s) {
        byte[] data = new byte[s.length() / 2];
        for (int i = 0; i < s.length(); i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    protected static String byteArrayToHexString(byte[] byteArray) {
        byte[] hexChars = new byte[byteArray.length * 2];
        for (int j = 0; j < byteArray.length; ++j) {
            int v = byteArray[j] & 0xFF;
            hexChars[j * 2] = (byte)HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = (byte)HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    protected static char[] encode_int_r(BigInteger n, String alphabet, int length) {
        char[] x = new char[length];
        int i = 0;
        BigInteger bbase = BigInteger.valueOf(alphabet.length());
        while (n.compareTo(bbase) >= 0) {
            BigInteger b = n.mod(bbase);
            n = n.divide(bbase);
            x[i++] = alphabet.charAt(b.intValue());
        }
        x[i++] = alphabet.charAt(n.intValue());
        while (i < length) {
            x[i++] = alphabet.charAt(0);
        }
        return x;
    }

    protected static BigInteger decode_int_r(char[] str, String alphabet) {
        BigInteger base = BigInteger.valueOf(alphabet.length());
        BigInteger num = BigInteger.ZERO;
        for (int i = 0; i < str.length; ++i) {
            char ch = str[i];
            num = num.add(base.pow(i).multiply(BigInteger.valueOf(alphabet.indexOf(ch))));
        }
        return num;
    }

    protected static String alphabetForBase(int base) {
        switch (base) {
            case 10: {
                return DIGITS;
            }
            case 36: {
                return "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            }
            case 62: {
                return "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
            }
        }
        throw new RuntimeException("Unsupported radix");
    }
}

