/*
 * Decompiled with CFR 0.152.
 */
package btree4j;

import btree4j.BTreeCallback;
import btree4j.BTreeException;
import btree4j.Paged;
import btree4j.Settings;
import btree4j.Value;
import btree4j.indexer.IndexQuery;
import btree4j.utils.codec.VariableByteCodec;
import btree4j.utils.collections.longs.LongHash;
import btree4j.utils.collections.longs.PurgeOptObservableLongLRUMap;
import btree4j.utils.io.FastMultiByteArrayOutputStream;
import btree4j.utils.lang.ArrayUtils;
import btree4j.utils.lang.Primitives;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BTree
extends Paged {
    private static final Log LOG = LogFactory.getLog(BTree.class);
    public static final int DEFAULT_IN_MEMORY_NODES = Primitives.parseInt(Settings.get("btree4j.btree.nodecache_size"), 4096);
    private static final int BTREE_NODECACHE_PURGE_UNIT = Primitives.parseInt(Settings.get("btree4j.bfile.nodecache_purgeunit"), 8);
    public static final int KEY_NOT_FOUND = -1;
    private static final int LEAST_KEYS = 5;
    private static final byte[] EmptyBytes = new byte[0];
    private static final Value EmptyValue = new Value(EmptyBytes);
    protected static final byte LEAF = 1;
    protected static final byte BRANCH = 2;
    @Nonnull
    private final PurgeOptObservableLongLRUMap<BTreeNode> _cache;
    private final int numNodeCaches;
    @Nonnull
    private final BTreeFileHeader _fileHeader;
    private BTreeRootInfo _rootInfo;
    private BTreeNode _rootNode;

    public BTree(@Nonnull File file) {
        this(file, true);
    }

    public BTree(@Nonnull File file, boolean duplicateAllowed) {
        this(file, 4096, DEFAULT_IN_MEMORY_NODES, duplicateAllowed);
    }

    public BTree(@Nonnull File file, @Nonnegative int pageSize, int caches, boolean duplicateAllowed) {
        super(file, pageSize);
        BTreeFileHeader fh = this.getFileHeader();
        fh.incrTotalPageCount();
        fh._duplicateAllowed = duplicateAllowed;
        this._fileHeader = fh;
        Synchronizer sync = new Synchronizer();
        this._cache = new PurgeOptObservableLongLRUMap<BTreeNode>(caches, BTREE_NODECACHE_PURGE_UNIT, sync);
        this.numNodeCaches = caches;
    }

    public void init(boolean bulkload) throws BTreeException {
        if (!this.exists()) {
            boolean created = this.create(false);
            if (!created) {
                throw new IllegalStateException("create B+Tree file failed: " + this._file.getAbsolutePath());
            }
        } else {
            this.open();
        }
    }

    public void setBulkloading(boolean enable, float nodeCachePurgePerc) {
        if (enable) {
            if (nodeCachePurgePerc <= 0.0f || nodeCachePurgePerc > 1.0f) {
                throw new IllegalArgumentException("nodeCachePurgePerc is illegal as percentage: " + nodeCachePurgePerc);
            }
            int units = Math.max((int)((float)this.numNodeCaches * nodeCachePurgePerc), this.numNodeCaches);
            this._cache.setPurgeUnits(units);
        } else {
            this._cache.setPurgeUnits(this.numNodeCaches);
        }
    }

    @Override
    public boolean open() throws BTreeException {
        if (super.open()) {
            long p = this._fileHeader.getRootPage();
            this._rootInfo = new BTreeRootInfo(p);
            this._rootNode = this.getBTreeNode(this._rootInfo, p, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(boolean close) throws BTreeException {
        if (super.create(false)) {
            super.open();
            long p = this._fileHeader.getRootPage();
            this._rootInfo = new BTreeRootInfo(p);
            this._rootNode = new BTreeNode(this._rootInfo, this.getPage(p), null);
            this._rootNode.ph.setStatus((byte)1);
            this._rootNode.set(new Value[0], new long[0]);
            try {
                this._rootNode.write();
            }
            catch (IOException e) {
                throw new BTreeException(e);
            }
            PurgeOptObservableLongLRUMap<BTreeNode> purgeOptObservableLongLRUMap = this._cache;
            synchronized (purgeOptObservableLongLRUMap) {
                this._cache.put(this._rootNode.page.getPageNum(), this._rootNode);
            }
            if (close) {
                this.close();
            }
            return true;
        }
        return false;
    }

    protected final boolean isDuplicateAllowed() {
        return this._fileHeader._duplicateAllowed;
    }

    public synchronized long addValue(@Nonnull Value key, long pointer) throws BTreeException {
        try {
            return this._rootNode.addValue(key, pointer);
        }
        catch (IOException e) {
            throw new BTreeException(e);
        }
    }

    public synchronized long removeValue(@Nonnull Value key) throws BTreeException {
        try {
            return this._rootNode.removeValue(key);
        }
        catch (IOException e) {
            throw new BTreeException(e);
        }
    }

    public synchronized int removeValue(@Nonnull Value key, long pointer) throws BTreeException {
        try {
            return this._rootNode.removeValue(key, pointer);
        }
        catch (IOException e) {
            throw new BTreeException(e);
        }
    }

    public synchronized long findValue(@Nonnull Value key) throws BTreeException {
        return this._rootNode.findValue(key);
    }

    public synchronized void search(@Nonnull IndexQuery query, @Nonnull BTreeCallback callback) throws BTreeException {
        BTreeNode root = this._rootNode;
        Value[] keys = query.getOperands();
        int op = query.getOperator();
        try {
            switch (op) {
                case 1: {
                    if (this.isDuplicateAllowed()) {
                        BTreeNode left = root.getLeafNode(SearchType.LEFT, keys[0]);
                        BTreeNode right = root.getLeafNode(SearchType.RIGHT, keys[0]);
                        this.scanRange(left, right, query, callback);
                        break;
                    }
                    BTreeNode left = root.getLeafNode(SearchType.LEFT, keys[0]);
                    left.scanLeaf(query, callback, true);
                    break;
                }
                case -3: 
                case 2: {
                    BTreeNode right = root.getLeafNode(SearchType.LEFT, keys[keys.length - 1]);
                    BTreeNode rightmost = root.getLeafNode(SearchType.RIGHT_MOST, null);
                    this.scanRange(right, rightmost, query, callback);
                    break;
                }
                case -2: 
                case 3: {
                    BTreeNode left = root.getLeafNode(SearchType.LEFT, keys[0]);
                    BTreeNode leftmost = root.getLeafNode(SearchType.LEFT_MOST, null);
                    this.scanRange(leftmost, left, query, callback);
                    break;
                }
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -1: {
                    BTreeNode leftmost = root.getLeafNode(SearchType.LEFT_MOST, null);
                    BTreeNode left = root.getLeafNode(SearchType.LEFT, keys[0]);
                    BTreeNode rightmost = root.getLeafNode(SearchType.RIGHT_MOST, null);
                    BTreeNode right = root.getLeafNode(SearchType.RIGHT, keys[keys.length - 1]);
                    this.scanRange(leftmost, left, query, callback);
                    long lp = left.page.getPageNum();
                    long rp = right.page.getPageNum();
                    if (lp != rp) {
                        this.scanRange(right, rightmost, query, callback);
                    }
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    BTreeNode left = root.getLeafNode(SearchType.LEFT, keys[0]);
                    BTreeNode right = root.getLeafNode(SearchType.RIGHT, keys[keys.length - 1]);
                    this.scanRange(left, right, query, callback);
                    break;
                }
                default: {
                    BTreeNode leftmost = root.getLeafNode(SearchType.LEFT_MOST, null);
                    BTreeNode rightmost = root.getLeafNode(SearchType.RIGHT_MOST, null);
                    this.scanRange(leftmost, rightmost, query, callback);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new BTreeException(e);
        }
    }

    private final void scanRange(@Nonnull BTreeNode left, @Nonnull BTreeNode right, @Nonnull IndexQuery query, @Nonnull BTreeCallback callback) throws BTreeException {
        long rightmostPageNum = right.page.getPageNum();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("scan range [" + left.page.getPageNum() + ", " + rightmostPageNum + "] start"));
        }
        BTreeNode cur = left;
        int scaned = 0;
        while (true) {
            long curPageNum;
            if ((curPageNum = cur.page.getPageNum()) == rightmostPageNum) {
                cur.scanLeaf(query, callback, true);
                ++scaned;
                break;
            }
            cur.scanLeaf(query, callback, scaned == 0);
            ++scaned;
            long next = cur.next;
            if (next == curPageNum) {
                throw new IllegalStateException("detected a cyclic link at page#" + curPageNum);
            }
            if (next == -1L) {
                throw new IllegalStateException("range scan failed... bug?");
            }
            cur = this.getBTreeNode(this._rootInfo, next, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("scan range end. total scaned pages: " + scaned));
        }
    }

    @Override
    protected Paged.FileHeader createFileHeader(int pageSize) {
        return new BTreeFileHeader(pageSize);
    }

    @Override
    protected Paged.PageHeader createPageHeader() {
        return new BTreePageHeader();
    }

    @Override
    protected BTreeFileHeader getFileHeader() {
        return (BTreeFileHeader)super.getFileHeader();
    }

    protected final BTreeNode getRootNode(BTreeRootInfo root) throws BTreeException {
        if (root.page == this._rootInfo.page) {
            return this._rootNode;
        }
        return this.getBTreeNode(root, root.getPage(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BTreeNode getBTreeNode(BTreeRootInfo root, long page, @Nullable BTreeNode parent) throws BTreeException {
        BTreeNode node;
        PurgeOptObservableLongLRUMap<BTreeNode> purgeOptObservableLongLRUMap = this._cache;
        synchronized (purgeOptObservableLongLRUMap) {
            node = (BTreeNode)this._cache.get(page);
            if (node == null) {
                node = new BTreeNode(root, this.getPage(page), parent);
                try {
                    node.read();
                }
                catch (IOException e) {
                    throw new BTreeException("failed to read page#" + page, e);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("read node page#" + page + ", keys: " + node.keys.length));
                }
                this._cache.put(page, node);
            } else if (parent != null) {
                node.setParent(parent);
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BTreeNode getBTreeNode(BTreeRootInfo root, long page) throws BTreeException {
        BTreeNode node;
        PurgeOptObservableLongLRUMap<BTreeNode> purgeOptObservableLongLRUMap = this._cache;
        synchronized (purgeOptObservableLongLRUMap) {
            node = (BTreeNode)this._cache.get(page);
            if (node == null) {
                node = new BTreeNode(root, this.getPage(page));
                try {
                    node.read();
                }
                catch (IOException e) {
                    throw new BTreeException("failed to read page#" + page, e);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("read node page#" + page + ", keys: " + node.keys.length));
                }
                this._cache.put(page, node);
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BTreeNode createBTreeNode(BTreeRootInfo root, byte status, @CheckForNull BTreeNode parent) throws BTreeException {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        Paged.Page p = this.getFreePage();
        BTreeNode node = new BTreeNode(root, p, parent);
        node.ph.setStatus(status);
        PurgeOptObservableLongLRUMap<BTreeNode> purgeOptObservableLongLRUMap = this._cache;
        synchronized (purgeOptObservableLongLRUMap) {
            this._cache.put(p.getPageNum(), node);
        }
        return node;
    }

    @Override
    public void flush() throws BTreeException {
        this.flush(true, false);
    }

    public synchronized void flush(boolean purge, boolean clear) throws BTreeException {
        if (purge) {
            try {
                for (LongHash.BucketEntry e : this._cache) {
                    BTreeNode node = (BTreeNode)e.getValue();
                    if (node == null) continue;
                    node.write();
                }
            }
            catch (IOException ioe) {
                throw new BTreeException(ioe);
            }
        }
        if (clear) {
            this._cache.clear();
        }
        super.flush();
    }

    public static final class BTreeCorruptException
    extends RuntimeException {
        private static final long serialVersionUID = 5609947858701765326L;

        public BTreeCorruptException(String message) {
            super(message);
        }

        public BTreeCorruptException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    protected class BTreePageHeader
    extends Paged.PageHeader {
        private long parentPage;
        private short valueCount;
        private short prefixLength;
        private int leftLookup;

        public BTreePageHeader() {
            this.valueCount = 0;
            this.prefixLength = 0;
            this.leftLookup = 0;
        }

        @Deprecated
        public BTreePageHeader(ByteBuffer buf) {
            super(buf);
            this.valueCount = 0;
            this.prefixLength = 0;
            this.leftLookup = 0;
        }

        @Override
        public void read(ByteBuffer buf) {
            super.read(buf);
            if (this.getStatus() == 0) {
                return;
            }
            this.parentPage = buf.getLong();
            this.valueCount = buf.getShort();
            this.prefixLength = buf.getShort();
            this.leftLookup = buf.getInt();
        }

        @Override
        public void write(ByteBuffer buf) {
            super.write(buf);
            buf.putLong(this.parentPage);
            buf.putShort(this.valueCount);
            buf.putShort(this.prefixLength);
            buf.putInt(this.leftLookup);
        }

        public void setParent(BTreeNode parentNode) {
            this.parentPage = parentNode == null ? -1L : parentNode.page.getPageNum();
        }

        public final void setValueCount(short valueCount) {
            this.valueCount = valueCount;
        }

        public final short getValueCount() {
            return this.valueCount;
        }

        public final int getPointerCount() {
            if (this.getStatus() == 2) {
                return this.valueCount + 1;
            }
            return this.valueCount;
        }

        public final short getPrefixLength() {
            return this.prefixLength;
        }

        public final void setPrefixLength(short prefixLength) {
            this.prefixLength = prefixLength;
        }

        public final int getLeftLookup() {
            return this.leftLookup;
        }

        public final void setLeftLookup(int leftLookup) {
            this.leftLookup = leftLookup;
        }
    }

    protected class BTreeFileHeader
    extends Paged.FileHeader {
        private long _rootPage;
        private boolean _duplicateAllowed;

        public BTreeFileHeader(int pageSize) {
            super(BTree.this, pageSize);
            this._rootPage = 0L;
            this._duplicateAllowed = true;
        }

        @Override
        public synchronized void read(RandomAccessFile raf) throws IOException {
            super.read(raf);
            this._duplicateAllowed = raf.readBoolean();
            this._rootPage = raf.readLong();
        }

        @Override
        public synchronized void write(RandomAccessFile raf) throws IOException {
            super.write(raf);
            raf.writeBoolean(this._duplicateAllowed);
            raf.writeLong(this._rootPage);
        }

        @Deprecated
        public final void setRootPage(long rootPage) {
            this._rootPage = rootPage;
            this.setDirty(true);
        }

        public final long getRootPage() {
            return this._rootPage;
        }
    }

    private final class BTreeNode
    implements Comparable<BTreeNode> {
        private final BTreeRootInfo root;
        private final Paged.Page page;
        private final BTreePageHeader ph;
        private BTreeNode parentCache;
        private Value[] keys;
        private long[] ptrs;
        private long next = -1L;
        private long prev = -1L;
        private Value prefix = null;
        private boolean loaded = false;
        private int currentDataLen = -1;
        private boolean dirty = false;

        protected BTreeNode(BTreeRootInfo root, Paged.Page page, BTreeNode parentNode) {
            this.root = root;
            this.page = page;
            this.ph = (BTreePageHeader)page.getPageHeader();
            this.ph.setParent(parentNode);
            this.parentCache = parentNode;
        }

        protected BTreeNode(BTreeRootInfo root, Paged.Page page) {
            this.root = root;
            this.page = page;
            this.ph = (BTreePageHeader)page.getPageHeader();
        }

        @Nullable
        private BTreeNode getParent() {
            if (this.parentCache != null) {
                return this.parentCache;
            }
            long page = this.ph.parentPage;
            if (page != -1L) {
                try {
                    this.parentCache = BTree.this.getBTreeNode(BTree.this._rootInfo, page);
                }
                catch (BTreeException e) {
                    throw new IllegalStateException("failed to get parent page #" + page, e);
                }
                return this.parentCache;
            }
            return null;
        }

        private void setParent(@Nonnull BTreeNode node) {
            long parentPage = node.page.getPageNum();
            if (parentPage != this.ph.parentPage) {
                this.ph.parentPage = parentPage;
                this.parentCache = node;
                this.dirty = true;
            }
        }

        long addValue(@Nonnull Value key, long pointer) throws IOException, BTreeException {
            int idx = this.searchRightmostKey(this.keys, key, this.keys.length);
            switch (this.ph.getStatus()) {
                case 2: {
                    idx = idx < 0 ? -(idx + 1) : idx + 1;
                    return this.getChildNode(idx).addValue(key, pointer);
                }
                case 1: {
                    long oldPtr;
                    boolean found;
                    boolean bl = found = idx >= 0;
                    if (found) {
                        if (!BTree.this.isDuplicateAllowed()) {
                            throw new BTreeCorruptException("Attempt to add duplicate key to the unique index: " + key);
                        }
                        oldPtr = this.ptrs[idx];
                        key = this.keys[idx];
                        ++idx;
                    } else {
                        oldPtr = -1L;
                        idx = -(idx + 1);
                    }
                    this.set((Value[])ArrayUtils.insert(this.keys, idx, key), ArrayUtils.insert(this.ptrs, idx, pointer));
                    this.incrDataLength(key, pointer);
                    if (this.needSplit()) {
                        this.split();
                    }
                    return oldPtr;
                }
            }
            throw new BTreeCorruptException("Invalid Page Type '" + this.ph.getStatus() + "' was detected for page#" + this.page.getPageNum());
        }

        private int searchLeftmostKey(Value[] ary, Value key, int to) {
            if (!BTree.this._fileHeader._duplicateAllowed) {
                return ArrayUtils.binarySearch((Comparable[])this.keys, (int)0, (int)to, (Comparable)key);
            }
            int low = 0;
            int high = to - 1;
            while (low <= high) {
                Value nxtVal;
                int mid = low + high >>> 1;
                Value midVal = ary[mid];
                int cmp = midVal.compareTo(key);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                int i = mid - 1;
                while (i >= 0 && (cmp = midVal.compareTo(nxtVal = ary[i])) == 0) {
                    mid = i--;
                }
                return mid;
            }
            return -(low + 1);
        }

        private int searchRightmostKey(Value[] ary, Value key, int to) {
            if (!BTree.this._fileHeader._duplicateAllowed) {
                return ArrayUtils.binarySearch((Comparable[])this.keys, (int)0, (int)to, (Comparable)key);
            }
            int low = 0;
            int high = to - 1;
            while (low <= high) {
                Value nxtVal;
                int mid = low + high >>> 1;
                Value midVal = ary[mid];
                int cmp = midVal.compareTo(key);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                int i = mid + 1;
                while (i <= high && (cmp = midVal.compareTo(nxtVal = ary[i])) == 0) {
                    mid = i++;
                }
                return mid;
            }
            return -(low + 1);
        }

        long removeValue(Value searchKey) throws IOException, BTreeException {
            int leftIdx = this.searchLeftmostKey(this.keys, searchKey, this.keys.length);
            switch (this.ph.getStatus()) {
                case 2: {
                    leftIdx = leftIdx < 0 ? -(leftIdx + 1) : leftIdx + 1;
                    return this.getChildNode(leftIdx).removeValue(searchKey);
                }
                case 1: {
                    if (leftIdx < 0) {
                        return -1L;
                    }
                    long oldPtr = this.ptrs[leftIdx];
                    this.set(ArrayUtils.remove(this.keys, leftIdx), ArrayUtils.remove(this.ptrs, leftIdx));
                    this.decrDataLength(searchKey);
                    return oldPtr;
                }
            }
            throw new BTreeCorruptException("Invalid page type '" + this.ph.getStatus() + "' in removeValue");
        }

        @Deprecated
        int removeValue(Value searchKey, long pointer) throws IOException, BTreeException {
            int leftIdx = this.searchLeftmostKey(this.keys, searchKey, this.keys.length);
            int rightIdx = BTree.this.isDuplicateAllowed() ? this.searchRightmostKey(this.keys, searchKey, this.keys.length) : leftIdx;
            switch (this.ph.getStatus()) {
                case 2: {
                    leftIdx = leftIdx < 0 ? -(leftIdx + 1) : leftIdx + 1;
                    return this.getChildNode(leftIdx).removeValue(searchKey, pointer);
                }
                case 1: {
                    if (leftIdx < 0) {
                        return 0;
                    }
                    int founds = 0;
                    for (int i = leftIdx; i <= rightIdx; ++i) {
                        long p = this.ptrs[i];
                        if (p != pointer) continue;
                        this.set(ArrayUtils.remove(this.keys, i), ArrayUtils.remove(this.ptrs, i));
                        this.decrDataLength(searchKey);
                        --i;
                        --rightIdx;
                    }
                    return founds;
                }
            }
            throw new BTreeCorruptException("Invalid page type '" + this.ph.getStatus() + "' in removeValue");
        }

        @Nullable
        private BTreeNode getChildNode(int idx) throws BTreeException {
            if (this.ph.getStatus() == 2 && idx >= 0 && idx < this.ptrs.length) {
                return BTree.this.getBTreeNode(this.root, this.ptrs[idx], this);
            }
            return null;
        }

        private boolean needSplit() {
            int worksize;
            int afterKeysLength = this.keys.length + 1;
            if (afterKeysLength < 5) {
                return false;
            }
            if (afterKeysLength > Short.MAX_VALUE) {
                return true;
            }
            assert (this.prefix != null);
            int datalen = this.calculateDataLength();
            return datalen > (worksize = BTree.this._fileHeader.getWorkSize());
        }

        private void split() throws IOException, BTreeException {
            Value separator;
            long[] rightPtrs;
            Value[] rightVals;
            long[] leftPtrs;
            Value[] leftVals;
            short vc = this.ph.getValueCount();
            int pivot = vc / 2;
            byte pageType = this.ph.getStatus();
            int leftLookup = 0;
            switch (pageType) {
                case 2: {
                    leftVals = new Value[pivot];
                    leftPtrs = new long[leftVals.length + 1];
                    rightVals = new Value[vc - (pivot + 1)];
                    rightPtrs = new long[rightVals.length + 1];
                    System.arraycopy(this.keys, 0, leftVals, 0, leftVals.length);
                    System.arraycopy(this.ptrs, 0, leftPtrs, 0, leftPtrs.length);
                    System.arraycopy(this.keys, leftVals.length + 1, rightVals, 0, rightVals.length);
                    System.arraycopy(this.ptrs, leftPtrs.length, rightPtrs, 0, rightPtrs.length);
                    separator = this.keys[leftVals.length];
                    break;
                }
                case 1: {
                    Value pivotLeft = this.keys[pivot - 1];
                    Value pivotRight = this.keys[pivot];
                    if (pivotLeft.equals(pivotRight)) {
                        int leftmost = this.searchLeftmostKey(this.keys, pivotLeft, pivot - 1);
                        int diff = pivot - leftmost;
                        if (diff < 0 || diff > Short.MAX_VALUE) {
                            throw new IllegalStateException("pivot: " + pivot + ", leftmost: " + leftmost + "\nkeys: " + Arrays.toString(this.keys));
                        }
                        leftLookup = diff;
                    }
                    leftVals = new Value[pivot];
                    leftPtrs = new long[leftVals.length];
                    rightVals = new Value[vc - pivot];
                    rightPtrs = new long[rightVals.length];
                    System.arraycopy(this.keys, 0, leftVals, 0, leftVals.length);
                    System.arraycopy(this.ptrs, 0, leftPtrs, 0, leftPtrs.length);
                    System.arraycopy(this.keys, leftVals.length, rightVals, 0, rightVals.length);
                    System.arraycopy(this.ptrs, leftPtrs.length, rightPtrs, 0, rightPtrs.length);
                    separator = this.getSeparator(leftVals[leftVals.length - 1], rightVals[0]);
                    break;
                }
                default: {
                    throw new BTreeCorruptException("Invalid page type in split: " + pageType);
                }
            }
            BTreeNode parent = this.getParent();
            if (parent == null) {
                BTreeNode lNode = BTree.this.createBTreeNode(this.root, pageType, this);
                lNode.set(leftVals, leftPtrs);
                lNode.calculateDataLength();
                lNode.setAsParent();
                BTreeNode rNode = BTree.this.createBTreeNode(this.root, pageType, this);
                rNode.set(rightVals, rightPtrs);
                rNode.calculateDataLength();
                rNode.setAsParent();
                if (pageType == 1) {
                    this.setLeavesLinked(lNode, rNode);
                }
                this.ph.setStatus((byte)2);
                this.set(new Value[]{separator}, new long[]{lNode.page.getPageNum(), rNode.page.getPageNum()});
                this.calculateDataLength();
            } else {
                this.set(leftVals, leftPtrs);
                this.calculateDataLength();
                BTreeNode rNode = BTree.this.createBTreeNode(this.root, pageType, parent);
                rNode.set(rightVals, rightPtrs);
                rNode.calculateDataLength();
                rNode.setAsParent();
                if (pageType == 1) {
                    this.setLeavesLinked(this, rNode);
                    if (leftLookup > 0) {
                        rNode.ph.setLeftLookup(leftLookup);
                    }
                }
                long leftPtr = this.page.getPageNum();
                long rightPtr = rNode.page.getPageNum();
                parent.promoteValue(separator, leftPtr, rightPtr);
            }
        }

        private void setAsParent() throws BTreeException {
            if (this.ph.getStatus() == 2) {
                for (long ptr : this.ptrs) {
                    BTreeNode child = BTree.this.getBTreeNode(BTree.this._rootInfo, ptr, this);
                    child.setParent(this);
                }
            }
        }

        private void setLeavesLinked(@Nonnull BTreeNode left, @Nonnull BTreeNode right) throws BTreeException {
            long leftPageNum = left.page.getPageNum();
            long rightPageNum = right.page.getPageNum();
            long origNext = left.next;
            if (origNext != -1L) {
                right.next = origNext;
                BTreeNode origNextNode = BTree.this.getBTreeNode(this.root, origNext);
                origNextNode.prev = rightPageNum;
                origNextNode.setDirty(true);
            }
            left.next = rightPageNum;
            left.setDirty(true);
            right.prev = leftPageNum;
            right.setDirty(true);
        }

        private void promoteValue(@Nonnull Value key, long leftPtr, long rightPtr) throws IOException, BTreeException {
            int leftIdx = this.searchRightmostKey(this.keys, key, this.keys.length);
            int insertPoint = leftIdx < 0 ? -(leftIdx + 1) : leftIdx + 1;
            boolean found = false;
            for (int i = insertPoint; i >= 0; --i) {
                long ptr = this.ptrs[i];
                if (ptr != leftPtr) continue;
                insertPoint = i;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalStateException("page#" + this.page.getPageNum() + ", insertPoint: " + insertPoint + ", leftPtr: " + leftPtr + ", ptrs: " + Arrays.toString(this.ptrs));
            }
            this.set((Value[])ArrayUtils.insert(this.keys, insertPoint, key), ArrayUtils.insert(this.ptrs, insertPoint + 1, rightPtr));
            this.incrDataLength(key, rightPtr);
            if (this.needSplit()) {
                this.split();
            }
        }

        private Value getSeparator(@Nonnull Value value1, @Nonnull Value value2) {
            int idx = value1.compareTo(value2);
            if (idx == 0) {
                return value1.clone();
            }
            byte[] b = new byte[Math.abs(idx)];
            value2.copyTo(b, 0, b.length);
            return new Value(b);
        }

        private void set(@Nonnull Value[] values, @Nonnull long[] ptrs) {
            int vlen = values.length;
            if (vlen > Short.MAX_VALUE) {
                throw new IllegalArgumentException("entries exceeds limit: " + vlen);
            }
            this.keys = values;
            this.ptrs = ptrs;
            this.ph.setValueCount((short)vlen);
            if (vlen > 1) {
                short prevPrefixLen = this.ph.getPrefixLength();
                this.prefix = this.getPrefix(values[0], values[vlen - 1]);
                int prefixLen = this.prefix.getLength();
                assert (prefixLen <= Short.MAX_VALUE) : prefixLen;
                if (prefixLen != prevPrefixLen) {
                    int diff = prefixLen - prevPrefixLen;
                    this.currentDataLen += diff;
                    this.ph.setPrefixLength((short)prefixLen);
                }
            } else {
                this.prefix = EmptyValue;
                this.ph.setPrefixLength((short)0);
            }
            this.setDirty(true);
        }

        private void setDirty(boolean dirt) {
            this.dirty = dirt;
            if (dirt) {
                BTree.this._cache.put(this.page.getPageNum(), this);
            }
        }

        @Nonnull
        private Value getPrefix(@Nonnull Value v1, @Nonnull Value v2) {
            int idx = Math.abs(v1.compareTo(v2)) - 1;
            if (idx > 0) {
                byte[] d2 = v2.getData();
                return new Value(d2, v2.getPosition(), idx);
            }
            return EmptyValue;
        }

        private void read() throws IOException, BTreeException {
            if (!this.loaded) {
                byte[] pfxBytes;
                Value v = BTree.this.readValue(this.page);
                DataInputStream in = new DataInputStream(v.getInputStream());
                short pfxLen = this.ph.getPrefixLength();
                if (pfxLen > 0) {
                    pfxBytes = new byte[pfxLen];
                    in.read(pfxBytes);
                    this.prefix = new Value(pfxBytes);
                } else {
                    pfxBytes = EmptyBytes;
                    this.prefix = EmptyValue;
                }
                Value prevKey = null;
                int keyslen = this.ph.getValueCount();
                this.keys = new Value[keyslen];
                for (int i = 0; i < keyslen; ++i) {
                    int valSize = in.readInt();
                    if (valSize == -1) {
                        prevKey.incrRefCount();
                        this.keys[i] = prevKey;
                        continue;
                    }
                    byte[] b = new byte[pfxLen + valSize];
                    if (pfxLen > 0) {
                        System.arraycopy(pfxBytes, 0, b, 0, pfxLen);
                    }
                    if (valSize > 0) {
                        in.read(b, pfxLen, valSize);
                    }
                    this.keys[i] = prevKey = new Value(b);
                }
                int ptrslen = this.ph.getPointerCount();
                this.ptrs = new long[ptrslen];
                for (int i = 0; i < ptrslen; ++i) {
                    this.ptrs[i] = VariableByteCodec.decodeUnsignedLong(in);
                }
                if (this.ph.getStatus() == 1) {
                    this.prev = in.readLong();
                    this.next = in.readLong();
                }
                this.currentDataLen = v.getLength();
                this.loaded = true;
            }
        }

        private void write() throws IOException, BTreeException {
            int i;
            if (!this.dirty) {
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)((this.ph.getStatus() == 1 ? "Leaf " : "Branch ") + "Node#" + this.page.getPageNum() + " - " + Arrays.toString(this.keys)));
            }
            FastMultiByteArrayOutputStream bos = new FastMultiByteArrayOutputStream(BTree.this._fileHeader.getWorkSize());
            DataOutputStream os = new DataOutputStream(bos);
            short prefixlen = this.ph.getPrefixLength();
            if (prefixlen > 0) {
                this.prefix.writeTo(os);
            }
            Value prevKey = null;
            for (i = 0; i < this.keys.length; ++i) {
                Value v = this.keys[i];
                if (v == prevKey) {
                    os.writeInt(-1);
                } else {
                    int len = v.getLength();
                    int size = len - prefixlen;
                    os.writeInt(size);
                    if (size > 0) {
                        v.writeTo(os, prefixlen, size);
                    }
                }
                prevKey = v;
            }
            for (i = 0; i < this.ptrs.length; ++i) {
                VariableByteCodec.encodeUnsignedLong(this.ptrs[i], os);
            }
            if (this.ph.getStatus() == 1) {
                os.writeLong(this.prev);
                os.writeLong(this.next);
            }
            BTree.this.writeValue(this.page, new Value(bos.toByteArray()));
            this.parentCache = null;
            this.setDirty(false);
        }

        private int calculateDataLength() {
            if (this.currentDataLen > 0) {
                return this.currentDataLen;
            }
            int vlen = this.keys.length;
            short prefixlen = this.ph.getPrefixLength();
            int datalen = prefixlen + (vlen >>> 2);
            Value prevValue = null;
            for (int i = 0; i < vlen; ++i) {
                long ptr = this.ptrs[i];
                datalen += VariableByteCodec.requiredBytes(ptr);
                Value v = this.keys[i];
                if (v == prevValue) continue;
                int keylen = v.getLength();
                int actkeylen = keylen - prefixlen;
                datalen += actkeylen;
                prevValue = v;
            }
            if (this.ph.getStatus() == 1) {
                datalen += 16;
            }
            this.currentDataLen = datalen;
            return datalen;
        }

        private void incrDataLength(@Nonnull Value key, long ptr) {
            int refcnt;
            int datalen = this.currentDataLen;
            if (datalen == -1) {
                datalen = this.calculateDataLength();
            }
            if ((refcnt = key.incrRefCount()) == 1) {
                datalen += key.getLength();
            }
            datalen += VariableByteCodec.requiredBytes(ptr);
            this.currentDataLen = datalen += 4;
        }

        private void decrDataLength(Value value) {
            int datalen = this.currentDataLen;
            int refcnt = value.decrRefCount();
            if (refcnt == 0) {
                datalen -= value.getLength();
            }
            this.currentDataLen = datalen -= 12;
        }

        long findValue(@Nonnull Value searchKey) throws BTreeException {
            int idx = this.searchLeftmostKey(this.keys, searchKey, this.keys.length);
            switch (this.ph.getStatus()) {
                case 2: {
                    idx = idx < 0 ? -(idx + 1) : idx + 1;
                    return this.getChildNode(idx).findValue(searchKey);
                }
                case 1: {
                    if (idx < 0) {
                        return -1L;
                    }
                    if (idx == 0 && this.ph.getLeftLookup() > 0) {
                        int prevLookup;
                        Value[] lmKeys;
                        BTreeNode leftmostNode = this;
                        do {
                            leftmostNode = BTree.this.getBTreeNode(this.root, leftmostNode.prev);
                            lmKeys = leftmostNode.keys;
                            assert (lmKeys.length > 0);
                        } while (lmKeys[0].equals(searchKey) && (prevLookup = leftmostNode.ph.getLeftLookup()) != 0);
                        lmKeys = leftmostNode.keys;
                        int lmIdx = leftmostNode.searchLeftmostKey(lmKeys, searchKey, lmKeys.length);
                        if (lmIdx < 0) {
                            throw new BTreeCorruptException("Duplicated key was not found: " + searchKey);
                        }
                        long[] leftmostPtrs = leftmostNode.ptrs;
                        return leftmostPtrs[lmIdx];
                    }
                    return this.ptrs[idx];
                }
            }
            throw new BTreeCorruptException("Invalid page type '" + this.ph.getStatus() + "' in findValue");
        }

        void scanLeaf(@Nonnull IndexQuery query, @Nonnull BTreeCallback callback, boolean edge) {
            assert (this.ph.getStatus() == 1) : this.ph.getStatus();
            Value[] conds = query.getOperands();
            switch (query.getOperator()) {
                case 1: {
                    if (!edge) {
                        for (int i = 0; i < this.keys.length; ++i) {
                            callback.indexInfo(this.keys[i], this.ptrs[i]);
                        }
                        return;
                    }
                    int leftIdx = this.searchLeftmostKey(this.keys, conds[0], this.keys.length);
                    if (leftIdx < 0) break;
                    assert (BTree.this.isDuplicateAllowed());
                    int rightIdx = this.searchRightmostKey(this.keys, conds[conds.length - 1], this.keys.length);
                    for (int i = leftIdx; i <= rightIdx; ++i) {
                        callback.indexInfo(this.keys[i], this.ptrs[i]);
                    }
                    break;
                }
                case -1: {
                    int leftIdx = this.searchLeftmostKey(this.keys, conds[0], this.keys.length);
                    int rightIdx = BTree.this.isDuplicateAllowed() ? this.searchRightmostKey(this.keys, conds[conds.length - 1], this.keys.length) : leftIdx;
                    for (int i = 0; i < this.ptrs.length; ++i) {
                        if (i >= leftIdx && i <= rightIdx) continue;
                        callback.indexInfo(this.keys[i], this.ptrs[i]);
                    }
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    int rightIdx;
                    if (!edge) {
                        for (int i = 0; i < this.keys.length; ++i) {
                            if (!query.testValue(this.keys[i])) continue;
                            callback.indexInfo(this.keys[i], this.ptrs[i]);
                        }
                        return;
                    }
                    int leftIdx = this.searchLeftmostKey(this.keys, conds[0], this.keys.length);
                    if (leftIdx < 0) {
                        leftIdx = -(leftIdx + 1);
                    }
                    if ((rightIdx = this.searchRightmostKey(this.keys, conds[conds.length - 1], this.keys.length)) < 0) {
                        rightIdx = -(rightIdx + 1);
                    }
                    for (int i = leftIdx; i < this.ptrs.length; ++i) {
                        if (i > rightIdx || !query.testValue(this.keys[i])) continue;
                        callback.indexInfo(this.keys[i], this.ptrs[i]);
                    }
                    break;
                }
                case -7: 
                case -5: 
                case -4: {
                    int rightIdx;
                    int leftIdx = this.searchLeftmostKey(this.keys, conds[0], this.keys.length);
                    if (leftIdx < 0) {
                        leftIdx = -(leftIdx + 1);
                    }
                    if ((rightIdx = this.searchRightmostKey(this.keys, conds[conds.length - 1], this.keys.length)) < 0) {
                        rightIdx = -(rightIdx + 1);
                    }
                    for (int i = 0; i < this.ptrs.length; ++i) {
                        if (i > leftIdx && i < rightIdx || !query.testValue(this.keys[i])) continue;
                        callback.indexInfo(this.keys[i], this.ptrs[i]);
                    }
                    break;
                }
                case 3: {
                    int leftIdx = this.searchLeftmostKey(this.keys, conds[0], this.keys.length);
                    if (leftIdx < 0) {
                        leftIdx = -(leftIdx + 1);
                    }
                    for (int i = 0; i < leftIdx; ++i) {
                        callback.indexInfo(this.keys[i], this.ptrs[i]);
                    }
                    break;
                }
                case -2: {
                    int leftIdx = this.searchRightmostKey(this.keys, conds[0], this.keys.length);
                    if (leftIdx < 0) {
                        leftIdx = -(leftIdx + 1);
                    }
                    if (leftIdx >= this.ptrs.length) {
                        leftIdx = this.ptrs.length - 1;
                    }
                    for (int i = 0; i <= leftIdx; ++i) {
                        callback.indexInfo(this.keys[i], this.ptrs[i]);
                    }
                    break;
                }
                case 2: {
                    int rightIdx = this.searchRightmostKey(this.keys, conds[0], this.keys.length);
                    if (rightIdx < 0) {
                        rightIdx = -(rightIdx + 1);
                    }
                    for (int i = rightIdx + 1; i < this.ptrs.length; ++i) {
                        callback.indexInfo(this.keys[i], this.ptrs[i]);
                    }
                    break;
                }
                case -3: {
                    int rightIdx = this.searchLeftmostKey(this.keys, conds[0], this.keys.length);
                    if (rightIdx < 0) {
                        rightIdx = -(rightIdx + 1);
                    }
                    for (int i = rightIdx; i < this.ptrs.length; ++i) {
                        callback.indexInfo(this.keys[i], this.ptrs[i]);
                    }
                    break;
                }
                case 0: {
                    for (int i = 0; i < this.ptrs.length; ++i) {
                        callback.indexInfo(this.keys[i], this.ptrs[i]);
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < this.ptrs.length; ++i) {
                        if (!query.testValue(this.keys[i])) continue;
                        callback.indexInfo(this.keys[i], this.ptrs[i]);
                    }
                }
            }
        }

        BTreeNode getLeafNode(@Nonnull SearchType searchType, @Nonnull Value key) throws IOException, BTreeException {
            byte nodeType = this.ph.getStatus();
            switch (nodeType) {
                case 2: {
                    switch (searchType) {
                        case LEFT: {
                            int leftIdx = this.searchLeftmostKey(this.keys, key, this.keys.length);
                            leftIdx = leftIdx < 0 ? -(leftIdx + 1) : leftIdx + 1;
                            return this.getChildNode(leftIdx).getLeafNode(searchType, key);
                        }
                        case RIGHT: {
                            int rightIdx = this.searchRightmostKey(this.keys, key, this.keys.length);
                            rightIdx = rightIdx < 0 ? -(rightIdx + 1) : rightIdx + 1;
                            return this.getChildNode(rightIdx).getLeafNode(searchType, key);
                        }
                        case LEFT_MOST: {
                            return this.getChildNode(0).getLeafNode(searchType, key);
                        }
                        case RIGHT_MOST: {
                            int rightIdx = this.ptrs.length - 1;
                            assert (rightIdx >= 0);
                            return this.getChildNode(rightIdx).getLeafNode(searchType, key);
                        }
                    }
                    throw new IllegalStateException();
                }
                case 1: {
                    switch (searchType) {
                        case LEFT: {
                            if (this.keys.length == 0) break;
                            BTreeNode leftmostNode = this;
                            if (this.keys[0].equals(key)) {
                                int lookup = this.ph.getLeftLookup();
                                while (lookup > 0) {
                                    Value firstKey;
                                    leftmostNode = BTree.this.getBTreeNode(this.root, leftmostNode.prev);
                                    int keylen = leftmostNode.keys.length;
                                    if (lookup >= keylen && (lookup = leftmostNode.ph.getLeftLookup()) != 0 && (firstKey = leftmostNode.keys[0]).equals(key)) continue;
                                    break;
                                }
                            }
                            return leftmostNode;
                        }
                        case RIGHT_MOST: {
                            if (this.next == -1L) break;
                            BTreeNode nextNode = BTree.this.getBTreeNode(this.root, this.next);
                            BTreeNode parent = this.getParent();
                            throw new IllegalStateException("next=" + this.next + ".. more leaf [" + nextNode + "] exists on the right side of leaf [" + this.toString() + "]\n parent-ptrs: " + Arrays.toString(parent.ptrs));
                        }
                        case LEFT_MOST: {
                            if (this.prev == -1L) break;
                            BTreeNode prevNode = BTree.this.getBTreeNode(this.root, this.prev);
                            BTreeNode parent = this.getParent();
                            throw new IllegalStateException("prev=" + this.prev + ".. more leaf [" + prevNode + "] exists on the left side of leaf [" + this.toString() + "]\n parent-ptrs: " + Arrays.toString(parent.ptrs));
                        }
                    }
                    return this;
                }
            }
            throw new BTreeCorruptException("Invalid page type in query: " + nodeType);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            long rootPage = this.root.getPage();
            BTreeNode pn = this;
            while (true) {
                long curPageNum = pn.page.getPageNum();
                buf.append(curPageNum);
                pn = pn.getParent();
                if (pn == null) {
                    if (curPageNum == rootPage) break;
                    buf.append("<-?");
                    break;
                }
                buf.append("<-");
            }
            return buf.toString();
        }

        @Override
        public int compareTo(BTreeNode other) {
            return this.page.compareTo(other.page);
        }
    }

    private static final class BTreeRootInfo {
        private final long page;

        private BTreeRootInfo(long page) {
            this.page = page;
        }

        public long getPage() {
            return this.page;
        }
    }

    public static enum SearchType {
        LEFT_MOST,
        LEFT,
        RIGHT,
        RIGHT_MOST;

    }

    private static final class Synchronizer
    implements LongHash.Cleaner<BTreeNode> {
        Synchronizer() {
        }

        @Override
        public void cleanup(long key, @Nonnull BTreeNode node) {
            if (!node.dirty) {
                return;
            }
            try {
                node.write();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            catch (BTreeException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

