/*
 * Decompiled with CFR 0.152.
 */
package btree4j;

import btree4j.BTree;
import btree4j.BTreeCallback;
import btree4j.BTreeException;
import btree4j.FreeList;
import btree4j.Paged;
import btree4j.Settings;
import btree4j.Value;
import btree4j.indexer.IndexQuery;
import btree4j.utils.collections.LRUMap;
import btree4j.utils.collections.longs.LongHash;
import btree4j.utils.collections.longs.PurgeOptObservableLongLRUMap;
import btree4j.utils.lang.Primitives;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BTreeIndex
extends BTree {
    private static final byte DATA_RECORD = 10;
    public static final int DATA_CACHE_SIZE = Primitives.parseInt(Settings.get("btree4j.bfile.datacache_size"), 2048);
    public static final int DATA_CACHE_PURGE_UNIT = Primitives.parseInt(Settings.get("btree4j.bfile.datacache_purgeunit"), 16);
    private final PurgeOptObservableLongLRUMap<DataPage> dataCache;
    private final int numDataCaches;
    private final Map<Value, Long> storeCache = new LRUMap<Value, Long>(64);

    public BTreeIndex(File file) {
        this(file, true);
    }

    public BTreeIndex(File file, boolean duplicateAllowed) {
        this(file, DEFAULT_IN_MEMORY_NODES, duplicateAllowed);
    }

    public BTreeIndex(File file, int idxPageCaches, boolean duplicateAllowed) {
        this(file, 4096, idxPageCaches, DATA_CACHE_SIZE, duplicateAllowed);
    }

    public BTreeIndex(File file, int pageSize, int idxPageCaches, int dataPageCaches, boolean duplicateAllowed) {
        super(file, pageSize, idxPageCaches, duplicateAllowed);
        Synchronizer sync = new Synchronizer();
        this.dataCache = new PurgeOptObservableLongLRUMap<DataPage>(dataPageCaches, DATA_CACHE_PURGE_UNIT, sync);
        this.numDataCaches = dataPageCaches;
    }

    public void setBulkloading(boolean enable, float nodeCachePurgePerc, float dataCachePurgePerc) {
        this.setBulkloading(enable, nodeCachePurgePerc);
        if (enable) {
            if (dataCachePurgePerc <= 0.0f || dataCachePurgePerc > 1.0f) {
                throw new IllegalArgumentException("dataCachePurgePerc is illegal as percentage: " + nodeCachePurgePerc);
            }
            int units = Math.max((int)((float)this.numDataCaches * dataCachePurgePerc), this.numDataCaches);
            this.dataCache.setPurgeUnits(units);
        } else {
            this.dataCache.setPurgeUnits(this.numDataCaches);
        }
    }

    @Override
    protected BFileHeader createFileHeader(int pageSize) {
        return new BFileHeader(pageSize);
    }

    @Override
    protected BFileHeader getFileHeader() {
        return (BFileHeader)super.getFileHeader();
    }

    @Override
    protected BFilePageHeader createPageHeader() {
        return new BFilePageHeader();
    }

    @Nullable
    public final byte[] getValueBytes(long key) throws BTreeException {
        return this.getValueBytes(new Value(key));
    }

    @Nullable
    public synchronized byte[] getValueBytes(@Nonnull Value key) throws BTreeException {
        long ptr = this.findValue(key);
        if (ptr == -1L) {
            return null;
        }
        return this.retrieveTuple(ptr);
    }

    protected final synchronized byte[] retrieveTuple(long ptr) throws BTreeException {
        long pageNum = BTreeIndex.getPageNumFromPointer(ptr);
        DataPage dataPage = this.getDataPage(pageNum);
        int tidx = BTreeIndex.getTidFromPointer(ptr);
        return dataPage.get(tidx);
    }

    @Nullable
    public Value getValue(@Nonnull Value key) throws BTreeException {
        byte[] tuple = this.getValueBytes(key);
        if (tuple == null) {
            return null;
        }
        return new Value(tuple);
    }

    @Override
    public final void search(IndexQuery query, BTreeCallback callback) throws BTreeException {
        super.search(query, this.getHandler(callback));
    }

    protected BTreeCallback getHandler(BTreeCallback handler) {
        return new BFileCallback(handler);
    }

    public final long addValue(long key, @Nonnull byte[] value) throws BTreeException {
        return this.addValue(new Value(key), new Value(value));
    }

    public final long addValue(@Nonnull Value key, @Nonnull byte[] value) throws BTreeException {
        return this.addValue(key, new Value(value));
    }

    public synchronized long addValue(@Nonnull Value key, @Nonnull Value value) throws BTreeException {
        long ptr = this.findValue(key);
        if (ptr != -1L && !this.isDuplicateAllowed()) {
            this.updateValue(ptr, value);
            return ptr;
        }
        ptr = this.storeValue(value);
        this.addValue(key, ptr);
        return ptr;
    }

    public final long putValue(@Nonnull Value key, @Nonnull byte[] value) throws BTreeException {
        return this.putValue(key, new Value(value));
    }

    public synchronized long putValue(@Nonnull Value key, @Nonnull Value value) throws BTreeException {
        long ptr = this.findValue(key);
        if (ptr != -1L) {
            this.updateValue(ptr, value);
            return ptr;
        }
        ptr = this.storeValue(value);
        this.addValue(key, ptr);
        return ptr;
    }

    protected final void updateValue(long ptr, @Nonnull Value value) throws BTreeException {
        long pageNum = BTreeIndex.getPageNumFromPointer(ptr);
        DataPage dataPage = this.getDataPage(pageNum);
        int tidx = BTreeIndex.getTidFromPointer(ptr);
        dataPage.set(tidx, value);
    }

    protected final long storeValue(@Nonnull Value value) throws BTreeException {
        DataPage dataPage;
        int requiredSize;
        Long cachedPtr = this.storeCache.get(value);
        if (cachedPtr != null) {
            return cachedPtr;
        }
        BFileHeader fh = this.getFileHeader();
        FreeList freeList = fh.getFreeList();
        FreeList.FreeSpace free = freeList.retrieve(requiredSize = value.getLength() + 4);
        if (free == null) {
            DataPage newPage = this.createDataPage();
            free = new FreeList.FreeSpace(newPage.getPageNum(), fh.getWorkSize());
            freeList.add(free);
            dataPage = newPage;
        } else {
            dataPage = this.getDataPage(free.getPage());
        }
        long pageNum = dataPage.getPageNum();
        int tid = dataPage.add(value);
        this.saveFreeList(freeList, free, dataPage);
        long ptr = BTreeIndex.createPointer(pageNum, tid);
        this.storeCache.put(value, ptr);
        return ptr;
    }

    private void saveFreeList(@Nonnull FreeList freeList, @Nullable FreeList.FreeSpace free, @Nonnull DataPage dataPage) {
        BFileHeader fh = this.getFileHeader();
        int leftFree = fh.getWorkSize() - dataPage.getTotalDataLen();
        if (free != null) {
            free.setFree(leftFree);
            if (leftFree < 64) {
                freeList.remove(free);
            }
        } else if (leftFree >= 64) {
            FreeList.FreeSpace newFree = new FreeList.FreeSpace(dataPage.getPageNum(), leftFree);
            freeList.add(newFree);
        }
    }

    public synchronized byte[][] remove(Value key) throws BTreeException {
        long ptr;
        ArrayList<byte[]> list = new ArrayList<byte[]>(4);
        while ((ptr = this.findValue(key)) != -1L) {
            byte[] v = this.removeValue(ptr);
            if (v != null) {
                this.storeCache.remove(new Value(v));
                list.add(v);
            }
            super.removeValue(key, ptr);
        }
        if (list.isEmpty()) {
            return null;
        }
        byte[][] ary = new byte[list.size()][];
        return (byte[][])list.toArray((T[])ary);
    }

    protected final byte[] removeValue(long ptr) throws BTreeException {
        long pageNum = BTreeIndex.getPageNumFromPointer(ptr);
        DataPage dataPage = this.getDataPage(pageNum);
        int tidx = BTreeIndex.getTidFromPointer(ptr);
        byte[] b = dataPage.remove(tidx);
        return b;
    }

    private DataPage createDataPage() throws BTreeException {
        Paged.Page p = this.getFreePage();
        DataPage dataPage = new DataPage(p);
        this.dataCache.put(p.getPageNum(), dataPage);
        return dataPage;
    }

    private DataPage getDataPage(long pageNum) throws BTreeException {
        DataPage dataPage = (DataPage)this.dataCache.get(pageNum);
        if (dataPage == null) {
            Paged.Page p = this.getPage(pageNum);
            dataPage = new DataPage(p);
            try {
                dataPage.read();
            }
            catch (IOException e) {
                throw new BTreeException("failed to read page#" + pageNum, e);
            }
            this.dataCache.put(pageNum, dataPage);
        }
        return dataPage;
    }

    private static long createPointer(long pageNum, int tid) {
        if (pageNum > 0x7FFFFFFFFFFFL) {
            throw new IllegalArgumentException("Unexpected pageNumber that exceeds system limit: " + pageNum);
        }
        if (tid > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal idx that exceeds system limit: " + tid);
        }
        return (long)tid | (pageNum & 0xFFFFFFFFFFFFL) << 16;
    }

    private static long getPageNumFromPointer(long ptr) {
        return ptr >>> 16;
    }

    private static int getTidFromPointer(long ptr) {
        return (int)(ptr & 0xFFFFL);
    }

    @Override
    public void flush() throws BTreeException {
        this.flush(true, false);
    }

    @Override
    public synchronized void flush(boolean purge, boolean clear) throws BTreeException {
        if (purge) {
            for (LongHash.BucketEntry e : this.dataCache) {
                DataPage dataPage = (DataPage)e.getValue();
                dataPage.write();
            }
        }
        if (clear) {
            this.dataCache.clear();
        }
        super.flush(purge, clear);
    }

    private static final class Synchronizer
    implements LongHash.Cleaner<DataPage> {
        @Override
        public void cleanup(long key, DataPage dataPage) {
            try {
                dataPage.write();
            }
            catch (BTreeException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private final class BFileCallback
    implements BTreeCallback {
        final BTreeCallback handler;

        public BFileCallback(BTreeCallback handler) {
            this.handler = handler;
        }

        @Override
        public boolean indexInfo(Value key, long pointer) {
            byte[] tuple;
            try {
                tuple = BTreeIndex.this.retrieveTuple(pointer);
            }
            catch (BTreeException e) {
                throw new IllegalStateException(e);
            }
            return this.handler.indexInfo(key, tuple);
        }

        @Override
        public boolean indexInfo(Value key, byte[] value) {
            throw new UnsupportedOperationException();
        }
    }

    private final class BFilePageHeader
    extends BTree.BTreePageHeader {
        private int tupleCount;

        public BFilePageHeader() {
            super(BTreeIndex.this);
            this.tupleCount = 0;
        }

        public int getTupleCount() {
            return this.tupleCount;
        }

        public int incrTupleCount() {
            return this.tupleCount++;
        }

        public int decrTupleCount() {
            return this.tupleCount--;
        }

        @Override
        public void read(ByteBuffer buf) {
            super.read(buf);
            this.tupleCount = buf.getInt();
        }

        @Override
        public void write(ByteBuffer buf) {
            super.write(buf);
            buf.putInt(this.tupleCount);
        }
    }

    protected final class BFileHeader
    extends BTree.BTreeFileHeader {
        private final FreeList freeList;
        private boolean multiValue;

        public BFileHeader(int pageSize) {
            super(BTreeIndex.this, pageSize);
            this.freeList = new FreeList(128);
            this.multiValue = false;
        }

        public FreeList getFreeList() {
            return this.freeList;
        }

        public void setMultiValue(boolean multi) {
            this.multiValue = multi;
        }

        @Override
        public void read(RandomAccessFile raf) throws IOException {
            super.read(raf);
            this.multiValue = raf.readBoolean();
            this.freeList.read(raf);
        }

        @Override
        public void write(RandomAccessFile raf) throws IOException {
            super.write(raf);
            raf.writeBoolean(this.multiValue);
            this.freeList.write(raf);
        }
    }

    private final class DataPage
    implements Comparable<DataPage> {
        private final Paged.Page page;
        private final BFilePageHeader ph;
        private final List<byte[]> tuples = new ArrayList<byte[]>(12);
        private int totalDataLen = 0;
        private boolean loaded = false;
        private boolean dirty = false;

        public DataPage(Paged.Page page) {
            this.page = page;
            this.ph = (BFilePageHeader)page.getPageHeader();
            this.ph.setStatus((byte)10);
        }

        public long getPageNum() {
            return this.page.getPageNum();
        }

        public int getTotalDataLen() {
            return this.totalDataLen;
        }

        public int add(Value value) {
            int idx = this.tuples.size();
            if (idx > Short.MAX_VALUE) {
                throw new IllegalStateException("blocks length exceeds limit: " + idx);
            }
            byte[] tuple = value.getData();
            this.tuples.add(tuple);
            this.ph.incrTupleCount();
            this.totalDataLen += tuple.length + 4;
            this.setDirty();
            return idx;
        }

        public void set(int tidx, Value value) {
            if (tidx >= this.tuples.size()) {
                throw new IllegalStateException("Illegal tid for DataPage#" + this.page.getPageNum() + ": " + tidx);
            }
            byte[] tuple = value.getData();
            byte[] oldTuple = this.tuples.set(tidx, tuple);
            if (oldTuple != null) {
                int diff = tuple.length - oldTuple.length;
                this.totalDataLen += diff;
            }
            this.setDirty();
        }

        public byte[] remove(int tidx) throws BTreeException {
            int size = this.tuples.size();
            if (tidx >= size) {
                throw new IllegalStateException("Index out of range: " + tidx);
            }
            byte[] tuple = this.tuples.get(tidx);
            this.dirty = true;
            if (this.ph.decrTupleCount() == 0) {
                BTreeIndex.this.dataCache.remove(this.page.getPageNum());
                BTreeIndex.this.unlinkPages(this.page);
            }
            return tuple;
        }

        private void setDirty() {
            this.dirty = true;
            BTreeIndex.this.dataCache.put(this.page.getPageNum(), this);
        }

        @Nullable
        public byte[] get(int tidx) {
            if (tidx >= this.tuples.size()) {
                return null;
            }
            return this.tuples.get(tidx);
        }

        public void read() throws BTreeException, IOException {
            if (this.loaded) {
                return;
            }
            int tupleCount = this.ph.getTupleCount();
            if (tupleCount == 0) {
                return;
            }
            Value v = BTreeIndex.this.readValue(this.page);
            DataInputStream in = new DataInputStream(v.getInputStream());
            for (int i = 0; i < tupleCount; ++i) {
                int len = in.readInt();
                byte[] tuple = new byte[len];
                in.read(tuple);
                this.tuples.add(tuple);
            }
            if (in.available() > 0) {
                throw new IllegalStateException(in.available() + " bytes left");
            }
            this.totalDataLen = v.getLength();
            this.loaded = true;
        }

        public void write() throws BTreeException {
            if (!this.dirty) {
                return;
            }
            if (this.totalDataLen == 0) {
                return;
            }
            byte[] dest = new byte[this.totalDataLen];
            int pos = 0;
            for (byte[] tuple : this.tuples) {
                assert (tuple != null);
                int len = tuple.length;
                Primitives.putInt(dest, pos, len);
                System.arraycopy(tuple, 0, dest, pos += 4, len);
                pos += len;
            }
            if (pos != this.totalDataLen) {
                throw new IllegalStateException("writes = " + pos + ", but totalDataLen = " + this.totalDataLen);
            }
            BTreeIndex.this.writeValue(this.page, new Value(dest));
            this.dirty = false;
        }

        @Override
        public int compareTo(DataPage other) {
            return this.page.compareTo(other.page);
        }
    }
}

