/*
 * Decompiled with CFR 0.152.
 */
package btree4j;

import btree4j.BTreeCallback;
import btree4j.BTreeException;
import btree4j.BTreeIndex;
import btree4j.Value;
import btree4j.utils.collections.longs.LongArrayList;
import btree4j.utils.collections.longs.LongHash;
import btree4j.utils.lang.Primitives;
import btree4j.utils.lang.PrintUtils;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BTreeIndexDup
extends BTreeIndex {
    private static final Log LOG = LogFactory.getLog(BTreeIndexDup.class);
    private final LongHash.LongLRUMap<MultiPtrs> ptrsCache = new LongHash.LongLRUMap(512);

    public BTreeIndexDup(File file) {
        super(file, false);
        BTreeIndex.BFileHeader fh = this.getFileHeader();
        fh.setMultiValue(true);
    }

    public BTreeIndexDup(File file, int pageSize, int idxCaches, int dataCaches) {
        super(file, pageSize, idxCaches, dataCaches, false);
        BTreeIndex.BFileHeader fh = this.getFileHeader();
        fh.setMultiValue(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long addValue(Value key, Value value) throws BTreeException {
        long valuePtr = this.storeValue(value);
        long ptr = this.findValue(key);
        if (ptr != -1L) {
            MultiPtrs ptrs;
            LongHash.LongLRUMap<MultiPtrs> longLRUMap = this.ptrsCache;
            synchronized (longLRUMap) {
                ptrs = (MultiPtrs)this.ptrsCache.get(ptr);
                if (ptrs == null) {
                    byte[] ptrTuple = this.retrieveTuple(ptr);
                    ptrs = MultiPtrs.readFrom(ptrTuple);
                    this.ptrsCache.put(ptr, ptrs);
                }
            }
            ptrs.addPointer(valuePtr);
            this.updateValue(ptr, ptrs);
            return ptr;
        }
        MultiPtrs ptrs = new MultiPtrs(valuePtr);
        long newPtr = this.storeValue(ptrs);
        this.addValue(key, newPtr);
        LongHash.LongLRUMap<MultiPtrs> longLRUMap = this.ptrsCache;
        synchronized (longLRUMap) {
            this.ptrsCache.put(newPtr, ptrs);
        }
        return newPtr;
    }

    @Override
    protected BTreeCallback getHandler(BTreeCallback handler) {
        return new MultiValuesCallback(handler);
    }

    static final class MultiPtrs
    extends Value {
        static final int HEADER_LENGTH = 8;
        private LongArrayList _ptrs;
        private int _used;
        private int _free;

        public MultiPtrs() {
        }

        public MultiPtrs(long ptr) {
            super(MultiPtrs.initData(ptr));
            this._ptrs = new LongArrayList(4);
            this._ptrs.add(ptr);
            this._used = 1;
            this._free = 3;
        }

        private MultiPtrs(byte[] b, long[] ptrs, int used, int free) {
            super(b);
            this._ptrs = new LongArrayList(ptrs, used);
            this._used = used;
            this._free = free;
        }

        public LongArrayList getPointers() {
            return this._ptrs;
        }

        public void addPointer(long ptr) {
            byte[] oldData = this._data;
            int offset = 8 + (this._used << 3);
            this._ptrs.add(ptr);
            ++this._used;
            if (this._free-- > 0) {
                Primitives.putInt(oldData, 0, this._used);
                Primitives.putInt(oldData, 4, this._free);
                Primitives.putLong(oldData, offset, ptr);
            } else {
                this._free = this._used;
                int newLen = 8 + (this._used << 4);
                byte[] newData = new byte[newLen];
                System.arraycopy(oldData, 0, newData, 0, oldData.length);
                Primitives.putInt(newData, 0, this._used);
                Primitives.putInt(newData, 4, this._free);
                Primitives.putLong(newData, offset, ptr);
                this._data = newData;
                this._pos = 0;
                this._len = newLen;
            }
        }

        private static byte[] initData(long ptr) {
            byte[] b = new byte[40];
            Primitives.putInt(b, 0, 1);
            Primitives.putInt(b, 4, 3);
            Primitives.putLong(b, 8, ptr);
            return b;
        }

        public static MultiPtrs readFrom(byte[] b) {
            int used = Primitives.getInt(b, 0);
            int free = Primitives.getInt(b, 4);
            long[] ptrs = new long[used * 3 / 2];
            int i = 0;
            int idx = 8;
            while (i < used) {
                ptrs[i] = Primitives.getLong(b, idx);
                ++i;
                idx += 8;
            }
            return new MultiPtrs(b, ptrs, used, free);
        }
    }

    private final class MultiValuesCallback
    implements BTreeCallback {
        final BTreeCallback handler;

        public MultiValuesCallback(BTreeCallback handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean indexInfo(Value key, long pointer) {
            MultiPtrs ptrs;
            LongHash.LongLRUMap longLRUMap = BTreeIndexDup.this.ptrsCache;
            synchronized (longLRUMap) {
                ptrs = (MultiPtrs)BTreeIndexDup.this.ptrsCache.get(pointer);
                if (ptrs == null) {
                    byte[] ptrTuple;
                    try {
                        ptrTuple = BTreeIndexDup.this.retrieveTuple(pointer);
                    }
                    catch (BTreeException e) {
                        throw new IllegalStateException(e);
                    }
                    ptrs = MultiPtrs.readFrom(ptrTuple);
                }
                BTreeIndexDup.this.ptrsCache.put(pointer, ptrs);
            }
            LongArrayList lptrs = ptrs.getPointers();
            int size = lptrs.size();
            for (int i = 0; i < size; ++i) {
                byte[] value;
                long lptr = lptrs.get(i);
                try {
                    value = BTreeIndexDup.this.retrieveTuple(lptr);
                }
                catch (BTreeException e) {
                    LOG.error((Object)PrintUtils.prettyPrintStackTrace(e));
                    throw new IllegalStateException(e);
                }
                if (this.handler.indexInfo(key, value)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean indexInfo(Value key, byte[] value) {
            throw new UnsupportedOperationException();
        }
    }
}

