/*
 * Decompiled with CFR 0.152.
 */
package btree4j;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class FreeList {
    public static final int MAX_FREE_LIST_LENGTH = 128;
    private FreeSpace header = null;
    private FreeSpace last = null;
    private int size = 0;
    private final int maxFrees;

    public FreeList() {
        this(128);
    }

    public FreeList(int frees) {
        this.maxFrees = frees;
    }

    public void add(FreeSpace space) {
        if (this.header == null) {
            this.header = space;
            this.last = space;
        } else {
            this.last.next = space;
            space.prev = this.last;
            this.last = space;
        }
        ++this.size;
    }

    public void remove(FreeSpace space) {
        if (space.prev == null) {
            if (space.next != null) {
                space.next.prev = null;
                this.header = space.next;
            } else {
                this.header = null;
                this.last = null;
            }
        } else {
            space.prev.next = space.next;
            if (space.next != null) {
                space.next.prev = space.prev;
            } else {
                this.last = space.prev;
            }
        }
        --this.size;
    }

    public FreeSpace retrieve(int required) {
        FreeSpace next = this.header;
        FreeSpace found = null;
        while (next != null) {
            if (next.free >= required) {
                if (found == null) {
                    found = next;
                } else if (next.free < found.free) {
                    found = next;
                }
            }
            next = next.next;
        }
        return found;
    }

    public FreeSpace find(long pageNum) {
        FreeSpace next = this.header;
        while (next != null) {
            if (next.page == pageNum) {
                return next;
            }
            next = next.next;
        }
        return null;
    }

    public void write(DataOutput out) throws IOException {
        int skip = 0;
        if (this.size > this.maxFrees) {
            skip = this.size - this.maxFrees;
        }
        int outSize = this.size - skip;
        out.writeInt(outSize);
        FreeSpace next = this.header;
        while (next != null) {
            if (skip == 0) {
                out.writeLong(next.page);
                out.writeInt(next.free);
            } else {
                --skip;
            }
            next = next.next;
        }
    }

    public void read(DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            long page = in.readLong();
            int free = in.readInt();
            this.add(new FreeSpace(page, free));
        }
    }

    public static final class FreeSpace {
        public static final int MIN_LEFT_FREE = 64;
        private final long page;
        private int free = 0;
        private FreeSpace prev = null;
        private FreeSpace next = null;

        public FreeSpace(long page, int free) {
            this.page = page;
            this.free = free;
        }

        public long getPage() {
            return this.page;
        }

        public int getFree() {
            return this.free;
        }

        public void setFree(int free) {
            this.free = free;
        }
    }
}

