/*
 * Decompiled with CFR 0.152.
 */
package btree4j;

import btree4j.BTreeException;
import btree4j.Value;
import btree4j.utils.io.FastMultiByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@NotThreadSafe
public abstract class Paged {
    private static final Log LOG = LogFactory.getLog(Paged.class);
    public static final int DEFAULT_PAGESIZE = 4096;
    protected static final byte UNUSED = 0;
    protected static final byte OVERFLOW = 126;
    protected static final int NO_PAGE = -1;
    @Nonnull
    private final Map<Long, Page> _pages = new WeakHashMap<Long, Page>(64);
    @Nonnull
    private final FileHeader _fileHeader;
    @Nonnull
    protected final File _file;
    private boolean _opened = false;
    private RandomAccessFile _raf = null;
    private FileChannel _fc = null;

    public Paged(@Nonnull File file) {
        this(file, 4096);
    }

    public Paged(@Nonnull File file, @Nonnegative int pageSize) {
        this._fileHeader = this.createFileHeader(pageSize);
        this._file = file;
    }

    @Nonnull
    public File getFile() {
        return this._file;
    }

    public boolean create() throws BTreeException {
        return this.create(true);
    }

    public boolean create(boolean close) throws BTreeException {
        this.ensureResourceOpen();
        try {
            this._fileHeader.write();
        }
        catch (IOException e) {
            throw new BTreeException(e);
        }
        if (close) {
            this.close();
        } else {
            this._opened = true;
        }
        return true;
    }

    public boolean open() throws BTreeException {
        this.ensureResourceOpen();
        if (this.exists()) {
            try {
                this._fileHeader.read();
            }
            catch (IOException e) {
                throw new BTreeException(e);
            }
            this._opened = true;
            return true;
        }
        this._opened = false;
        return false;
    }

    @Nonnull
    protected final RandomAccessFile ensureResourceOpen() throws BTreeException {
        if (this._raf == null) {
            try {
                this._raf = new RandomAccessFile(this._file, "rw");
            }
            catch (FileNotFoundException e) {
                throw new BTreeException(e);
            }
        }
        if (this._fc == null) {
            this._fc = this._raf.getChannel();
        }
        return this._raf;
    }

    public boolean close() throws BTreeException {
        if (this._opened) {
            this._opened = false;
            try {
                this._raf.close();
                this._fc.close();
            }
            catch (IOException e) {
                throw new BTreeException(e);
            }
            this.reset();
            return true;
        }
        return false;
    }

    protected final void checkOpened() throws BTreeException {
        if (!this._opened) {
            throw new BTreeException("Not opened");
        }
    }

    private final void reset() {
        this._raf = null;
        this._fc = null;
    }

    public boolean drop() throws BTreeException {
        this.close();
        if (this.exists()) {
            return this.getFile().delete();
        }
        return true;
    }

    public final boolean exists() {
        return this._file.exists();
    }

    public void flush() throws BTreeException {
        try {
            if (this._fileHeader._fhDirty) {
                this._fileHeader.write();
            }
            this._fc.force(true);
        }
        catch (IOException e) {
            throw new BTreeException(e);
        }
    }

    @Nonnull
    protected abstract FileHeader createFileHeader(@Nonnegative int var1);

    @Nonnull
    protected abstract PageHeader createPageHeader();

    @Nonnull
    protected final Page getPage(long pageNum) throws BTreeException {
        Page p = this._pages.get(pageNum);
        if (p == null) {
            p = new Page(pageNum);
            try {
                p.read();
            }
            catch (IOException e) {
                throw new BTreeException(e);
            }
            this._pages.put(pageNum, p);
        }
        return p;
    }

    @Nonnull
    protected final Page getFreePage() throws BTreeException {
        Page p = null;
        if (this._fileHeader._firstFreePage != -1L) {
            p = this.getPage(this._fileHeader._firstFreePage);
            this._fileHeader.setFirstFreePage(p._pageHeader._nextPage);
            if (this._fileHeader._firstFreePage == -1L) {
                this._fileHeader.setLastFreePage(-1L);
            }
        }
        if (p == null) {
            p = this.getPage(this._fileHeader.incrTotalPageCount());
        }
        p.initPage();
        return p;
    }

    protected final void unlinkPages(long pageNum) throws BTreeException {
        this.unlinkPages(this.getPage(pageNum));
    }

    protected final void unlinkPages(@Nonnull Page page) throws BTreeException {
        Page nextPage = page;
        if (nextPage != null) {
            long firstPage = nextPage._pageNum;
            long nextPageNum = nextPage.getPageHeader().getNextPage();
            while (nextPageNum != -1L) {
                nextPage = this.getPage(nextPageNum);
                nextPageNum = nextPage.getPageHeader().getNextPage();
            }
            long lastPage = nextPage.getPageNum();
            if (this._fileHeader._lastFreePage != -1L) {
                Page p = this.getPage(this._fileHeader._lastFreePage);
                p._pageHeader.setNextPage(firstPage);
                p.write();
            }
            if (this._fileHeader._firstFreePage == -1L) {
                this._fileHeader.setFirstFreePage(firstPage);
            }
            this._fileHeader.setLastFreePage(lastPage);
        }
    }

    public final void writeValue(@Nonnull Page page, @Nonnull Value value) throws BTreeException {
        InputStream is = value.getInputStream();
        PageHeader hdr = page.getPageHeader();
        hdr.setRecordLength(value.getLength());
        try {
            page.readData(is);
        }
        catch (IOException e) {
            throw new BTreeException(e);
        }
        Page lastPage = page;
        while (true) {
            int available;
            try {
                available = is.available();
            }
            catch (IOException e) {
                throw new BTreeException(e);
            }
            if (available == 0) break;
            LOG.debug((Object)"page overflowed");
            Page lpage = lastPage;
            PageHeader lhdr = hdr;
            long np = lhdr.getNextPage();
            if (np != -1L) {
                lastPage = this.getPage(np);
            } else {
                lastPage = this.getFreePage();
                lhdr.setNextPage(lastPage.getPageNum());
            }
            hdr = lastPage.getPageHeader();
            hdr.setStatus((byte)126);
            try {
                lastPage.readData(is);
            }
            catch (IOException e) {
                throw new BTreeException(e);
            }
            lpage.write();
        }
        long np = hdr.getNextPage();
        if (np != -1L) {
            this.unlinkPages(np);
        }
        hdr.setNextPage(-1L);
        lastPage.write();
    }

    public final void writeValue(long page, @Nonnull Value value) throws BTreeException {
        this.writeValue(this.getPage(page), value);
    }

    @Deprecated
    public final long writeValue(@Nonnull Value value) throws BTreeException {
        Page p = this.getFreePage();
        this.writeValue(p, value);
        return p.getPageNum();
    }

    @Nonnull
    public final Value readValue(@Nonnull Page page) throws BTreeException {
        PageHeader sph = page.getPageHeader();
        FastMultiByteArrayOutputStream bos = new FastMultiByteArrayOutputStream(sph.getRecordLength());
        Page p = page;
        while (true) {
            try {
                p.writeData(bos);
            }
            catch (IOException e) {
                throw new BTreeException(e);
            }
            PageHeader ph = p.getPageHeader();
            long nextPage = ph.getNextPage();
            if (nextPage == -1L) break;
            p = this.getPage(nextPage);
        }
        return new Value(bos.toByteArray());
    }

    @Deprecated
    @Nonnull
    public final Value readValue(long page) throws BTreeException {
        return this.readValue(this.getPage(page));
    }

    @Nonnull
    protected FileHeader getFileHeader() {
        return this._fileHeader;
    }

    public final class Page
    implements Comparable<Page> {
        private final long _pageNum;
        private final PageHeader _pageHeader;
        private final long _pageOffset;
        private ByteBuffer _pageData = null;
        private int _dataPos;

        public Page(long pageNum) {
            this._pageNum = pageNum;
            this._pageHeader = Paged.this.createPageHeader();
            this._pageOffset = (long)Paged.this._fileHeader._fhSize + pageNum * (long)Paged.this._fileHeader._pageSize;
        }

        public synchronized void read() throws IOException {
            if (this._pageData == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("read in page#" + this._pageNum + " from page offset " + this._pageOffset));
                }
                byte[] buf = new byte[Paged.this._fileHeader._pageSize];
                Paged.this._raf.seek(this._pageOffset);
                Paged.this._raf.read(buf);
                this._pageData = ByteBuffer.wrap(buf);
                this._pageHeader.read(this._pageData);
                this._dataPos = Paged.this._fileHeader._pageHeaderSize;
            }
        }

        public synchronized void write() throws BTreeException {
            this._pageData.rewind();
            this._pageHeader.write(this._pageData);
            try {
                Paged.this._raf.seek(this._pageOffset);
                Paged.this._raf.write(this._pageData.array());
            }
            catch (IOException e) {
                throw new BTreeException(e);
            }
        }

        public void flush() throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("write out page#" + this._pageNum + " to page offset " + this._pageOffset));
            }
            Paged.this._raf.seek(this._pageOffset);
            Paged.this._raf.write(this._pageData.array());
        }

        public void writeData(OutputStream os) throws IOException {
            if (this._pageHeader._dataLen > 0) {
                byte[] b = new byte[this._pageHeader._dataLen];
                this._pageData.position(this._dataPos);
                this._pageData.get(b);
                os.write(b);
            }
        }

        public void readData(InputStream is) throws IOException {
            int datalen;
            int avail = is.available();
            if (avail < (datalen = Paged.this._fileHeader._workSize)) {
                datalen = avail;
            }
            this._pageHeader.setDataLength(datalen);
            if (datalen > 0) {
                byte[] b = new byte[datalen];
                is.read(b);
                ((Buffer)this._pageData).position(this.getDataPos());
                this._pageData.put(b);
            }
        }

        public PageHeader getPageHeader() {
            return this._pageHeader;
        }

        public long getPageNum() {
            return this._pageNum;
        }

        private int getDataPos() {
            return this._dataPos;
        }

        protected void initPage() {
            this._pageHeader.setNextPage(-1L);
            this._pageHeader.setStatus((byte)0);
        }

        @Override
        public int compareTo(Page other) {
            return (int)(this._pageNum - other._pageNum);
        }

        public String toString() {
            return "page#" + this._pageNum;
        }
    }

    public static abstract class PageHeader {
        public static final int DEFAULT_PAGE_HEADER_SIZE = 127;
        private byte _status = 0;
        private int _dataLen;
        private int _recordLen;
        private long _nextPage = -1L;

        public PageHeader() {
        }

        public PageHeader(ByteBuffer buf) {
            this.read(buf);
        }

        public void read(ByteBuffer buf) {
            this._status = buf.get();
            if (this._status == 0) {
                return;
            }
            this._dataLen = buf.getInt();
            this._recordLen = buf.getInt();
            this._nextPage = buf.getLong();
        }

        public void write(ByteBuffer buf) {
            buf.put(this._status);
            buf.putInt(this._dataLen);
            buf.putInt(this._recordLen);
            buf.putLong(this._nextPage);
        }

        public final void setStatus(byte status) {
            this._status = status;
        }

        public final byte getStatus() {
            return this._status;
        }

        public final void setNextPage(long nextPage) {
            this._nextPage = nextPage;
        }

        public final long getNextPage() {
            return this._nextPage;
        }

        public final void setDataLength(int dataLen) {
            this._dataLen = dataLen;
        }

        public final int getDataLength() {
            return this._dataLen;
        }

        public final void setRecordLength(int length) {
            this._recordLen = length;
        }

        public final int getRecordLength() {
            return this._recordLen;
        }
    }

    public abstract class FileHeader {
        private boolean _fhDirty = true;
        private int _workSize;
        private short _fhSize;
        private int _pageSize;
        private long _totalPageCount;
        private long _firstFreePage = -1L;
        private long _lastFreePage = -1L;
        private byte _pageHeaderSize = (byte)127;

        public FileHeader(int pageSize) {
            this._pageSize = pageSize;
            this._fhSize = (short)4096;
            this._workSize = this.calculateWorkSize();
        }

        public final void write() throws IOException {
            if (!this._fhDirty) {
                return;
            }
            Paged.this._raf.seek(0L);
            this.write(Paged.this._raf);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"wrote file header");
            }
            this._fhDirty = false;
        }

        protected void write(RandomAccessFile raf) throws IOException {
            raf.writeShort(this._fhSize);
            raf.writeInt(this._pageSize);
            raf.writeLong(this._totalPageCount);
            raf.writeLong(this._firstFreePage);
            raf.writeLong(this._lastFreePage);
            raf.writeByte(this._pageHeaderSize);
        }

        public final void read() throws IOException {
            Paged.this._raf.seek(0L);
            this.read(Paged.this._raf);
            this._workSize = this.calculateWorkSize();
        }

        protected void read(RandomAccessFile raf) throws IOException {
            this._fhSize = raf.readShort();
            this._pageSize = raf.readInt();
            this._totalPageCount = raf.readLong();
            this._firstFreePage = raf.readLong();
            this._lastFreePage = raf.readLong();
            this._pageHeaderSize = raf.readByte();
        }

        public final void setFirstFreePage(long page) {
            this._firstFreePage = page;
            this._fhDirty = true;
        }

        public long getFirstFreePage() {
            return this._firstFreePage;
        }

        public final void setLastFreePage(long page) {
            this._lastFreePage = page;
            this._fhDirty = true;
        }

        public long getLastFreePage() {
            return this._lastFreePage;
        }

        public final long incrTotalPageCount() {
            this._fhDirty = true;
            return this._totalPageCount++;
        }

        public final void setDirty(boolean dirty) {
            this._fhDirty = dirty;
        }

        public void setTotalPageCount(long pageCount) {
            this._fhDirty = true;
            this._totalPageCount = pageCount;
        }

        public final long getTotalPageCount() {
            return this._totalPageCount;
        }

        public final int getPageSize() {
            return this._pageSize;
        }

        public final int getWorkSize() {
            return this._workSize;
        }

        private final int calculateWorkSize() {
            return this._pageSize - this._pageHeaderSize;
        }
    }
}

