/*
 * Decompiled with CFR 0.152.
 */
package btree4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Settings {
    private static final Log LOG = LogFactory.getLog(Settings.class);
    public static final String XBIRD_VERSION = "1.0";
    private static final String PROPERTY_FILE_NAME = "btree4j.properties";
    public static final boolean isLoggingEnabled = true;
    private static final Properties properties = new Properties();

    private Settings() {
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String get(String key) {
        return properties.getProperty(key);
    }

    public static String get(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static String getThroughSystemProperty(String key) {
        String v = System.getProperty(key);
        return v == null ? properties.getProperty(key) : v;
    }

    public static void put(String key, String value) {
        properties.put(key, value);
    }

    public static void putAll(Properties props) {
        properties.putAll((Map<?, ?>)props);
    }

    static {
        String userDir = System.getProperty("user.home");
        try {
            InputStream is = Settings.class.getResourceAsStream(PROPERTY_FILE_NAME);
            properties.load(is);
            File propFile = new File(userDir, PROPERTY_FILE_NAME);
            if (propFile.exists()) {
                properties.load(new FileInputStream(propFile));
                LOG.info((Object)("Loaded btree4j.properties in: " + propFile.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception caused while loading user provided properties file.", e);
        }
    }
}

