/*
 * Decompiled with CFR 0.152.
 */
package btree4j;

import btree4j.utils.io.FastByteArrayInputStream;
import btree4j.utils.lang.HashUtils;
import btree4j.utils.lang.Primitives;
import btree4j.utils.lang.StringUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class Value
implements Comparable<Value>,
Cloneable,
Externalizable {
    private static final long serialVersionUID = -8649821046511401335L;
    private int _hash = -1;
    protected byte[] _data;
    protected int _pos;
    protected int _len;
    private transient int refcnt = 0;

    public Value() {
    }

    public Value(String data) {
        this(StringUtils.getBytes(data));
    }

    public Value(byte[] data) {
        this(data, 0, data.length);
    }

    public Value(byte[] data, int len) {
        this(data, 0, len);
    }

    public Value(byte[] data, int pos, int len) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this._data = data;
        this._pos = pos;
        this._len = len;
    }

    public Value(long data) {
        this(Primitives.toBytes(data));
    }

    public byte[] getData() {
        if (this._len != this._data.length) {
            byte[] b = new byte[this._len];
            System.arraycopy(this._data, this._pos, b, 0, this._len);
            return b;
        }
        return this._data;
    }

    public int getPosition() {
        return this._pos;
    }

    public final int getLength() {
        return this._len;
    }

    public final InputStream getInputStream() {
        return new FastByteArrayInputStream(this._data, this._pos, this._len);
    }

    public final void writeTo(OutputStream out) throws IOException {
        out.write(this._data, this._pos, this._len);
    }

    public final void writeTo(OutputStream out, int offset, int len) throws IOException {
        out.write(this._data, this._pos + offset, len);
    }

    public final void copyTo(byte[] tdata, int tpos) {
        System.arraycopy(this._data, this._pos, tdata, tpos, this._len);
    }

    public final void copyTo(byte[] toValue, int toPos, int len) {
        System.arraycopy(this._data, this._pos, toValue, toPos, len);
    }

    @Override
    public int compareTo(Value value) {
        byte[] ddata = value._data;
        int dpos = value._pos;
        int dlen = value._len;
        int stop = this._len > dlen ? dlen : this._len;
        for (int i = 0; i < stop; ++i) {
            byte b1 = this._data[this._pos + i];
            byte b2 = ddata[dpos + i];
            if (b1 == b2) continue;
            int s1 = b1 >>> 0;
            int s2 = b2 >>> 0;
            return s1 > s2 ? i + 1 : -(i + 1);
        }
        if (this._len == dlen) {
            return 0;
        }
        return this._len > dlen ? stop + 1 : -(stop + 1);
    }

    public boolean equals(Value value) {
        return this._len == value._len ? this.compareTo(value) == 0 : false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Value) {
            return this.equals((Value)obj);
        }
        return false;
    }

    public int hashCode() {
        int h;
        if (this._hash != -1) {
            return this._hash;
        }
        this._hash = h = HashUtils.hashCode(this._data, this._pos, this._len);
        return h;
    }

    public String toString() {
        char[] ch = Primitives.toChars(this._data, this._pos, this._len);
        return String.valueOf(ch);
    }

    public final boolean startsWith(Value value) {
        int vlen = value.getLength();
        if (this._len < vlen) {
            return false;
        }
        byte[] ddata = value.getData();
        int dpos = value.getPosition();
        for (int i = 0; i < vlen; ++i) {
            if (this._data[i + this._pos] == ddata[i + dpos]) continue;
            return false;
        }
        return true;
    }

    public Value clone() {
        return new Value(this._data, this._pos, this._len);
    }

    public final int incrRefCount() {
        return ++this.refcnt;
    }

    public final int decrRefCount() {
        return --this.refcnt;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._hash);
        out.writeInt(this._len);
        out.write(this._data, this._pos, this._len);
    }

    public int size() {
        return 8 + this._len;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this._hash = in.readInt();
        int len = in.readInt();
        byte[] b = new byte[len];
        in.read(b);
        this._data = b;
        this._pos = 0;
        this._len = len;
    }

    public static Value readObject(ObjectInput in) throws IOException {
        Value v = new Value();
        v.readExternal(in);
        return v;
    }
}

