/*
 * Decompiled with CFR 0.152.
 */
package btree4j.indexer;

import btree4j.BTree;
import btree4j.BTreeCallback;
import btree4j.BTreeException;
import btree4j.Value;
import btree4j.indexer.IndexMatch;
import btree4j.indexer.IndexQuery;
import btree4j.indexer.Indexer;
import java.io.File;

public class BTreeIndexer
implements Indexer {
    private static final int PAGE_SIZE = 4096;
    private static final int IN_MEMORY_PAGES = 1024;
    private static final int INDEX_BUILD_PAGES = 8192;
    private final String name;
    private final BTree btree;

    public BTreeIndexer(File file) {
        this(null, file);
    }

    public BTreeIndexer(String name, File file) {
        this(name, file, false);
    }

    public BTreeIndexer(String name, File file, boolean bulkBuild) {
        this.name = name;
        BTree tree = new BTree(file, 4096, bulkBuild ? 8192 : 1024, true);
        try {
            tree.init(bulkBuild);
        }
        catch (BTreeException e) {
            throw new IllegalStateException("failed on initializing b+-tree: " + file.getAbsolutePath(), e);
        }
        this.btree = tree;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long add(byte[] key, long value) throws BTreeException {
        return this.btree.addValue(new Value(key), value);
    }

    @Override
    public long remove(byte[] key) throws BTreeException {
        return this.btree.removeValue(new Value(key));
    }

    @Override
    public long remove(byte[] key, long value) throws BTreeException {
        return this.btree.removeValue(new Value(key));
    }

    @Override
    public IndexMatch find(IndexQuery cond) throws BTreeException {
        IndexMatch match = new IndexMatch(12);
        Callback callback = new Callback(match);
        this.btree.search(cond, callback);
        return match;
    }

    @Override
    public void flush(boolean close) throws BTreeException {
        this.btree.flush(true, true);
        if (close) {
            this.btree.close();
        }
    }

    @Override
    public void close() throws BTreeException {
        this.btree.close();
    }

    private static final class Callback
    implements BTreeCallback {
        private final IndexMatch match;

        public Callback(IndexMatch match) {
            this.match = match;
        }

        @Override
        public boolean indexInfo(Value value, long pointer) {
            this.match.add(value, pointer);
            return true;
        }

        @Override
        public boolean indexInfo(Value key, byte[] value) {
            throw new IllegalStateException();
        }
    }
}

