/*
 * Decompiled with CFR 0.152.
 */
package btree4j.indexer;

import btree4j.Value;
import btree4j.indexer.IndexQuery;
import java.util.Arrays;

public class BasicIndexQuery
implements IndexQuery {
    public static final int ANY = 0;
    public static final int EQ = 1;
    public static final int NE = -1;
    public static final int GT = 2;
    public static final int LE = -2;
    public static final int LT = 3;
    public static final int GE = -3;
    public static final int BW = 4;
    public static final int NBW = -4;
    public static final int BWX = 5;
    public static final int NBWX = -5;
    public static final int IN = 6;
    public static final int NOT_IN = -6;
    public static final int START_WITH = 7;
    public static final int NOT_START_WITH = -7;
    protected final int _operator;
    protected final Value[] _operands;

    public BasicIndexQuery(int op, Value ... operands) {
        this._operator = op;
        this._operands = operands;
    }

    @Override
    public int getOperator() {
        return this._operator;
    }

    @Override
    public Value[] getOperands() {
        return this._operands;
    }

    @Override
    public Value getOperand(int index) {
        assert (index >= 0) : index;
        assert (index < this._operands.length) : "operand[" + index + "] not found: " + this._operands;
        return this._operands[index];
    }

    @Override
    public boolean testValue(Value value) {
        switch (this._operator) {
            case 0: {
                return true;
            }
            case 1: {
                return value.equals(this._operands[0]);
            }
            case -1: {
                return !value.equals(this._operands[0]);
            }
            case 2: {
                return value.compareTo(this._operands[0]) > 0;
            }
            case -2: {
                return value.compareTo(this._operands[0]) <= 0;
            }
            case 3: {
                return value.compareTo(this._operands[0]) < 0;
            }
            case -3: {
                return value.compareTo(this._operands[0]) >= 0;
            }
            case 4: {
                return value.compareTo(this._operands[0]) >= 0 && value.compareTo(this._operands[1]) <= 0;
            }
            case -4: {
                return value.compareTo(this._operands[0]) <= 0 || value.compareTo(this._operands[1]) >= 0;
            }
            case 5: {
                return value.compareTo(this._operands[0]) > 0 && value.compareTo(this._operands[1]) < 0;
            }
            case -5: {
                return value.compareTo(this._operands[0]) < 0 || value.compareTo(this._operands[1]) > 0;
            }
            case 6: {
                return Arrays.binarySearch(this._operands, value) >= 0;
            }
            case -6: {
                return Arrays.binarySearch(this._operands, value) < 0;
            }
            case 7: {
                return value.startsWith(this._operands[0]);
            }
            case -7: {
                return !value.startsWith(this._operands[0]);
            }
        }
        throw new IllegalStateException("invalid operation : " + this._operator);
    }

    private static final Value calculateRightEdgeValue(Value v) {
        byte[] b = new byte[v.getLength() + 1];
        System.arraycopy(v.getData(), v.getPosition(), b, 0, b.length - 1);
        b[b.length - 1] = 127;
        Value v2 = new Value(b);
        return v2;
    }

    public static final class IndexConditionNSW
    extends BasicIndexQuery {
        public IndexConditionNSW(Value operand1) {
            super(-7, operand1, BasicIndexQuery.calculateRightEdgeValue(operand1));
        }

        @Override
        public int getOperator() {
            return -7;
        }

        @Override
        public boolean testValue(Value value) {
            return !value.startsWith(this._operands[0]);
        }
    }

    public static class IndexConditionSW
    extends BasicIndexQuery {
        public IndexConditionSW(Value operand1) {
            super(7, operand1, BasicIndexQuery.calculateRightEdgeValue(operand1));
        }

        @Override
        public int getOperator() {
            return 7;
        }

        @Override
        public boolean testValue(Value value) {
            return value.startsWith(this._operands[0]);
        }
    }

    public static final class IndexConditionNIN
    extends BasicIndexQuery {
        public IndexConditionNIN(Value[] operands) {
            super(-6, operands);
        }

        @Override
        public int getOperator() {
            return -6;
        }

        @Override
        public boolean testValue(Value value) {
            return Arrays.binarySearch(this._operands, value) < 0;
        }
    }

    public static final class IndexConditionIN
    extends BasicIndexQuery {
        public IndexConditionIN(Value[] operands) {
            super(6, operands);
        }

        @Override
        public int getOperator() {
            return 6;
        }

        @Override
        public boolean testValue(Value value) {
            return Arrays.binarySearch(this._operands, value) >= 0;
        }
    }

    public static final class IndexConditionNBWX
    extends BasicIndexQuery {
        public IndexConditionNBWX(Value operand1, Value operand2) {
            super(-5, operand1, operand2);
        }

        @Override
        public int getOperator() {
            return -5;
        }

        @Override
        public boolean testValue(Value value) {
            return value.compareTo(this._operands[0]) < 0 || value.compareTo(this._operands[1]) > 0;
        }
    }

    public static final class IndexConditionBWX
    extends BasicIndexQuery {
        public IndexConditionBWX(Value operand1, Value operand2) {
            super(5, operand1, operand2);
        }

        @Override
        public int getOperator() {
            return 5;
        }

        @Override
        public boolean testValue(Value value) {
            return value.compareTo(this._operands[0]) > 0 && value.compareTo(this._operands[1]) < 0;
        }
    }

    public static final class IndexConditionNBW
    extends BasicIndexQuery {
        public IndexConditionNBW(Value operand1, Value operand2) {
            super(-4, operand1, operand2);
        }

        @Override
        public int getOperator() {
            return -4;
        }

        @Override
        public boolean testValue(Value value) {
            return value.compareTo(this._operands[0]) <= 0 || value.compareTo(this._operands[1]) >= 0;
        }
    }

    public static final class IndexConditionBW
    extends BasicIndexQuery {
        public IndexConditionBW(Value operand1, Value operand2) {
            super(4, operand1, operand2);
        }

        @Override
        public int getOperator() {
            return 4;
        }

        @Override
        public boolean testValue(Value value) {
            return value.compareTo(this._operands[0]) >= 0 && value.compareTo(this._operands[1]) <= 0;
        }
    }

    public static final class IndexConditionGE
    extends BasicIndexQuery {
        public IndexConditionGE(Value operand) {
            super(-3, operand);
        }

        @Override
        public int getOperator() {
            return -3;
        }

        @Override
        public boolean testValue(Value value) {
            return value.compareTo(this._operands[0]) >= 0;
        }
    }

    public static final class IndexConditionLT
    extends BasicIndexQuery {
        public IndexConditionLT(Value operand) {
            super(3, operand);
        }

        @Override
        public int getOperator() {
            return 3;
        }

        @Override
        public boolean testValue(Value value) {
            return value.compareTo(this._operands[0]) < 0;
        }
    }

    public static final class IndexConditionLE
    extends BasicIndexQuery {
        public IndexConditionLE(Value operand) {
            super(-2, operand);
        }

        @Override
        public int getOperator() {
            return -2;
        }

        @Override
        public boolean testValue(Value value) {
            return value.compareTo(this._operands[0]) <= 0;
        }
    }

    public static final class IndexConditionGT
    extends BasicIndexQuery {
        public IndexConditionGT(Value operand) {
            super(2, operand);
        }

        @Override
        public int getOperator() {
            return 2;
        }

        @Override
        public boolean testValue(Value value) {
            return value.compareTo(this._operands[0]) > 0;
        }
    }

    public static final class IndexConditionNE
    extends BasicIndexQuery {
        public IndexConditionNE(Value operand) {
            super(-1, operand);
        }

        @Override
        public int getOperator() {
            return -1;
        }

        @Override
        public boolean testValue(Value value) {
            return !value.equals(this._operands[0]);
        }
    }

    public static final class IndexConditionEQ
    extends BasicIndexQuery {
        public IndexConditionEQ(Value operand) {
            super(1, operand);
        }

        @Override
        public int getOperator() {
            return 1;
        }

        @Override
        public boolean testValue(Value value) {
            return value.equals(this._operands[0]);
        }
    }

    public static final class IndexConditionANY
    extends BasicIndexQuery {
        public IndexConditionANY() {
            super(0, new Value[0]);
        }

        @Override
        public int getOperator() {
            return 0;
        }

        @Override
        public boolean testValue(Value value) {
            return true;
        }
    }
}

