/*
 * Decompiled with CFR 0.152.
 */
package btree4j.indexer;

import btree4j.Value;
import btree4j.indexer.BasicIndexQuery;
import btree4j.utils.collections.IntStack;
import btree4j.utils.io.FastMultiByteArrayOutputStream;
import btree4j.utils.lang.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public final class ByteLikeIndexQuery
extends BasicIndexQuery.IndexConditionSW {
    private static final int MATCH = 0;
    private static final int ANY = 1;
    private final byte anyPattern;
    private byte[][] _patterns;
    private int[] _types;

    public ByteLikeIndexQuery(Value prefix, byte[] suffix, byte any) {
        super(prefix);
        if (suffix == null) {
            throw new IllegalArgumentException("Illegal null suffix");
        }
        this.anyPattern = any;
        this.initPattern(suffix);
    }

    private void initPattern(byte[] p) {
        IntStack typeStack = new IntStack(12);
        ArrayList<byte[]> patternStack = new ArrayList<byte[]>();
        try (FastMultiByteArrayOutputStream pending = new FastMultiByteArrayOutputStream(32);){
            for (byte c : p) {
                if (c == this.anyPattern) {
                    int lastType;
                    if (!typeStack.isEmpty() && (lastType = typeStack.peek()) == this.anyPattern) continue;
                    if (pending.size() > 0) {
                        typeStack.push(0);
                        patternStack.add(pending.toByteArray());
                        pending.reset();
                    }
                    typeStack.push(1);
                    patternStack.add(null);
                    continue;
                }
                pending.write(c);
            }
            if (pending.size() > 0) {
                typeStack.push(0);
                patternStack.add(pending.toByteArray());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this._patterns = (byte[][])patternStack.toArray((T[])new byte[patternStack.size()][]);
        this._types = typeStack.toArray();
    }

    @Override
    public boolean testValue(Value value) {
        boolean sw = value.startsWith(this._operands[0]);
        if (!sw) {
            return false;
        }
        if (this._types.length == 0) {
            return true;
        }
        byte[] data = value.getData();
        int offset = this._operands[0].getLength();
        int length = data.length - offset;
        byte[] target = offset == 0 && length == data.length ? data : Arrays.copyOfRange(data, offset, offset + length);
        return ByteLikeIndexQuery.match(target, this._patterns, this._types, 0, 0);
    }

    private static boolean match(byte[] target, byte[][] verifyPatterns, int[] verifyType, int ti, int pi) {
        int round = verifyType.length;
        int tlimit = target.length;
        while (pi < round) {
            int type = verifyType[pi];
            switch (type) {
                case 0: {
                    byte[] ptn = verifyPatterns[pi];
                    int ptnlen = ptn.length;
                    if (ti + ptnlen > tlimit) {
                        return false;
                    }
                    for (int j = 0; j < ptnlen; ++j) {
                        if (target[ti++] == ptn[j]) continue;
                        return false;
                    }
                    break;
                }
                case 1: {
                    if (++pi >= round) {
                        return true;
                    }
                    while (ti < tlimit) {
                        if (ByteLikeIndexQuery.match(target, verifyPatterns, verifyType, ti, pi)) {
                            return true;
                        }
                        ++ti;
                    }
                    return false;
                }
                default: {
                    throw new IllegalStateException("Illegal type: " + type);
                }
            }
            ++pi;
        }
        return ti == tlimit;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("prefix: ");
        buf.append(this._operands[0].toString());
        buf.append(", suffix: ");
        for (int i = 0; i < this._types.length; ++i) {
            int type = this._types[i];
            if (type == 1) {
                buf.append('%');
                continue;
            }
            if (type == 0) {
                byte[] pattern = this._patterns[i];
                buf.append(StringUtils.encodeHex(pattern));
                continue;
            }
            throw new IllegalStateException("Unexpected type: " + type);
        }
        return buf.toString();
    }
}

