/*
 * Decompiled with CFR 0.152.
 */
package btree4j.indexer;

import btree4j.Value;
import java.util.Arrays;

public final class IndexMatch {
    private long[] entries;
    private int last;
    private transient long[] matchedCache = null;

    public IndexMatch(int expected) {
        this.entries = new long[expected];
        this.last = 0;
    }

    public void add(Value key, long entry) {
        this.ensureCapacity(this.last + 1);
        this.entries[this.last] = entry;
        ++this.last;
    }

    public int countMatched() {
        return this.last;
    }

    public long[] getMatchedSorted() {
        if (this.matchedCache != null) {
            return this.matchedCache;
        }
        Arrays.sort(this.entries, 0, this.last);
        long[] newArray = new long[this.last];
        System.arraycopy(this.entries, 0, newArray, 0, this.last);
        this.matchedCache = newArray;
        return this.matchedCache;
    }

    public long[] getMatchedUnsorted() {
        if (this.matchedCache != null) {
            return this.matchedCache;
        }
        if (this.entries.length == this.last) {
            this.matchedCache = this.entries;
            return this.entries;
        }
        long[] newArray = new long[this.last];
        System.arraycopy(this.entries, 0, newArray, 0, this.last);
        this.matchedCache = newArray;
        return this.matchedCache;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.entries.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity + oldCapacity / 2;
            }
            long[] newArray = new long[newCapacity];
            System.arraycopy(this.entries, 0, newArray, 0, this.last);
            this.entries = newArray;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.last * 2 + 2);
        buf.append('{');
        for (int i = 0; i < this.last; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this.entries[i]);
        }
        buf.append('}');
        return buf.toString();
    }
}

