/*
 * Decompiled with CFR 0.152.
 */
package btree4j.indexer;

import btree4j.Value;
import btree4j.indexer.BasicIndexQuery;
import btree4j.utils.collections.IntStack;
import btree4j.utils.lang.Primitives;
import btree4j.utils.lang.StringUtils;
import java.util.ArrayList;

public final class LikeIndexQuery
extends BasicIndexQuery.IndexConditionSW {
    private static final char DEFAULT_ESCAPE = '\\';
    private static final int MATCH = 0;
    private static final int ONE = 1;
    private static final int ANY = 2;
    private final int escapeChar;
    private char[][] _patterns;
    private int[] _types;

    public LikeIndexQuery(Value prefix, String suffix) {
        this(prefix, suffix, '\\');
    }

    public LikeIndexQuery(Value prefix, String suffix, char escape) {
        super(prefix);
        if (suffix == null) {
            throw new IllegalArgumentException("Illegal null suffix");
        }
        this.escapeChar = escape;
        this.initPattern(suffix);
    }

    private void initPattern(String p) {
        int ptnlen = p.length();
        IntStack typeStack = new IntStack(12);
        ArrayList<char[]> patternStack = new ArrayList<char[]>();
        StringBuilder pending = new StringBuilder(64);
        for (int i = 0; i < ptnlen; ++i) {
            char c = p.charAt(i);
            if (c == this.escapeChar) {
                if (i >= ptnlen - 1) {
                    throw new IllegalArgumentException("Illegal like expression: " + p);
                }
                if ((c = p.charAt(++i)) != '%' && c != '_' && c != this.escapeChar) {
                    throw new IllegalArgumentException("Illegal like expression: " + p);
                }
                pending.append(c);
                continue;
            }
            if (c == '%') {
                int lastType;
                if (!typeStack.isEmpty() && (lastType = typeStack.peek()) == 37) continue;
                if (pending.length() > 0) {
                    String s = pending.toString();
                    typeStack.push(0);
                    patternStack.add(StringUtils.getChars(s));
                    pending.setLength(0);
                }
                typeStack.push(2);
                patternStack.add(null);
                continue;
            }
            if (c == '_') {
                if (pending.length() > 0) {
                    String s = pending.toString();
                    typeStack.push(0);
                    patternStack.add(StringUtils.getChars(s));
                    pending.setLength(0);
                }
                typeStack.push(1);
                patternStack.add(null);
                continue;
            }
            pending.append(c);
        }
        if (pending.length() > 0) {
            String s = pending.toString();
            typeStack.push(0);
            patternStack.add(StringUtils.getChars(s));
        }
        this._patterns = (char[][])patternStack.toArray((T[])new char[patternStack.size()][]);
        this._types = typeStack.toArray();
    }

    @Override
    public boolean testValue(Value value) {
        boolean sw = value.startsWith(this._operands[0]);
        if (!sw) {
            return false;
        }
        if (this._types.length == 0) {
            return true;
        }
        byte[] data = value.getData();
        int offset = this._operands[0].getLength();
        int length = data.length - offset;
        char[] target = Primitives.toChars(data, offset, length);
        return LikeIndexQuery.match(target, this._patterns, this._types, 0, 0);
    }

    private static boolean match(char[] target, char[][] verifyPatterns, int[] verifyType, int ti, int pi) {
        int round = verifyType.length;
        int tlimit = target.length;
        while (pi < round) {
            int type = verifyType[pi];
            char[] ptn = verifyPatterns[pi];
            switch (type) {
                case 0: {
                    int ptnlen = ptn.length;
                    if (ti + ptnlen > tlimit) {
                        return false;
                    }
                    for (int j = 0; j < ptnlen; ++j) {
                        if (target[ti++] == ptn[j]) continue;
                        return false;
                    }
                    break;
                }
                case 1: {
                    if (ti++ < tlimit) break;
                    return false;
                }
                case 2: {
                    if (++pi >= round) {
                        return true;
                    }
                    while (ti < tlimit) {
                        if (LikeIndexQuery.match(target, verifyPatterns, verifyType, ti, pi)) {
                            return true;
                        }
                        ++ti;
                    }
                    return false;
                }
                default: {
                    throw new IllegalStateException("Illegal type: " + type);
                }
            }
            ++pi;
        }
        return ti == tlimit;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("prefix: ");
        buf.append(this._operands[0].toString());
        buf.append(", suffix: ");
        for (int i = 0; i < this._types.length; ++i) {
            int type = this._types[i];
            if (type == 2) {
                buf.append('%');
                continue;
            }
            if (type == 1) {
                buf.append('_');
                continue;
            }
            if (type == 0) {
                char[] pattern = this._patterns[i];
                buf.append(pattern);
                continue;
            }
            throw new IllegalStateException("Unexpected type: " + type);
        }
        return buf.toString();
    }
}

