/*
 * Decompiled with CFR 0.152.
 */
package btree4j.utils.codec;

import btree4j.utils.io.FastByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class VariableByteCodec {
    public static int requiredBytes(long val) {
        int i = 1;
        while (val > 127L) {
            val >>= 7;
            ++i;
        }
        return i;
    }

    public static int requiredBytes(int val) {
        int i = 1;
        while (val > 127) {
            val >>= 7;
            ++i;
        }
        return i;
    }

    public static byte[] encodeUnsignedLong(long val) {
        if (val < 0L) {
            throw new IllegalArgumentException("Illegal value: " + val);
        }
        byte[] buf = new byte[9];
        int i = 0;
        while (val > 127L) {
            buf[i++] = (byte)(val & 0x7FL | 0x80L);
            val >>= 7;
        }
        buf[i++] = (byte)val;
        byte[] rbuf = new byte[i];
        System.arraycopy(buf, 0, rbuf, 0, i);
        return rbuf;
    }

    public static void encodeUnsignedLong(long val, byte[] out, int offset) {
        if (val < 0L) {
            throw new IllegalArgumentException("Illegal value: " + val);
        }
        while (val > 127L) {
            out[offset++] = (byte)(val & 0x7FL | 0x80L);
            val >>= 7;
        }
        out[offset++] = (byte)val;
    }

    public static void encodeUnsignedLong(long val, OutputStream os) throws IOException {
        byte b;
        if (val < 0L) {
            throw new IllegalArgumentException("Illegal value: " + val);
        }
        while (val > 127L) {
            b = (byte)(val & 0x7FL | 0x80L);
            os.write(b);
            val >>= 7;
        }
        b = (byte)val;
        os.write(b);
    }

    public static long decodeUnsignedLong(byte[] val) {
        return VariableByteCodec.decodeUnsignedLong(val, 0);
    }

    public static long decodeUnsignedLong(byte[] val, int from) {
        long x = 0L;
        long b = 0L;
        int shift = 0;
        int vlen = val.length;
        for (int i = from; i < vlen; ++i) {
            b = val[i];
            long more = b & 0x80L;
            x |= (b & 0x7FL) << shift;
            if (more != 128L) break;
            shift += 7;
        }
        return x;
    }

    public static long decodeUnsignedLong(InputStream is) throws IOException {
        long x = 0L;
        long b = 0L;
        int shift = 0;
        while (true) {
            b = is.read();
            x |= (b & 0x7FL) << shift;
            long more = b & 0x80L;
            if (more != 128L) break;
            shift += 7;
        }
        return x;
    }

    public static void encodeUnsignedInt(int val, OutputStream os) throws IOException {
        byte b;
        if (val < 0) {
            throw new IllegalArgumentException("Illegal value: " + val);
        }
        while (val > 127) {
            b = (byte)(val & 0x7F | 0x80);
            os.write(b);
            val >>= 7;
        }
        b = (byte)val;
        os.write(b);
    }

    public static int decodeUnsignedInt(InputStream is) throws IOException {
        int x = 0;
        int b = 0;
        int shift = 0;
        while (true) {
            b = is.read();
            x |= (b & 0x7F) << shift;
            if ((b & 0x80) != 128) break;
            shift += 7;
        }
        return x;
    }

    public static int decodeUnsignedInt(InputStream is, int b) throws IOException {
        int x = 0;
        int shift = 0;
        while (true) {
            x |= (b & 0x7F) << shift;
            if ((b & 0x80) != 128) break;
            shift += 7;
            b = is.read();
        }
        return x;
    }

    public static int decodeUnsignedInt(FastByteArrayInputStream is) {
        int x = 0;
        int b = 0;
        int shift = 0;
        while (true) {
            b = is.read();
            x |= (b & 0x7F) << shift;
            if ((b & 0x80) != 128) break;
            shift += 7;
        }
        return x;
    }

    public static int decodeUnsignedInt(byte[] val) {
        return VariableByteCodec.decodeUnsignedInt(val, 0);
    }

    public static int decodeUnsignedInt(byte[] val, int from) {
        int x = 0;
        byte b = 0;
        int shift = 0;
        int vlen = val.length;
        for (int i = from; i < vlen; ++i) {
            b = val[i];
            x |= (b & 0x7F) << shift;
            if ((b & 0x80) != 128) break;
            shift += 7;
        }
        return x;
    }
}

